/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.i18n;

import io.wcm.maven.plugins.i18n.OutputFormat;
import io.wcm.maven.plugins.i18n.SlingI18nMap;
import io.wcm.maven.plugins.i18n.readers.I18nReader;
import io.wcm.maven.plugins.i18n.readers.JsonI18nReader;
import io.wcm.maven.plugins.i18n.readers.PropertiesI18nReader;
import io.wcm.maven.plugins.i18n.readers.XmlI18nReader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.commons.json.JSONException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="transform", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true, threadSafe=true)
public class TransformMojo
extends AbstractMojo {
    private static final String FILE_EXTENSION_JSON = "json";
    private static final String FILE_EXTENSION_XML = "xml";
    private static final String FILE_EXTENSION_PROPERTIES = "properties";
    private static final String[] SOURCE_FILES_INCLUDES = new String[]{"**/*.properties", "**/*.xml", "**/*.json"};
    @Parameter(defaultValue="${basedir}/src/main/resources/i18n")
    private String source;
    @Parameter(defaultValue="SLING-INF/app-root/i18n")
    private String target;
    @Parameter(defaultValue="json")
    private String outputFormat;
    @Parameter(defaultValue="generated-i18n-resources")
    private String generatedResourcesFolderPath;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Component
    private BuildContext buildContext;
    private File generatedResourcesFolder;
    private List<File> i18nSourceFiles;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        OutputFormat selectedOutputFormat = OutputFormat.valueOf(StringUtils.upperCase((String)this.outputFormat));
        try {
            File sourceDirectory = this.getSourceDirectory();
            this.intialize(sourceDirectory);
            if (this.buildContext.isIncremental() && !this.isI18nSourceFileChanged(sourceDirectory)) {
                return;
            }
            List<File> sourceFiles = this.getI18nSourceFiles(sourceDirectory);
            for (File file : sourceFiles) {
                try {
                    String languageKey = FileUtils.removeExtension((String)file.getName());
                    I18nReader reader = this.getI18nReader(file);
                    SlingI18nMap i18nMap = new SlingI18nMap(languageKey, reader.read(file));
                    File targetFile = this.getTargetFile(file, selectedOutputFormat);
                    this.writeTargetI18nFile(i18nMap, targetFile, selectedOutputFormat);
                    this.getLog().info((CharSequence)("Transformed " + file.getPath() + " to  " + targetFile.getPath()));
                }
                catch (IOException | JSONException ex) {
                    throw new MojoFailureException("Unable to transform i18n resource: " + file.getPath(), ex);
                    return;
                }
            }
        }
        catch (IOException ex) {
            throw new MojoFailureException("Failure to transform i18n resources", (Throwable)ex);
        }
    }

    private boolean isI18nSourceFileChanged(File sourceDirectory) {
        Scanner scanner = this.buildContext.newScanner(sourceDirectory);
        Scanner deleteScanner = this.buildContext.newDeleteScanner(sourceDirectory);
        return this.isI18nSourceFileChanged(scanner) || this.isI18nSourceFileChanged(deleteScanner);
    }

    private boolean isI18nSourceFileChanged(Scanner scanner) {
        scanner.setIncludes(SOURCE_FILES_INCLUDES);
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles().length > 0;
    }

    private void intialize(File sourceDirectory) throws IOException {
        this.getLog().debug((CharSequence)"Initializing i18n plugin...");
        if (!this.getI18nSourceFiles(sourceDirectory).isEmpty()) {
            File myGeneratedResourcesFolder = this.getGeneratedResourcesFolder();
            this.addResource(myGeneratedResourcesFolder.getPath(), this.target);
        }
    }

    private void addResource(String generatedResourcesDirectory, String targetPath) {
        Resource resource = new Resource();
        resource.setDirectory(generatedResourcesDirectory);
        resource.setTargetPath(targetPath);
        Build build = this.project.getBuild();
        build.addResource(resource);
        this.getLog().debug((CharSequence)("Added resource: " + resource.getDirectory() + " -> " + resource.getTargetPath()));
    }

    private List<File> getI18nSourceFiles(File sourceDirectory) throws IOException {
        if (this.i18nSourceFiles == null) {
            if (!sourceDirectory.isDirectory()) {
                this.i18nSourceFiles = Collections.emptyList();
            } else {
                String includes = StringUtils.join((Object[])SOURCE_FILES_INCLUDES, (String)",");
                String excludes = FileUtils.getDefaultExcludesAsString();
                this.i18nSourceFiles = FileUtils.getFiles((File)sourceDirectory, (String)includes, (String)excludes);
            }
        }
        return this.i18nSourceFiles;
    }

    private File getSourceDirectory() throws IOException {
        File file = new File(this.source);
        if (!file.isDirectory()) {
            this.getLog().debug((CharSequence)("Could not find directory at '" + this.source + "'"));
        }
        return file.getCanonicalFile();
    }

    private void writeTargetI18nFile(SlingI18nMap i18nMap, File targetfile, OutputFormat selectedOutputFormat) throws IOException, JSONException {
        if (selectedOutputFormat == OutputFormat.XML) {
            FileUtils.fileWrite((File)targetfile, (String)"UTF-8", (String)i18nMap.getI18nXmlString());
        } else {
            FileUtils.fileWrite((File)targetfile, (String)"UTF-8", (String)i18nMap.getI18nJsonString());
        }
        this.buildContext.refresh(targetfile);
    }

    private File getTargetFile(File sourceFile, OutputFormat selectedOutputFormat) throws IOException {
        File sourceDirectory = this.getSourceDirectory();
        String relativePath = StringUtils.substringAfter((String)sourceFile.getAbsolutePath(), (String)sourceDirectory.getAbsolutePath());
        String relativeTargetPath = FileUtils.removeExtension((String)relativePath) + "." + selectedOutputFormat.getFileExtension();
        File jsonFile = new File(this.getGeneratedResourcesFolder().getPath() + relativeTargetPath);
        File parentDirectory = (jsonFile = jsonFile.getCanonicalFile()).getParentFile();
        if (!parentDirectory.exists()) {
            parentDirectory.mkdirs();
            this.buildContext.refresh(parentDirectory);
        }
        return jsonFile;
    }

    private File getGeneratedResourcesFolder() {
        if (this.generatedResourcesFolder == null) {
            String generatedResourcesFolderAbsolutePath = this.project.getBuild().getDirectory() + "/" + this.generatedResourcesFolderPath;
            this.generatedResourcesFolder = new File(generatedResourcesFolderAbsolutePath);
            if (!this.generatedResourcesFolder.exists()) {
                this.generatedResourcesFolder.mkdirs();
                this.buildContext.refresh(this.generatedResourcesFolder);
            }
        }
        return this.generatedResourcesFolder;
    }

    private I18nReader getI18nReader(File sourceFile) throws MojoFailureException {
        String extension = FileUtils.getExtension((String)sourceFile.getName());
        if (StringUtils.equalsIgnoreCase((CharSequence)extension, (CharSequence)FILE_EXTENSION_PROPERTIES)) {
            return new PropertiesI18nReader();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)extension, (CharSequence)FILE_EXTENSION_XML)) {
            return new XmlI18nReader();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)extension, (CharSequence)FILE_EXTENSION_JSON)) {
            return new JsonI18nReader();
        }
        throw new MojoFailureException("Unsupported file extension '" + extension + "': " + sourceFile.getAbsolutePath());
    }
}

