/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.contentpackage;

import com.google.common.collect.ImmutableList;
import io.wcm.maven.plugins.contentpackage.ProxySupport;
import io.wcm.tooling.commons.packmgr.Logger;
import io.wcm.tooling.commons.packmgr.PackageManagerProperties;
import io.wcm.tooling.commons.packmgr.install.VendorInstallerFactory;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;

abstract class AbstractContentPackageMojo
extends AbstractMojo {
    @Parameter(property="vault.file", defaultValue="${project.build.directory}/${project.build.finalName}.zip")
    private File packageFile;
    @Parameter(property="vault.serviceURL", required=true, defaultValue="http://localhost:4502/crx/packmgr/service")
    private String serviceURL;
    @Parameter(property="vault.userId", required=true, defaultValue="admin")
    private String userId;
    @Parameter(property="vault.password", required=true, defaultValue="admin")
    private String password;
    @Parameter(property="vault.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="vault.retryCount", defaultValue="24")
    private int retryCount;
    @Parameter(property="vault.retryDelay", defaultValue="5")
    private int retryDelay;
    @Parameter(property="vault.bundleStatusURL", required=false)
    private String bundleStatusURL;
    @Parameter(property="vault.bundleStatusWaitLimit", defaultValue="360")
    private int bundleStatusWaitLimit;
    @Parameter(property="vault.bundleStatusBlacklistBundleNames", defaultValue="^updater\\.aem.*$")
    private String[] bundleStatusBlacklistBundleNames;
    @Parameter(property="vault.relaxedSSLCheck", defaultValue="false")
    private boolean relaxedSSLCheck;
    @Parameter(property="vault.httpConnectTimeoutSec", defaultValue="10")
    private int httpConnectTimeoutSec;
    @Parameter(property="vault.httpSocketTimeoutSec", defaultValue="60")
    private int httpSocketTimeout;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    AbstractContentPackageMojo() {
    }

    protected final File getPackageFile() {
        return this.packageFile;
    }

    protected final boolean isSkip() {
        return this.skip;
    }

    protected PackageManagerProperties getPackageManagerProperties() throws MojoExecutionException {
        PackageManagerProperties props = new PackageManagerProperties();
        props.setPackageManagerUrl(this.buildPackageManagerUrl());
        props.setUserId(this.userId);
        props.setPassword(this.password);
        props.setRetryCount(this.retryCount);
        props.setRetryDelaySec(this.retryDelay);
        props.setBundleStatusUrl(this.buildBundleStatusUrl());
        props.setBundleStatusWaitLimitSec(this.bundleStatusWaitLimit);
        props.setBundleStatusBlacklistBundleNames((List)ImmutableList.copyOf((Object[])this.bundleStatusBlacklistBundleNames));
        props.setRelaxedSSLCheck(this.relaxedSSLCheck);
        props.setHttpConnectTimeoutSec(this.httpConnectTimeoutSec);
        props.setHttpSocketTimeoutSec(this.httpSocketTimeout);
        props.setProxies(ProxySupport.getMavenProxies(this.session, this.decrypter));
        return props;
    }

    private String buildPackageManagerUrl() throws MojoExecutionException {
        String serviceUrl = this.serviceURL;
        switch (VendorInstallerFactory.identify((String)serviceUrl)) {
            case CRX: {
                serviceUrl = VendorInstallerFactory.getBaseUrl((String)serviceUrl, (Logger)this.getLoggerWrapper()) + "/crx/packmgr/service";
                break;
            }
            case COMPOSUM: {
                serviceUrl = VendorInstallerFactory.getBaseUrl((String)serviceUrl, (Logger)this.getLoggerWrapper()) + "/bin/cpm/";
                break;
            }
            default: {
                throw new MojoExecutionException("Unsupporte service URL: " + serviceUrl);
            }
        }
        return serviceUrl;
    }

    private String buildBundleStatusUrl() throws MojoExecutionException {
        if (StringUtils.equals((CharSequence)this.bundleStatusURL, (CharSequence)"-")) {
            return null;
        }
        if (this.bundleStatusURL != null) {
            return this.bundleStatusURL;
        }
        String baseUrl = VendorInstallerFactory.getBaseUrl((String)this.buildPackageManagerUrl(), (Logger)this.getLoggerWrapper());
        return baseUrl + "/system/console/bundles/.json";
    }

    protected Logger getLoggerWrapper() {
        return new Logger(){

            public void warn(CharSequence message, Throwable t) {
                AbstractContentPackageMojo.this.getLog().warn(message, t);
            }

            public void warn(CharSequence message) {
                AbstractContentPackageMojo.this.getLog().warn(message);
            }

            public boolean isWarnEnabled() {
                return AbstractContentPackageMojo.this.getLog().isWarnEnabled();
            }

            public boolean isInfoEnabled() {
                return AbstractContentPackageMojo.this.getLog().isInfoEnabled();
            }

            public boolean isErrorEnabled() {
                return AbstractContentPackageMojo.this.getLog().isErrorEnabled();
            }

            public boolean isDebugEnabled() {
                return AbstractContentPackageMojo.this.getLog().isDebugEnabled();
            }

            public void info(CharSequence message, Throwable t) {
                AbstractContentPackageMojo.this.getLog().info(message, t);
            }

            public void info(CharSequence message) {
                AbstractContentPackageMojo.this.getLog().info(message);
            }

            public void error(CharSequence message, Throwable t) {
                AbstractContentPackageMojo.this.getLog().error(message, t);
            }

            public void error(CharSequence message) {
                AbstractContentPackageMojo.this.getLog().error(message);
            }

            public void debug(CharSequence message, Throwable t) {
                AbstractContentPackageMojo.this.getLog().debug(message, t);
            }

            public void debug(CharSequence message) {
                AbstractContentPackageMojo.this.getLog().debug(message);
            }
        };
    }
}

