/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.contentpackage;

import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.repository.RepositorySystem;

class ArtifactHelper {
    private final RepositorySystem repository;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;

    ArtifactHelper(RepositorySystem repository, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        this.repository = repository;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
    }

    public File getArtifactFile(String artifactId, String groupId, String version, String packaging, String classifier, String artifact) throws MojoFailureException, MojoExecutionException {
        if ((StringUtils.isEmpty((CharSequence)artifactId) || StringUtils.isEmpty((CharSequence)groupId) || StringUtils.isEmpty((CharSequence)version)) && StringUtils.isEmpty((CharSequence)artifact)) {
            return null;
        }
        Artifact artifactObject = StringUtils.isEmpty((CharSequence)artifactId) ? this.getArtifactFromMavenCoordinates(artifact) : this.createArtifact(artifactId, groupId, version, packaging, classifier);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifactObject);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(this.remoteRepositories);
        ArtifactResolutionResult result = this.repository.resolve(request);
        if (result.isSuccess()) {
            return artifactObject.getFile();
        }
        throw new MojoExecutionException("Unable to download artifact: " + artifactObject.toString());
    }

    private Artifact getArtifactFromMavenCoordinates(String artifact) throws MojoFailureException {
        String version;
        String[] parts = StringUtils.split((String)artifact, (String)":");
        String packaging = null;
        String classifier = null;
        switch (parts.length) {
            case 3: {
                version = parts[2];
                break;
            }
            case 4: {
                packaging = parts[2];
                version = parts[3];
                break;
            }
            case 5: {
                packaging = parts[2];
                classifier = parts[3];
                version = parts[4];
                break;
            }
            default: {
                throw new MojoFailureException("Invalid artifact: " + artifact);
            }
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        return this.createArtifact(artifactId, groupId, version, packaging, classifier);
    }

    private Artifact createArtifact(String artifactId, String groupId, String version, String packaging, String classifier) {
        if (StringUtils.isEmpty((CharSequence)classifier)) {
            return this.repository.createArtifact(groupId, artifactId, version, packaging);
        }
        return this.repository.createArtifactWithClassifier(groupId, artifactId, version, packaging, classifier);
    }
}

