/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.contentpackage;

import io.wcm.maven.plugins.contentpackage.AbstractContentPackageMojo;
import io.wcm.tooling.commons.packmgr.download.PackageDownloader;
import io.wcm.tooling.commons.packmgr.unpack.ContentUnpacker;
import io.wcm.tooling.commons.packmgr.unpack.ContentUnpackerProperties;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="download", defaultPhase=LifecyclePhase.INSTALL, requiresProject=false, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public final class DownloadMojo
extends AbstractContentPackageMojo {
    @Parameter(property="vault.outputFile", required=true, defaultValue="${project.build.directory}/${project.build.finalName}.zip")
    private String outputFile;
    @Parameter(property="vault.unpack", defaultValue="false")
    private boolean unpack;
    @Parameter(property="vault.unpackDirectory", defaultValue="${basedir}")
    private File unpackDirectory;
    @Parameter
    private String[] unpackDeleteDirectories = new String[]{"jcr_root", "META-INF"};
    @Parameter
    private String[] excludeFiles;
    @Parameter
    private String[] excludeNodes;
    @Parameter
    private String[] excludeProperties;
    @Parameter
    private String[] excludeMixins;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            return;
        }
        PackageDownloader downloader = new PackageDownloader(this.getPackageManagerProperties(), this.getLoggerWrapper());
        File outputFileObject = downloader.downloadFile(this.getPackageFile(), this.outputFile);
        if (this.unpack) {
            this.unpackFile(outputFileObject);
        }
    }

    private void unpackFile(File file) throws MojoExecutionException {
        ContentUnpackerProperties props = new ContentUnpackerProperties();
        props.setExcludeFiles(this.excludeFiles);
        props.setExcludeNodes(this.excludeNodes);
        props.setExcludeProperties(this.excludeProperties);
        props.setExcludeMixins(this.excludeMixins);
        ContentUnpacker unpacker = new ContentUnpacker(props);
        if (this.unpackDirectory == null) {
            throw new MojoExecutionException("No unpack directory specified.");
        }
        if (!this.unpackDirectory.exists()) {
            this.unpackDirectory.mkdirs();
        }
        if (this.unpackDeleteDirectories != null) {
            for (String directory : this.unpackDeleteDirectories) {
                File directoryFile = FileUtils.getFile((File)this.unpackDirectory, (String[])new String[]{directory});
                if (!directoryFile.exists() || this.deleteDirectoryWithRetries(directoryFile, 0)) continue;
                throw new MojoExecutionException("Unable to delete existing content from " + directoryFile.getAbsolutePath());
            }
        }
        unpacker.unpack(file, this.unpackDirectory);
        this.getLog().info((CharSequence)("Package unpacked to " + this.unpackDirectory.getAbsolutePath()));
    }

    private boolean deleteDirectoryWithRetries(File directory, int retryCount) {
        if (retryCount > 100) {
            return false;
        }
        if (FileUtils.deleteQuietly((File)directory)) {
            return true;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.deleteDirectoryWithRetries(directory, retryCount + 1);
    }
}

