/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.contentpackage;

import io.wcm.maven.plugins.contentpackage.AbstractContentPackageMojo;
import io.wcm.maven.plugins.contentpackage.ArtifactHelper;
import io.wcm.maven.plugins.contentpackage.PackageFile;
import io.wcm.tooling.commons.packmgr.install.PackageInstaller;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL, requiresProject=false, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public final class InstallMojo
extends AbstractContentPackageMojo {
    @Parameter(property="vault.install", defaultValue="true")
    private boolean install;
    @Parameter(property="vault.force")
    private Boolean force;
    @Parameter(property="vault.recursive", defaultValue="true")
    private boolean recursive;
    @Parameter(property="vault.groupId")
    private String groupId;
    @Parameter(property="vault.artifactId")
    private String artifactId;
    @Parameter(alias="packaging", property="vault.packaging", defaultValue="zip")
    private String type;
    @Parameter(property="vault.version")
    private String version;
    @Parameter(property="vault.classifier")
    private String classifier;
    @Parameter(property="vault.artifact")
    private String artifact;
    @Parameter(property="vault.fileList")
    private String packageFileList;
    @Parameter(property="vault.delayAfterInstallSec")
    private Integer delayAfterInstallSec;
    @Parameter(property="vault.failOnNoFile", defaultValue="true")
    private boolean failOnNoFile;
    @Parameter
    private PackageFile[] packageFiles;
    @Component
    private RepositorySystem repository;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            return;
        }
        ArrayList<io.wcm.tooling.commons.packmgr.install.PackageFile> items = new ArrayList<io.wcm.tooling.commons.packmgr.install.PackageFile>();
        ArtifactHelper helper = new ArtifactHelper(this.repository, this.localRepository, this.remoteRepositories);
        if (this.packageFiles != null && this.packageFiles.length > 0) {
            for (PackageFile ref : this.packageFiles) {
                io.wcm.tooling.commons.packmgr.install.PackageFile item = this.toPackageFile(ref, helper);
                if (item.getFile() == null) continue;
                items.add(item);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.packageFileList)) {
            String[] fileNames;
            for (String fileName : fileNames = StringUtils.split((String)this.packageFileList, (String)",")) {
                File file = new File(fileName);
                items.add(this.toPackageFile(file));
            }
        } else {
            File file = helper.getArtifactFile(this.artifactId, this.groupId, this.version, this.type, this.classifier, this.artifact);
            if (file == null && (file = this.getPackageFile()) != null && !file.exists() && !this.failOnNoFile) {
                file = null;
            }
            if (file != null) {
                items.add(this.toPackageFile(file));
            }
        }
        if (items.isEmpty()) {
            if (this.failOnNoFile) {
                throw new MojoExecutionException("No file found for installing.");
            }
            this.getLog().warn((CharSequence)"No file found for installing.");
        } else {
            PackageInstaller installer = new PackageInstaller(this.getPackageManagerProperties(), this.getLoggerWrapper());
            installer.installFiles(items);
        }
    }

    private io.wcm.tooling.commons.packmgr.install.PackageFile toPackageFile(PackageFile ref, ArtifactHelper helper) throws MojoFailureException, MojoExecutionException {
        io.wcm.tooling.commons.packmgr.install.PackageFile output = new io.wcm.tooling.commons.packmgr.install.PackageFile();
        File file = helper.getArtifactFile(ref.getArtifactId(), ref.getGroupId(), ref.getVersion(), ref.getType(), ref.getClassifier(), ref.getArtifact());
        if (file == null) {
            file = ref.getPackageFile();
        }
        output.setFile(file);
        if (ref.getInstall() != null) {
            output.setInstall(ref.getInstall().booleanValue());
        } else {
            output.setInstall(this.install);
        }
        if (ref.getForce() != null) {
            output.setForce(ref.getForce());
        } else {
            output.setForce(this.force);
        }
        if (ref.getRecursive() != null) {
            output.setRecursive(ref.getRecursive().booleanValue());
        } else {
            output.setRecursive(this.recursive);
        }
        if (ref.getDelayAfterInstallSec() != null) {
            output.setDelayAfterInstallSec(ref.getDelayAfterInstallSec().intValue());
        } else if (this.delayAfterInstallSec != null) {
            output.setDelayAfterInstallSec(this.delayAfterInstallSec.intValue());
        } else {
            output.setDelayAfterInstallSecAutoDetect();
        }
        output.setHttpSocketTimeoutSec(ref.getHttpSocketTimeoutSec());
        return output;
    }

    private io.wcm.tooling.commons.packmgr.install.PackageFile toPackageFile(File file) {
        io.wcm.tooling.commons.packmgr.install.PackageFile output = new io.wcm.tooling.commons.packmgr.install.PackageFile();
        output.setFile(file);
        output.setInstall(this.install);
        output.setForce(this.force);
        output.setRecursive(this.recursive);
        if (this.delayAfterInstallSec != null) {
            output.setDelayAfterInstallSec(this.delayAfterInstallSec.intValue());
        }
        return output;
    }
}

