/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.contentpackage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

final class ProxySupport {
    private ProxySupport() {
    }

    static List<io.wcm.tooling.commons.packmgr.Proxy> getMavenProxies(MavenSession mavenSession, SettingsDecrypter decrypter) {
        if (mavenSession == null || mavenSession.getSettings() == null || mavenSession.getSettings().getProxies() == null || mavenSession.getSettings().getProxies().isEmpty()) {
            return Collections.emptyList();
        }
        List mavenProxies = mavenSession.getSettings().getProxies();
        ArrayList<io.wcm.tooling.commons.packmgr.Proxy> proxies = new ArrayList<io.wcm.tooling.commons.packmgr.Proxy>(mavenProxies.size());
        for (Proxy mavenProxy : mavenProxies) {
            if (!mavenProxy.isActive()) continue;
            Proxy decryptedMavenProxy = ProxySupport.decryptProxy(mavenProxy, decrypter);
            proxies.add(new io.wcm.tooling.commons.packmgr.Proxy(decryptedMavenProxy.getId(), decryptedMavenProxy.getProtocol(), decryptedMavenProxy.getHost(), decryptedMavenProxy.getPort(), decryptedMavenProxy.getUsername(), decryptedMavenProxy.getPassword(), decryptedMavenProxy.getNonProxyHosts()));
        }
        return proxies;
    }

    private static Proxy decryptProxy(Proxy proxy, SettingsDecrypter decrypter) {
        DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(proxy);
        SettingsDecryptionResult decryptedResult = decrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
        return decryptedResult.getProxy();
    }
}

