/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.contentpackage.pack;

import java.util.List;
import org.apache.jackrabbit.vault.packaging.VersionRange;
import org.apache.maven.plugins.annotations.Parameter;

public final class Dependency {
    @Parameter(required=true)
    private String group;
    @Parameter(required=true)
    private String name;
    @Parameter
    private VersionRange versionRange;

    public String getGroup() {
        return this.group;
    }

    public Dependency setGroup(String value) {
        this.group = value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Dependency setName(String value) {
        this.name = value;
        return this;
    }

    public VersionRange getVersion() {
        return this.versionRange;
    }

    public Dependency setVersion(String value) {
        this.versionRange = VersionRange.fromString((String)value);
        return this;
    }

    public String toString() {
        return "Dependency{group='" + this.group + '\'' + ", name='" + this.name + '\'' + ", versionRange=" + this.versionRange + '}';
    }

    private String toVaultPropertyDependency() {
        return this.group + ":" + this.name + (this.versionRange != null ? ":" + this.versionRange.toString() : "");
    }

    static String toString(List<Dependency> dependencies) {
        boolean first = true;
        StringBuilder b = new StringBuilder();
        for (Dependency dependency : dependencies) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(dependency.toVaultPropertyDependency());
        }
        return b.toString();
    }
}

