/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.contentpackage.pack;

import io.wcm.maven.plugins.contentpackage.pack.Filter;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;

public final class Filters {
    private final List<Filter> filters = new ArrayList<Filter>();

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    void merge(DefaultWorkspaceFilter workspaceFilter) {
        for (Filter item : this.filters) {
            PathFilterSet filterSet = this.toFilterSet(item);
            boolean exists = false;
            for (PathFilterSet existingFilterSet : workspaceFilter.getFilterSets()) {
                if (!filterSet.equals((Object)existingFilterSet)) continue;
                exists = true;
            }
            if (exists) continue;
            workspaceFilter.add(filterSet);
        }
    }

    private PathFilterSet toFilterSet(Filter filter) {
        PathFilterSet filterSet = new PathFilterSet(filter.getRoot());
        if (filter.getIncludes() != null) {
            for (String include : filter.getIncludes()) {
                filterSet.addInclude((org.apache.jackrabbit.vault.fs.api.Filter)new DefaultPathFilter(include));
            }
        }
        if (filter.getExcludes() != null) {
            for (String exclude : filter.getExcludes()) {
                filterSet.addExclude((org.apache.jackrabbit.vault.fs.api.Filter)new DefaultPathFilter(exclude));
            }
        }
        return filterSet;
    }
}

