/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.contentpackage.pack;

import io.wcm.maven.plugins.contentpackage.pack.Dependency;
import io.wcm.maven.plugins.contentpackage.pack.EmbeddedBundle;
import io.wcm.maven.plugins.contentpackage.pack.Filters;
import io.wcm.maven.plugins.contentpackage.pack.JcrContentPackageArchiver;
import io.wcm.maven.plugins.contentpackage.pack.NestedPackage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;

@Deprecated
@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class PackageMojo
extends AbstractMojo {
    private static final String ETC_PACKAGES = "/etc/packages";
    private static final String JCR_ROOT = "jcr_root/";
    private static final String PACKAGE_TYPE = "zip";
    private static final String PACKAGE_EXT = ".zip";
    private static final String DEFINITION_FOLDER = "definition";
    private static final String THUMBNAIL_FILE = "thumbnail.png";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String PROPERTY_GROUP = "group";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_VERSION = "version";
    private static final String PROPERTY_GROUP_ID = "groupId";
    private static final String PROPERTY_ARTIFACT_ID = "artifactId";
    private static final String PROPERTY_DEPENDENCIES = "dependencies";
    private static final String PROPERTY_CREATED_BY = "createdBy";
    private static final String PROPERTY_CREATED = "created";
    private static final String PROPERTY_REQUIRES_ROOT = "requiresRoot";
    private static final String PROPERTY_ALLOW_INDEX_DEFINITIONS = "allowIndexDefinitions";
    private static final String PROPERTY_PATH = "path";
    private static final String PROPERTY_AC_HANDLING = "acHandling";
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File builtContentDirectory;
    @Parameter(property="vault.finalName", defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/vault-work", required=true)
    private File workDirectory;
    @Parameter(property="vault.group", defaultValue="${project.groupId}", required=true)
    private String group;
    @Parameter(property="vault.name", defaultValue="${project.artifactId}", required=true)
    private String name;
    @Parameter(property="vault.version", defaultValue="${project.version}", required=true)
    private String version;
    @Parameter(property="vault.requiresRoot", defaultValue="false", required=true)
    private boolean requiresRoot;
    @Parameter(property="vault.allowIndexDefinitions", defaultValue="false", required=true)
    private boolean allowIndexDefinitions;
    @Parameter(property="vault.acHandling", defaultValue="ignore", required=false)
    private String acHandling;
    @Parameter(defaultValue="src/main/package-definition/filter.xml")
    private File filterSource;
    @Parameter
    private final Filters filters = new Filters();
    @Parameter(defaultValue="src/main/package-definition/thumbnail.png")
    private File thumbnailImage;
    @Parameter
    private final List<EmbeddedBundle> embeddeds = new ArrayList<EmbeddedBundle>();
    @Parameter(property="vault.failOnMissingEmbed", defaultValue="false", required=true)
    private boolean failOnMissingEmbed;
    @Parameter
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    @Parameter
    private final List<NestedPackage> subPackages = new ArrayList<NestedPackage>();
    @Parameter
    private final Properties properties = new Properties();
    @Parameter(property="vault.embeddedTarget")
    private String embeddedTarget;

    public void addEmbedded(EmbeddedBundle embeddedBundle) {
        this.embeddeds.add(embeddedBundle);
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addPackage(NestedPackage nestedPackage) {
        this.subPackages.add(nestedPackage);
    }

    public void setEmbeddedTarget(String embeddedTarget) {
        this.embeddedTarget = embeddedTarget.endsWith("/") ? embeddedTarget : embeddedTarget + "/";
    }

    private MavenArchiveConfiguration getMavenArchiveConfiguration() {
        if (this.archive == null) {
            this.archive = new MavenArchiveConfiguration();
            this.archive.setManifest(new ManifestConfiguration());
            this.archive.setAddMavenDescriptor(true);
            this.archive.setCompress(true);
            this.archive.setIndex(false);
            this.archive.getManifest().setAddDefaultSpecificationEntries(true);
            this.archive.getManifest().setAddDefaultImplementationEntries(true);
        }
        return this.archive;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().warn((CharSequence)"Please switch to Jackrabbit filevault-package-maven-plugin - see https://wcm-io.atlassian.net/wiki/x/GYB1BQ");
        try {
            File finalFile = new File(this.outputDirectory, this.finalName + PACKAGE_EXT);
            File vaultFolder = new File(this.workDirectory, "META-INF/vault");
            File vaultDefinitionFolder = new File(vaultFolder, DEFINITION_FOLDER);
            vaultFolder.mkdirs();
            vaultDefinitionFolder.mkdirs();
            JcrContentPackageArchiver jcrContentPackageArchiver = new JcrContentPackageArchiver();
            HashMap<String, File> additionalFiles = new HashMap<String, File>();
            DefaultWorkspaceFilter filter = null;
            filter = this.filterSource != null && this.filterSource.exists() && !this.filterSource.isDirectory() ? this.loadFilter(this.filterSource) : this.loadFilterInFolder(vaultFolder);
            if (this.filters != null) {
                this.filters.merge(filter);
            }
            this.obtainEmbeddedBundles(this.embeddeds, additionalFiles, filter);
            this.obtainNestedPackages(this.subPackages, additionalFiles, filter);
            File filterFile = new File(vaultFolder, "filter.xml");
            filter.resetSource();
            FileUtils.fileWrite((String)filterFile.getAbsolutePath(), (String)filter.getSourceAsString());
            this.writePropertiesFile(vaultFolder);
            this.checkAndCopy(vaultFolder, "config.xml");
            this.checkAndCopy(vaultFolder, "settings.xml");
            this.checkAndCopy(vaultFolder, "definition/.content.xml");
            if (this.thumbnailImage != null && this.thumbnailImage.exists()) {
                FileUtils.copyFile((File)this.thumbnailImage, (File)new File(vaultDefinitionFolder, THUMBNAIL_FILE));
            }
            jcrContentPackageArchiver.addDirectory(this.workDirectory);
            if (this.builtContentDirectory.exists()) {
                jcrContentPackageArchiver.addDirectory(this.builtContentDirectory, FileUtils.normalize((String)JCR_ROOT));
            }
            jcrContentPackageArchiver.setIncludeEmptyDirs(true);
            for (Map.Entry entry : additionalFiles.entrySet()) {
                jcrContentPackageArchiver.addFile((File)entry.getValue(), (String)entry.getKey());
            }
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver((JarArchiver)jcrContentPackageArchiver);
            mavenArchiver.setOutputFile(finalFile);
            mavenArchiver.createArchive(null, this.project, this.getMavenArchiveConfiguration());
            Artifact projectArtifact = this.project.getArtifact();
            projectArtifact.setFile(finalFile);
            projectArtifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler(PACKAGE_TYPE));
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private void obtainEmbeddedBundles(List<EmbeddedBundle> embeddedBundleList, Map<String, File> resultList, DefaultWorkspaceFilter filter) throws MojoFailureException {
        for (EmbeddedBundle embeddedBundle : embeddedBundleList) {
            String embeddedTargetPath;
            List<Artifact> artifacts = embeddedBundle.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                if (this.failOnMissingEmbed) {
                    throw new MojoFailureException("Embedded artifact: '" + embeddedBundle + "' but no dependency artifact found. Add the missing dependency or adjust the embedded definition.");
                }
                this.getLog().warn((CharSequence)("No matching artifacts found for '" + embeddedBundle + "'"));
                continue;
            }
            if (embeddedBundle.getDestFileName() != null && artifacts.size() > 1) {
                this.getLog().warn((CharSequence)("Destination File Name defined but several artifacts match the '" + embeddedBundle + "'"));
            }
            if ((embeddedTargetPath = embeddedBundle.getTarget()) == null && (embeddedTargetPath = this.embeddedTarget) == null) {
                embeddedTargetPath = "/apps/bundles/install/";
                this.getLog().info((CharSequence)("No target path set for '" + embeddedBundle + "'. Using default '" + embeddedTargetPath + "'"));
            }
            embeddedTargetPath = this.resolvePath(embeddedTargetPath);
            embeddedTargetPath = JCR_ROOT + embeddedTargetPath;
            embeddedTargetPath = FileUtils.normalize((String)embeddedTargetPath);
            this.getLog().info((CharSequence)("Embedding Bundle '" + embeddedBundle + "'"));
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                String destinationFileName = embeddedBundle.getDestFileName();
                if (destinationFileName == null) {
                    destinationFileName = source.getName();
                }
                String targetPathName = embeddedTargetPath + destinationFileName;
                resultList.put(targetPathName, source);
                String targetNodePathName = targetPathName.substring(JCR_ROOT.length() - 1);
                if (!embeddedBundle.isGenerateFilter()) continue;
                filter.add(new PathFilterSet(targetNodePathName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void obtainNestedPackages(List<NestedPackage> nestedPackageList, Map<String, File> resultList, DefaultWorkspaceFilter filter) throws IOException {
        for (NestedPackage nestedPackage : nestedPackageList) {
            List<Artifact> artifacts = nestedPackage.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                this.getLog().warn((CharSequence)("No matching artifacts for nested package: '" + nestedPackage + "'"));
                continue;
            }
            this.getLog().info((CharSequence)("Adding Nested Package '" + nestedPackage + "'"));
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                ZipFile zipFile = null;
                InputStream in = null;
                Properties props = new Properties();
                try {
                    zipFile = new ZipFile(source, 1);
                    ZipEntry zipEntry = zipFile.getEntry("META-INF/vault/properties.xml");
                    if (zipEntry == null) {
                        this.getLog().error((CharSequence)"Package is invalid as it does not contain properties.xml");
                        throw new IOException("properties.xml missing in nested package: " + source.getName());
                    }
                    in = zipFile.getInputStream(zipEntry);
                    props.loadFromXML(in);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (zipFile != null) {
                    zipFile.close();
                }
                PackageId pid = new PackageId(props.getProperty(PROPERTY_GROUP), props.getProperty(PROPERTY_NAME), props.getProperty(PROPERTY_VERSION));
                String targetNodePathName = pid.getInstallationPath() + PACKAGE_EXT;
                String targetPathName = "jcr_root" + targetNodePathName;
                resultList.put(targetPathName, source);
                this.getLog().info((CharSequence)("Embedding " + artifact.getId() + " -> " + targetPathName));
                if (!nestedPackage.isGenerateFilter()) continue;
                filter.add(new PathFilterSet(targetNodePathName));
            }
        }
    }

    private void writePropertiesFile(File vaultFolder) throws IOException {
        Properties vaultProperties = new Properties();
        String description = this.project.getDescription();
        if (description == null && (description = this.project.getName()) == null) {
            description = this.project.getArtifactId();
        }
        vaultProperties.put("description", description);
        for (Object propertyKey : this.properties.keySet()) {
            if (this.properties.get(propertyKey) != null) continue;
            this.properties.put(propertyKey, "");
        }
        vaultProperties.putAll((Map<?, ?>)this.properties);
        vaultProperties.put(PROPERTY_GROUP, this.group);
        vaultProperties.put(PROPERTY_NAME, this.name);
        vaultProperties.put(PROPERTY_VERSION, this.version);
        vaultProperties.put(PROPERTY_GROUP_ID, this.project.getGroupId());
        vaultProperties.put(PROPERTY_ARTIFACT_ID, this.project.getArtifactId());
        if (!this.dependencies.isEmpty()) {
            vaultProperties.put(PROPERTY_DEPENDENCIES, Dependency.toString(this.dependencies));
        }
        if (!vaultProperties.containsKey(PROPERTY_CREATED_BY)) {
            vaultProperties.put(PROPERTY_CREATED_BY, System.getProperty("user.name"));
        }
        vaultProperties.put(PROPERTY_CREATED, DATE_FORMAT.format(new Date()));
        vaultProperties.put(PROPERTY_REQUIRES_ROOT, String.valueOf(this.requiresRoot));
        vaultProperties.put(PROPERTY_ALLOW_INDEX_DEFINITIONS, String.valueOf(this.allowIndexDefinitions));
        vaultProperties.put(PROPERTY_PATH, "/etc/packages/" + this.group + "/" + this.name + PACKAGE_EXT);
        vaultProperties.put(PROPERTY_AC_HANDLING, StringUtils.lowerCase((String)this.acHandling));
        try (FileOutputStream fos = new FileOutputStream(new File(vaultFolder, "properties.xml"));
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            vaultProperties.storeToXML(bos, this.project.getName());
        }
    }

    private String resolvePath(String path) {
        String answer = path;
        if (!answer.startsWith("/")) {
            answer = "/" + path;
            this.getLog().info((CharSequence)("Relative path resolved to " + answer));
        }
        return answer;
    }

    private File getFileFromFolder(File folder, final String fileName) {
        File answer = null;
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String itemName) {
                return itemName.equals(fileName);
            }
        });
        if (files.length > 0) {
            answer = files[0];
        }
        return answer;
    }

    private void checkAndCopy(File vaultFolder, String fileName) throws IOException {
        InputStream ios;
        if (this.getFileFromFolder(vaultFolder, fileName) == null && (ios = ((Object)((Object)this)).getClass().getResourceAsStream("/vault-file-templates/" + fileName)) != null) {
            FileOutputStream fos = new FileOutputStream(new File(vaultFolder, fileName));
            IOUtils.copy((InputStream)ios, (OutputStream)fos);
            IOUtils.closeQuietly((InputStream)ios);
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private DefaultWorkspaceFilter loadFilterInFolder(File vaultFolder) throws IOException, ConfigurationException {
        return this.loadFilter(vaultFolder != null && vaultFolder.exists() && vaultFolder.isDirectory() ? new File(vaultFolder, "filter.xml") : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultWorkspaceFilter loadFilter(File filterFile) throws IOException, ConfigurationException {
        DefaultWorkspaceFilter answer = null;
        FileInputStream in = null;
        try {
            if (filterFile != null && filterFile.exists() && !filterFile.isDirectory()) {
                in = new FileInputStream(filterFile);
            }
            if (in != null) {
                answer = new DefaultWorkspaceFilter();
                answer.load(in);
            }
        }
        finally {
            if (in != null) {
                IOUtils.closeQuietly(in);
            }
        }
        if (answer == null) {
            answer = new DefaultWorkspaceFilter();
        }
        return answer;
    }
}

