package io.xiaper.core.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * @author xiaper.io on 2018/12/29
 */
@Configuration
public class ByteDeskConfig {

    private String version;

    @Value("${upload.dir.path}")
    private String uploadDirPath;

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public Path uploadDirPath() {
        return Paths.get(uploadDirPath);
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}
