package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.*;
import io.xiaper.jpa.repository.*;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.rest.controller.v1.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.*;

/**
 * 问卷
 *
 * @author xiaper.io
 */
@RestController
@RequestMapping("/api/questionnaire")
public class QuestionnaireController extends BaseController {

    @Autowired
    UserRepository userRepository;

    @Autowired
    WorkGroupRepository workGroupRepository;

    @Autowired
    QuestionnaireRepository questionnaireRepository;

    @Autowired
    QuestionnaireItemRepository questionnaireItemRepository;

    @Autowired
    QuestionnaireItemItemRepository questionnaireItemItemRepository;

    @Autowired
    QuestionnaireAnswerRepository questionnaireAnswerRepository;

    /**
     * 获取用户全部问卷
     *
     * @param principal principal
     * @return json
     */
    @GetMapping("/all")
    public JsonResult all(Principal principal,
                          @RequestParam(value = "client") String client) {

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {

            Optional<User> userOptional = userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {

                // 查询全部
                List<Questionnaire> questionnaireList = questionnaireRepository.findByUser(userOptional.get());

                //
                jsonResult.setMessage("获取全部问卷成功");
                jsonResult.setStatus_code(200);
                jsonResult.setData(questionnaireList);

            } else {

                jsonResult.setMessage("获取全部问卷失败-当前用户不存在");
                jsonResult.setStatus_code(-2);
                jsonResult.setData(false);
            }

        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }

        return jsonResult;
    }

    /**
     * 查询
     *
     * @param principal principal
     * @return json
     */
    @GetMapping("/query")
    public JsonResult query(Principal principal,
                            @RequestParam(value = "page") int page,
                            @RequestParam(value = "size") int size,
                            @RequestParam(value = "client") String client) {

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {

            Optional<User> userOptional = userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {

                // 分页查询
                Pageable pageable = PageRequest.of(page, size, Sort.Direction.DESC, "id");
                Page<Questionnaire> questionnairePage = questionnaireRepository.findByUser(userOptional.get(), pageable);

                //
                jsonResult.setMessage("分页获取问卷成功");
                jsonResult.setStatus_code(200);
                jsonResult.setData(questionnairePage);

            } else {

                jsonResult.setMessage("分页获取问卷失败-当前用户不存在");
                jsonResult.setStatus_code(-2);
                jsonResult.setData(false);
            }

        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }

        return jsonResult;
    }

    /**
     * 创建
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/create")
    @ResponseBody
    public JsonResult create(Principal principal, @RequestBody Map map) {

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {


        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }

        return jsonResult;
    }

    /**
     * 创建ItemItemAnswer
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/create/item/item/answer")
    @ResponseBody
    public JsonResult createItemItemAnswer(Principal principal, @RequestBody Map map) {

        String qid = (String) map.get("qid");
        String content = (String) map.get("content");

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {

            Optional<User> userOptional = userRepository.findByUsername(principal.getName());

            Optional<QuestionnaireItemItem> questionnaireItemItemOptional = questionnaireItemItemRepository.findByQid(qid);
            if (questionnaireItemItemOptional.isPresent()) {

                // 保存
                QuestionnaireAnswer questionnaireAnswer = new QuestionnaireAnswer();
                questionnaireAnswer.setQid(JpaUtil.randomId());
                questionnaireAnswer.setInputContent(content);
                // FIXME: 去掉此字段依赖
                questionnaireAnswer.setQuestionnaireItem(questionnaireItemItemOptional.get().getQuestionnaireItem());
                // FIXME: 去掉此字段依赖
                questionnaireAnswer.setQuestionnaireItemItem(questionnaireItemItemOptional.get());
                questionnaireAnswer.setUser(userOptional.get());
                questionnaireAnswerRepository.save(questionnaireAnswer);

                // 保存
                questionnaireItemItemOptional.get().getQuestionnaireAnswers().add(questionnaireAnswer);
                questionnaireItemItemRepository.save(questionnaireItemItemOptional.get());

                //
                jsonResult.setMessage("创建ItemItemAnswer成功");
                jsonResult.setStatus_code(200);
                jsonResult.setData(questionnaireAnswer);

            } else {

                jsonResult.setMessage("access token invalid");
                jsonResult.setStatus_code(-2);
                jsonResult.setData(false);
            }

        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }

        return jsonResult;
    }

    /**
     * 删除ItemItemAnswer
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/delete/item/item/answer")
    @ResponseBody
    public JsonResult deleteItemItemAnswer(Principal principal, @RequestBody Map map) {

        String qid = (String) map.get("qid");

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {

            //
            Optional<QuestionnaireAnswer> questionnaireAnswerOptional = questionnaireAnswerRepository.findByQid(qid);
            if (questionnaireAnswerOptional.isPresent()) {

                //
                QuestionnaireItemItem questionnaireItemItem = questionnaireAnswerOptional.get().getQuestionnaireItemItem();
                questionnaireItemItem.getQuestionnaireAnswers().remove(questionnaireAnswerOptional.get());
                questionnaireItemItemRepository.save(questionnaireItemItem);

                // 保存
                questionnaireAnswerRepository.delete(questionnaireAnswerOptional.get());

                //
                jsonResult.setMessage("删除ItemItemAnswer成功");
                jsonResult.setStatus_code(200);
                jsonResult.setData(qid);

            } else {

                jsonResult.setMessage("删除ItemItemAnswer失败-qid不存在");
                jsonResult.setStatus_code(-2);
                jsonResult.setData(false);
            }


        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }

        return jsonResult;
    }

    /**
     * 获取相应工作组
     *
     * @param principal principal
     * @param qid qid
     * @param client client
     * @return json
     */
    @GetMapping("/query/item/item/workGroup")
    public JsonResult queryItemItemWorkGroup(Principal principal,
                                             @RequestParam(value = "qid") String qid,
                                             @RequestParam(value = "client") String client) {

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {

            Optional<QuestionnaireItemItem> questionnaireItemItemOptional = questionnaireItemItemRepository.findByQid(qid);
            if (questionnaireItemItemOptional.isPresent()) {

                //
                Map<String, Set<WorkGroup>> workGroupsMap = new HashMap<>(2);
                workGroupsMap.put(qid, questionnaireItemItemOptional.get().getWorkGroups());

                //
                jsonResult.setMessage("获取ItemItemWorkGroup成功");
                jsonResult.setStatus_code(200);
                jsonResult.setData(workGroupsMap);
            }

        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }

        return jsonResult;
    }


    /**
     * 更新ItemItemWorkGroup
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/update/item/item/workGroup")
    @ResponseBody
    public JsonResult updateItemItemWorkGroup(Principal principal, @RequestBody Map map) {

        String qid = (String) map.get("qid");
        List<String> workGroups = (List<String>) map.get("workGroups");
        logger.info("qid {}", qid);

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {

            Optional<QuestionnaireItemItem> questionnaireItemItemOptional = questionnaireItemItemRepository.findByQid(qid);
            if (questionnaireItemItemOptional.isPresent()) {

                //
                questionnaireItemItemOptional.get().getWorkGroups().clear();
                Iterator workGroupIterator = workGroups.iterator();
                while (workGroupIterator.hasNext()) {
                    String wid = (String) workGroupIterator.next();
                    //
                    Optional<WorkGroup> workGroupOptional = workGroupRepository.findByWid(wid);
                    if (workGroupOptional.isPresent()) {
                        //
                        questionnaireItemItemOptional.get().getWorkGroups().add(workGroupOptional.get());
                    }
                }
                // 保存
                questionnaireItemItemRepository.save(questionnaireItemItemOptional.get());

                //
                jsonResult.setMessage("更新ItemItemWorkGroup成功");
                jsonResult.setStatus_code(200);
                jsonResult.setData(questionnaireItemItemOptional.get());

            } else {

                jsonResult.setMessage("更新ItemItemWorkGroup失败-qid错误");
                jsonResult.setStatus_code(-2);
                jsonResult.setData(false);
            }

        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }

        return jsonResult;
    }


    /**
     * 删除ItemItemWorkGroup
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/delete/item/item/workGroup")
    @ResponseBody
    public JsonResult deleteItemItemWorkGroup(Principal principal, @RequestBody Map map) {

        String qid = (String) map.get("qid");
        String wid = (String) map.get("wid");

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {

            //
            Optional<QuestionnaireItemItem> questionnaireItemItemOptional = questionnaireItemItemRepository.findByQid(qid);
            if (questionnaireItemItemOptional.isPresent()) {

                //
                Optional<WorkGroup> workGroupOptional = workGroupRepository.findByWid(wid);
                if (workGroupOptional.isPresent()) {

                    questionnaireItemItemOptional.get().getWorkGroups().remove(workGroupOptional.get());
                }
                questionnaireItemItemRepository.save(questionnaireItemItemOptional.get());

                //
                jsonResult.setMessage("删除ItemItemWorkGroup成功");
                jsonResult.setStatus_code(200);
                jsonResult.setData(qid);

            } else {

                jsonResult.setMessage("删除ItemItemAnswer失败-qid不存在");
                jsonResult.setStatus_code(-2);
                jsonResult.setData(false);
            }

        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }

        return jsonResult;
    }


    /**
     * 更新
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/update")
    @ResponseBody
    public JsonResult update(Principal principal, @RequestBody Map map) {


        JsonResult jsonResult = new JsonResult();

        if (principal != null) {



        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }


        return jsonResult;
    }


    /**
     * 删除
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/delete")
    @ResponseBody
    public JsonResult delete(Principal principal, @RequestBody Map map) {

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {



        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }


        return jsonResult;
    }


    /**
     * 搜索
     *
     * @param principal principal
     * @return json
     */
    @GetMapping("/filter")
    public JsonResult filter(Principal principal,
                             @RequestParam(value = "page") int page,
                             @RequestParam(value = "size") int size,

                             @RequestParam(value = "content") String content,
                             @RequestParam(value = "client") String client) {

        JsonResult jsonResult = new JsonResult();

        if (principal != null) {



        }  else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData("failed");
        }

        return jsonResult;
    }

}
