package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Tag;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.TagRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.jpa.model.Tag;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.TagRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 标签
 *
 * @author xiaper.io
 */
@RestController
@RequestMapping("/api/tag")
public class TagController {

    @Autowired
    UserRepository userRepository;

    @Autowired
    TagRepository tagRepository;

    /**
     * 请求机器人分类，
     * 注：用标签代替分类
     *
     * @param principal principal
     * @param robot robot
     * @return json
     */
    @GetMapping("/get")
    public JsonResult tags(Principal principal,
                           @RequestParam(value = "robot") boolean robot) {

        Optional<User> userOptional = userRepository.findByUsername(principal.getName());

        JsonResult jsonResult = new JsonResult();

        if (userOptional.isPresent()) {

            jsonResult.setMessage("获取标签成功");
            jsonResult.setStatus_code(200);

            List<Tag> tagList = tagRepository.findByUserAndRobot(userOptional.get(), robot);

            jsonResult.setData(tagList);

        } else {

            jsonResult.setMessage("获取标签失败");
            jsonResult.setStatus_code(-1);
            jsonResult.setData(false);
        }

        return jsonResult;
    }

    /**
     * 创建机器人类别
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/create")
    @ResponseBody
    public JsonResult tagCreate(Principal principal, @RequestBody Map map) {

        String name = (String) map.get("name");
        boolean robot = (boolean) map.get("robot");

        Optional<User> userOptional = userRepository.findByUsername(principal.getName());

        JsonResult jsonResult = new JsonResult();

        if (userOptional.isPresent()) {

            jsonResult.setMessage("创建标签成功");
            jsonResult.setStatus_code(200);

            Tag tag = new Tag();
            tag.setName(name);
            tag.setRobot(robot);
            tag.setUser(userOptional.get());
            tagRepository.save(tag);

            jsonResult.setData(tag);

        } else {

            jsonResult.setMessage("创建标签失败");
            jsonResult.setStatus_code(-1);
            jsonResult.setData(false);
        }

        return jsonResult;
    }


    /**
     * 给某个用户贴标签
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/make")
    @ResponseBody
    public JsonResult tagMake(Principal principal, @RequestBody Map map) {

        String username = (String) map.get("username");
        String name = (String) map.get("name");
        boolean robot = (boolean) map.get("robot");

        Optional<User> userOptional = userRepository.findByUsername(principal.getName());

        JsonResult jsonResult = new JsonResult();

        if (userOptional.isPresent()) {

            jsonResult.setMessage("标签成功");
            jsonResult.setStatus_code(200);

            Tag tag = new Tag();
            tag.setName(name);
            tag.setRobot(robot);
            tag.setUser(userOptional.get());
            tagRepository.save(tag);

            jsonResult.setData(tag);

        } else {

            jsonResult.setMessage("创建标签失败");
            jsonResult.setStatus_code(-1);
            jsonResult.setData(false);
        }

        return jsonResult;
    }

    /**
     * 删除标签
     *
     * @param principal principal
     * @param map map
     * @return json
     */
    @PostMapping("/delete")
    @ResponseBody
    public JsonResult tagDelete(Principal principal, @RequestBody Map map) {

        Integer tagId = (Integer) map.get("id");

        Optional<User> userOptional = userRepository.findByUsername(principal.getName());

        JsonResult jsonResult = new JsonResult();

        if (userOptional.isPresent()) {

            jsonResult.setMessage("删除标签成功");
            jsonResult.setStatus_code(200);

            tagRepository.deleteById(Long.valueOf(tagId));

            jsonResult.setData(tagId);

        } else {

            jsonResult.setMessage("删除标签失败");
            jsonResult.setStatus_code(-1);
            jsonResult.setData(false);
        }

        return jsonResult;
    }

    /**
     * 请求用户标签
     *
     * @param principal principal
     * @param username username
     * @return json
     */
    @GetMapping("/user")
    public JsonResult user(Principal principal,
                           @RequestParam(value = "username") String username) {

        JsonResult jsonResult = new JsonResult();


        return jsonResult;
    }






}
