package io.xiaper.restkefu.controller.v2;

import io.xiaper.jpa.constant.BdConstants;
import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.constant.TypeConsts;
import io.xiaper.jpa.model.*;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.repository.*;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.mq.service.ThreadService;
import io.xiaper.rest.controller.v1.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;
import java.util.*;

/**
 * 智能问答，app端接口
 *
 * @author bytedesk.com on 2019/4/7
 */
@RestController
@RequestMapping("/api/v2/answer")
public class AnswerControllerV2 extends BaseController {

    @Autowired
    UserRepository userRepository;

    @Autowired
    WorkGroupRepository workGroupRepository;

    @Autowired
    AnswerRepository answerRepository;

    @Autowired
    MessageRepository messageRepository;

    @Autowired
    AnswerQueryRepository answerQueryRepository;

    @Autowired
    SynonymRepository synonymRepository;

    @Autowired
    ThreadService threadService;


    @GetMapping("/init")
    public JsonResult init(Principal principal,
                           @RequestParam(value = "wid") String workGroupWid,
                           @RequestParam(value = "type") String requestType,
                           @RequestParam(value = "aid") String agentUid,
                           @RequestParam(value = "client") String client) {

        logger.info("workGroupWid: {}, requestType {}, agentUid {}, client: {}",
                workGroupWid, requestType, agentUid, client);

        JsonResult jsonResult = new JsonResult();

        // 检查访客是否存在
        Optional<User> visitorOptional = userRepository.findByUsername(principal.getName());

        // 自助答疑，返回消息
        Message replyMessage = new Message();
        replyMessage.setMid(JpaUtil.randomId());

        Thread thread;
        User admin;
        // 检查是否指定客服
        if (requestType.equals(TypeConsts.THREAD_REQUEST_TYPE_APPOINTED)) {

            // TODO: 判断optional
            // 指定客服
            Optional<User> agentOptional = userRepository.findByUid(agentUid);

            // 首先查找是否已经存在进行中的会话，如果没有则创建
            thread = threadService.getAppointThread(visitorOptional.get(), agentOptional.get(), client);

            //
            replyMessage.setWid(TypeConsts.THREAD_TYPE_APPOINTED);
            admin = agentOptional.get().getAdmin();

        } else {

            // TODO: 判断optional
            Optional<WorkGroup> workGroupOptional = workGroupRepository.findByWid(workGroupWid);

            // 首先查找是否已经存在进行中的会话，如果没有则创建
            thread = threadService.getWorkGroupThread(visitorOptional.get(), workGroupOptional.get(), client);
            //
            replyMessage.setWid(workGroupWid);
            admin = workGroupOptional.get().getUser();
        }
        //
        replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
        replyMessage.setThread(thread);
        replyMessage.setType(TypeConsts.MESSAGE_TYPE_ROBOT);

        // FIXME:支持自定义欢迎语
        // "您好，我是您的智能助理"  + adminOptional.get().getRoBotUser().getNickname()+ ",请问有什么可以帮您的？"
        replyMessage.setContent(admin.getRoBotUser().getWelcomeTip());
        replyMessage.setUser(admin.getRoBotUser());

        // TODO: 携带热门问答5条
        Set<Answer> answers = answerRepository.findTop5ByUserAndRelatedOrderByQueryCountDesc(admin, false);
        replyMessage.setAnswers(answers);

        messageRepository.save(replyMessage);

        // 返回结果
        jsonResult.setMessage("初始化自助答疑成功");
        jsonResult.setStatus_code(200);
        jsonResult.setData(replyMessage);

        return jsonResult;
    }


    @GetMapping("/message")
    public JsonResult message(Principal principal,
                              @RequestParam(value = "wid") String workGroupWid,
                              @RequestParam(value = "type") String requestType,
                              @RequestParam(value = "aid") String agentUid,
                              @RequestParam(value = "content") String content,
                              @RequestParam(value = "client") String client) {

        logger.info("workGroupWid: {}, requestType {}, agentUid {}, client: {}, content: {}",
                workGroupWid, requestType, agentUid, client, content);

        JsonResult jsonResult = new JsonResult();

        // 检查访客是否存在
        Optional<User> visitorOptional = userRepository.findByUsername(principal.getName());

        // 请求消息
        Message queryMessage = new Message();
        queryMessage.setMid(JpaUtil.randomId());

        // 返回消息
        Message replyMessage = new Message();
        replyMessage.setMid(JpaUtil.randomId());

        Thread thread;
        User admin;
        // 检查是否指定客服
        if (requestType.equals(TypeConsts.THREAD_REQUEST_TYPE_APPOINTED)) {

            // 指定客服
            Optional<User> agentOptional = userRepository.findByUid(agentUid);

            // 首先查找是否已经存在进行中的会话，如果没有则创建
            thread = threadService.getAppointThread(visitorOptional.get(), agentOptional.get(), client);
            //
            queryMessage.setWid(TypeConsts.THREAD_TYPE_APPOINTED);
            replyMessage.setWid(TypeConsts.THREAD_TYPE_APPOINTED);
            admin = agentOptional.get().getAdmin();

        } else {

            Optional<WorkGroup> workGroupOptional = workGroupRepository.findByWid(workGroupWid);

            // 首先查找是否已经存在进行中的会话，如果没有则创建
            thread = threadService.getWorkGroupThread(visitorOptional.get(), workGroupOptional.get(), client);
            //
            queryMessage.setWid(workGroupWid);
            replyMessage.setWid(workGroupWid);
            admin = workGroupOptional.get().getUser();
        }

        queryMessage.setClient(client);
        queryMessage.setThread(thread);
        queryMessage.setType(TypeConsts.MESSAGE_TYPE_ROBOT);
        queryMessage.setContent(content);
        queryMessage.setUser(visitorOptional.get());
        messageRepository.save(queryMessage);

        //
        Optional<Answer> answerOptional = answerRepository.findFirstByUserAndQuestionContainingOrAnswerContaining(admin, content, content);
        if (answerOptional.isPresent()) {
            logger.info("1. content {}, answer {}", content, answerOptional.get().getAnswer());

            // 更新查询记录
            AnswerQuery answerQuery = new AnswerQuery();
            answerQuery.setAnswer(answerOptional.get());
            answerQuery.setUser(visitorOptional.get());
            answerQueryRepository.save(answerQuery);

            // 更新问答查询次数
            answerOptional.get().updateQueryCount();
            answerRepository.save(answerOptional.get());

            //
            replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
            replyMessage.setThread(thread);
            replyMessage.setType(TypeConsts.MESSAGE_TYPE_ROBOT);
            replyMessage.setContent(answerOptional.get().getAnswer());
            replyMessage.setAnswer(answerOptional.get());
            replyMessage.setUser(admin.getRoBotUser());

            // TODO: 返回其余相关问题

            messageRepository.save(replyMessage);

            // 组合
            Map<String, Object> objectMap = new HashMap<>(2);
            objectMap.put("query", queryMessage);
            objectMap.put("reply", replyMessage);

            // 返回结果
            jsonResult.setMessage("获取智能问答成功");
            jsonResult.setStatus_code(200);
            jsonResult.setData(objectMap);

        } else {

            // TODO: 匹配相似问法

            // TODO: 添加通过相似词进行匹配

            List<Synonym> synonymList = synonymRepository.findByUser(admin);
            Iterator iterator = synonymList.iterator();
            while (iterator.hasNext()) {
                Synonym synonym = (Synonym) iterator.next();
                //
                if (synonym.getStandard().trim().length() > 0 && content.contains(synonym.getStandard())) {
                    logger.info("2. content: {}, synonym: {}", content, synonym.getStandard());
                    //
                    Optional<Answer> optionalAnswer = answerRepository.findFirstByUserAndQuestionContainingOrAnswerContaining(admin,
                            synonym.getStandard(), synonym.getStandard());
                    if (optionalAnswer.isPresent()) {
                        //
                        // 更新查询记录
                        AnswerQuery answerQuery = new AnswerQuery();
                        answerQuery.setAnswer(optionalAnswer.get());
                        answerQuery.setUser(visitorOptional.get());
                        answerQueryRepository.save(answerQuery);

                        // 更新问答查询次数
                        optionalAnswer.get().updateQueryCount();
                        answerRepository.save(optionalAnswer.get());

                        replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
                        replyMessage.setThread(thread);
                        replyMessage.setType(TypeConsts.MESSAGE_TYPE_ROBOT);
                        replyMessage.setContent(optionalAnswer.get().getAnswer());
                        replyMessage.setAnswer(optionalAnswer.get());
                        replyMessage.setUser(admin.getRoBotUser());

                        // TODO: 返回其余相关问题

                        messageRepository.save(replyMessage);

                        // 组合
                        Map<String, Object> objectMap = new HashMap<>(2);
                        objectMap.put("query", queryMessage);
                        objectMap.put("reply", replyMessage);

                        // 返回结果
                        jsonResult.setMessage("获取智能问答成功");
                        jsonResult.setStatus_code(200);
                        jsonResult.setData(objectMap);

                        // 返回第一个匹配的结果
                        return jsonResult;
                    }

                }

            }

            // 返回消息
            replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
            replyMessage.setThread(thread);
            replyMessage.setType(TypeConsts.MESSAGE_TYPE_ROBOT);
            replyMessage.setContent(BdConstants.DEFAULT_WORK_GROUP_ROBOT_ANSWER_NOT_FOUND);
            replyMessage.setUser(admin.getRoBotUser());
            messageRepository.save(replyMessage);

            // 组合
            Map<String, Object> objectMap = new HashMap<>(2);
            objectMap.put("query", queryMessage);
            objectMap.put("reply", replyMessage);

            // TODO: 返回其他可能相关问题答案

            // 返回结果
            jsonResult.setMessage("获取智能问答失败-未找到相应答案");
            jsonResult.setStatus_code(201);
            jsonResult.setData(objectMap);
        }

        return jsonResult;
    }


}
