package io.xiaper.restkefu.controller.v2;

import io.xiaper.jpa.constant.StatusConsts;
import io.xiaper.jpa.constant.TypeConsts;
import io.xiaper.jpa.model.LeaveMessage;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.LeaveMessageRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WorkGroupRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.rest.controller.v1.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.Map;
import java.util.Optional;

/**
 * 留言，app端接口
 *
 * @author bytedesk.com on 2019/4/7
 */
@RestController
@RequestMapping("/api/v2/leavemsg")
public class LeaveMessageControllerV2 extends BaseController {

    @Autowired
    UserRepository userRepository;

    @Autowired
    WorkGroupRepository workGroupRepository;

    @Autowired
    LeaveMessageRepository leaveMessageRepository;


    /**
     * 大学长留言功能
     *
     * 昵称，所属区域，意向国家或地区
     * email 参数目前不需要
     * @param principal
     * @param map
     * @return
     */
    @PostMapping("/save/dxz")
    @ResponseBody
    public JsonResult saveDxz(Principal principal, @RequestBody Map map) {

        String wid = (String) map.get("wid");
        String aid = (String) map.get("aid");
        String type = (String) map.get("type");
        //
        String mobile = (String) map.get("mobile");
        String email = (String) map.get("email");
        String nickname = (String) map.get("nickname");
        String location = (String) map.get("location");
        String country = (String) map.get("country");
        String content = (String) map.get("content");
        String client = (String) map.get("client");

        JsonResult jsonResult = new JsonResult();

        // 检查内容是否为空
        if (null == mobile || mobile.trim().length() == 0
                || null == content || content.trim().length() == 0) {

            jsonResult.setMessage("留言失败-手机号和留言内容不能为空");
            jsonResult.setStatus_code(-4);
            jsonResult.setData(false);

            return jsonResult;
        }

        //
        if (principal != null) {

            // 访客账号
            Optional<User> visitorOptional = userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {

                // 保存留言
                LeaveMessage leaveMessage = new LeaveMessage();
                leaveMessage.setLid(JpaUtil.randomId());
                leaveMessage.setMobile(mobile);
                leaveMessage.setEmail(email);
                leaveMessage.setContent(content);
                leaveMessage.setType(type);
                leaveMessage.setVisitor(visitorOptional.get());
                leaveMessage.setStatus(StatusConsts.LEAVE_MESSAGE_STATUS_UNCLAIMED);
//                    leaveMessage.setUser(adminOptional.get());
//                    leaveMessage.setSubDomain(adminOptional.get().getSubDomain());

                // 大学长定制字段
                leaveMessage.setNickname(nickname);
                leaveMessage.setLocation(location);
                leaveMessage.setCountry(country);

                if (type.equals(TypeConsts.THREAD_REQUEST_TYPE_APPOINTED)) {
                    // 指定会话留言
                    Optional<User> agentOptional = userRepository.findByUid(aid);
                    if (agentOptional.isPresent()) {
                        leaveMessage.setAgent(agentOptional.get());
                        leaveMessage.setSubDomain(agentOptional.get().getAdmin().getSubDomain());
                    }
                } else {
                    // 工作组会话留言
                    Optional<WorkGroup> workGroupOptional = workGroupRepository.findByWid(wid);
                    if (workGroupOptional.isPresent()) {
                        leaveMessage.setWorkGroup(workGroupOptional.get());
                        leaveMessage.setSubDomain(workGroupOptional.get().getUser().getSubDomain());
                    }
                }
                leaveMessageRepository.save(leaveMessage);

                // 返回结果
                jsonResult.setMessage("留言成功");
                jsonResult.setStatus_code(200);
                jsonResult.setData(leaveMessage);

            } else {

                jsonResult.setMessage("留言失败-访客用户不存在");
                jsonResult.setStatus_code(-3);
                jsonResult.setData(false);
            }

        } else {

            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData(false);
        }

        return jsonResult;

    }

}






