/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.model.Answer;
import io.xiaper.jpa.model.AnswerQuery;
import io.xiaper.jpa.model.AnswerRate;
import io.xiaper.jpa.model.Category;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Synonym;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.AnswerQueryRepository;
import io.xiaper.jpa.repository.AnswerRateRepository;
import io.xiaper.jpa.repository.AnswerRepository;
import io.xiaper.jpa.repository.CategoryRepository;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.SynonymRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/answer"})
public class AnswerController
extends BaseController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    AnswerRepository answerRepository;
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    AnswerRateRepository answerRateRepository;
    @Autowired
    AnswerQueryRepository answerQueryRepository;
    @Autowired
    SynonymRepository synonymRepository;

    @GetMapping(value={"/init"})
    public JsonResult init(Principal principal, @RequestParam(value="uid") String uid, @RequestParam(value="tid") String tid, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            Optional threadOptional = this.threadRepository.findByTid(tid);
            if (visitorOptional.isPresent()) {
                Optional adminOptional = this.userRepository.findByUid(uid);
                if (adminOptional.isPresent()) {
                    Message replyMessage = new Message();
                    replyMessage.setMid(JpaUtil.randomId());
                    if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                        replyMessage.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                    } else {
                        replyMessage.setWid("appointed");
                    }
                    replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
                    replyMessage.setThread((Thread)threadOptional.get());
                    replyMessage.setType("robot");
                    replyMessage.setContent(((User)adminOptional.get()).getRoBotUser().getWelcomeTip());
                    replyMessage.setUser(((User)adminOptional.get()).getRoBotUser());
                    Set answers = this.answerRepository.findTop5ByUserAndRelatedOrderByQueryCountDesc((User)adminOptional.get(), false);
                    replyMessage.setAnswers(answers);
                    this.messageRepository.save((Object)replyMessage);
                    jsonResult.setMessage("\u521d\u59cb\u5316\u81ea\u52a9\u7b54\u7591\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)replyMessage);
                } else {
                    jsonResult.setMessage("\u521d\u59cb\u5316\u81ea\u52a9\u7b54\u7591\u5931\u8d25-uid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u521d\u59cb\u5316\u81ea\u52a9\u7b54\u7591\u5931\u8d25-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("\u521d\u59cb\u5316\u81ea\u52a9\u7b54\u7591\u5931\u8d25-access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/top"})
    public JsonResult top(Principal principal, @RequestParam(value="uid") String uid, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                Optional adminOptional = this.userRepository.findByUid(uid);
                if (adminOptional.isPresent()) {
                    PageRequest pageable = PageRequest.of((int)0, (int)20, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"queryCount"});
                    Page answerPage = this.answerRepository.findByUserAndRelated((User)adminOptional.get(), false, (Pageable)pageable);
                    jsonResult.setMessage("\u83b7\u53d6\u6700\u70ed\u95ee\u7b54\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)answerPage);
                } else {
                    jsonResult.setMessage("\u83b7\u53d6\u6700\u70ed\u95ee\u7b54\u5931\u8d25-uid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u6700\u70ed\u95ee\u7b54\u5931\u8d25-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/query"})
    public JsonResult query(Principal principal, @RequestParam(value="uid") String uid, @RequestParam(value="tid") String tid, @RequestParam(value="aid") String aid, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            Optional userOptional = this.userRepository.findByUid(uid);
            if (visitorOptional.isPresent() && userOptional.isPresent()) {
                Optional threadOptional = this.threadRepository.findByTid(tid);
                if (threadOptional.isPresent()) {
                    Optional answerOptional = this.answerRepository.findByAid(aid);
                    if (answerOptional.isPresent()) {
                        AnswerQuery answerQuery = new AnswerQuery();
                        answerQuery.setAnswer((Answer)answerOptional.get());
                        answerQuery.setUser((User)visitorOptional.get());
                        this.answerQueryRepository.save((Object)answerQuery);
                        ((Answer)answerOptional.get()).updateQueryCount();
                        this.answerRepository.save(answerOptional.get());
                        Message queryMessage = new Message();
                        queryMessage.setMid(JpaUtil.randomId());
                        if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                            queryMessage.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                        } else {
                            queryMessage.setWid("appointed");
                        }
                        queryMessage.setClient(ClientConsts.CLIENT_SYSTEM);
                        queryMessage.setThread((Thread)threadOptional.get());
                        queryMessage.setType("robot");
                        queryMessage.setContent(((Answer)answerOptional.get()).getQuestion());
                        queryMessage.setAnswer((Answer)answerOptional.get());
                        queryMessage.setUser((User)visitorOptional.get());
                        this.messageRepository.save((Object)queryMessage);
                        Message replyMessage = new Message();
                        replyMessage.setMid(JpaUtil.randomId());
                        if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                            replyMessage.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                        } else {
                            replyMessage.setWid("appointed");
                        }
                        replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
                        replyMessage.setThread((Thread)threadOptional.get());
                        replyMessage.setType("robot");
                        replyMessage.setContent(((Answer)answerOptional.get()).getAnswer());
                        replyMessage.setAnswer((Answer)answerOptional.get());
                        replyMessage.setUser(((User)userOptional.get()).getRoBotUser());
                        this.messageRepository.save((Object)replyMessage);
                        HashMap<String, Message> objectMap = new HashMap<String, Message>(2);
                        objectMap.put("query", queryMessage);
                        objectMap.put("reply", replyMessage);
                        jsonResult.setMessage("\u83b7\u53d6\u76f8\u5e94\u95ee\u7b54\u6210\u529f");
                        jsonResult.setStatus_code(200);
                        jsonResult.setData(objectMap);
                    } else {
                        jsonResult.setMessage("\u83b7\u53d6\u76f8\u5e94\u95ee\u7b54\u5931\u8d25-\u95ee\u7b54aid\u4e0d\u5b58\u5728");
                        jsonResult.setStatus_code(-3);
                        jsonResult.setData((Object)false);
                    }
                } else {
                    jsonResult.setMessage("\u83b7\u53d6\u76f8\u5e94\u95ee\u7b54\u5931\u8d25-\u4f1a\u8bddtid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-2);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u76f8\u5e94\u95ee\u7b54\u5931\u8d25-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/message"})
    public JsonResult message(Principal principal, @RequestParam(value="uid") String uid, @RequestParam(value="tid") String tid, @RequestParam(value="content") String content, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            Optional adminOptional = this.userRepository.findByUid(uid);
            if (visitorOptional.isPresent() && adminOptional.isPresent()) {
                Optional threadOptional = this.threadRepository.findByTid(tid);
                if (threadOptional.isPresent()) {
                    Message queryMessage = new Message();
                    queryMessage.setMid(JpaUtil.randomId());
                    if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                        queryMessage.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                    } else {
                        queryMessage.setWid("appointed");
                    }
                    queryMessage.setClient(client);
                    queryMessage.setThread((Thread)threadOptional.get());
                    queryMessage.setType("robot");
                    queryMessage.setContent(content);
                    queryMessage.setUser((User)visitorOptional.get());
                    this.messageRepository.save((Object)queryMessage);
                    Optional answerOptional = this.answerRepository.findFirstByUserAndQuestionContainingOrAnswerContaining((User)adminOptional.get(), content, content);
                    if (answerOptional.isPresent()) {
                        this.logger.info("1. content {}, answer {}", (Object)content, (Object)((Answer)answerOptional.get()).getAnswer());
                        AnswerQuery answerQuery = new AnswerQuery();
                        answerQuery.setAnswer((Answer)answerOptional.get());
                        answerQuery.setUser((User)visitorOptional.get());
                        this.answerQueryRepository.save((Object)answerQuery);
                        ((Answer)answerOptional.get()).updateQueryCount();
                        this.answerRepository.save(answerOptional.get());
                        Message replyMessage = new Message();
                        replyMessage.setMid(JpaUtil.randomId());
                        if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                            replyMessage.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                        } else {
                            replyMessage.setWid("appointed");
                        }
                        replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
                        replyMessage.setThread((Thread)threadOptional.get());
                        replyMessage.setType("robot");
                        replyMessage.setContent(((Answer)answerOptional.get()).getAnswer());
                        replyMessage.setAnswer((Answer)answerOptional.get());
                        replyMessage.setUser(((User)adminOptional.get()).getRoBotUser());
                        this.messageRepository.save((Object)replyMessage);
                        HashMap<String, Message> objectMap = new HashMap<String, Message>(2);
                        objectMap.put("query", queryMessage);
                        objectMap.put("reply", replyMessage);
                        jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u6210\u529f");
                        jsonResult.setStatus_code(200);
                        jsonResult.setData(objectMap);
                    } else {
                        List synonymList = this.synonymRepository.findByUser((User)adminOptional.get());
                        for (Synonym synonym : synonymList) {
                            if (synonym.getStandard().trim().length() <= 0 || !content.contains(synonym.getStandard())) continue;
                            this.logger.info("2. content: {}, synonym: {}", (Object)content, (Object)synonym.getStandard());
                            Optional optionalAnswer = this.answerRepository.findFirstByUserAndQuestionContainingOrAnswerContaining((User)adminOptional.get(), synonym.getStandard(), synonym.getStandard());
                            if (!optionalAnswer.isPresent()) continue;
                            AnswerQuery answerQuery = new AnswerQuery();
                            answerQuery.setAnswer((Answer)optionalAnswer.get());
                            answerQuery.setUser((User)visitorOptional.get());
                            this.answerQueryRepository.save((Object)answerQuery);
                            ((Answer)optionalAnswer.get()).updateQueryCount();
                            this.answerRepository.save(optionalAnswer.get());
                            Message replyMessage = new Message();
                            replyMessage.setMid(JpaUtil.randomId());
                            if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                                replyMessage.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                            } else {
                                replyMessage.setWid("appointed");
                            }
                            replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
                            replyMessage.setThread((Thread)threadOptional.get());
                            replyMessage.setType("robot");
                            replyMessage.setContent(((Answer)optionalAnswer.get()).getAnswer());
                            replyMessage.setAnswer((Answer)optionalAnswer.get());
                            replyMessage.setUser(((User)adminOptional.get()).getRoBotUser());
                            this.messageRepository.save((Object)replyMessage);
                            HashMap<String, Message> objectMap = new HashMap<String, Message>(2);
                            objectMap.put("query", queryMessage);
                            objectMap.put("reply", replyMessage);
                            jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u6210\u529f");
                            jsonResult.setStatus_code(200);
                            jsonResult.setData(objectMap);
                            return jsonResult;
                        }
                        Message replyMessage = new Message();
                        replyMessage.setMid(JpaUtil.randomId());
                        if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                            replyMessage.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                        } else {
                            replyMessage.setWid("appointed");
                        }
                        replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
                        replyMessage.setThread((Thread)threadOptional.get());
                        replyMessage.setType("robot");
                        replyMessage.setContent("\u62b1\u6b49\uff0c\u672a\u627e\u5230\u76f8\u5e94\u7b54\u6848");
                        replyMessage.setUser(((User)adminOptional.get()).getRoBotUser());
                        this.messageRepository.save((Object)replyMessage);
                        HashMap<String, Message> objectMap = new HashMap<String, Message>(2);
                        objectMap.put("query", queryMessage);
                        objectMap.put("reply", replyMessage);
                        jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u5931\u8d25-\u672a\u627e\u5230\u76f8\u5e94\u7b54\u6848");
                        jsonResult.setStatus_code(201);
                        jsonResult.setData(objectMap);
                    }
                } else {
                    jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u5931\u8d25-\u4f1a\u8bddtid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-2);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u5931\u8d25-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/rate"})
    @ResponseBody
    public JsonResult rate(Principal principal, @RequestBody Map map) {
        String uid = (String)map.get("uid");
        String aid = (String)map.get("aid");
        String mid = (String)map.get("mid");
        Boolean rate = (Boolean)map.get("rate");
        String client = (String)map.get("client");
        this.logger.info("uid {}, aid {}, rate {}, client {}", new Object[]{uid, aid, rate, client});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                Optional answerOptional = this.answerRepository.findByAid(aid);
                if (answerOptional.isPresent()) {
                    Optional messageOptional = this.messageRepository.findByMid(mid);
                    if (messageOptional.isPresent()) {
                        Optional answerRateOptional = this.answerRateRepository.findByAnswerAndUser((Answer)answerOptional.get(), (User)visitorOptional.get());
                        if (!answerRateOptional.isPresent()) {
                            AnswerRate answerRate = new AnswerRate();
                            answerRate.setHelpful(rate.booleanValue());
                            answerRate.setMessage((Message)messageOptional.get());
                            answerRate.setAnswer((Answer)answerOptional.get());
                            answerRate.setUser((User)visitorOptional.get());
                            this.answerRateRepository.save((Object)answerRate);
                            ((Answer)answerOptional.get()).rate(rate.booleanValue());
                            this.answerRepository.save(answerOptional.get());
                            jsonResult.setMessage("\u70b9\u8bc4\u95ee\u7b54\u6210\u529f");
                            jsonResult.setStatus_code(200);
                            jsonResult.setData(answerOptional.get());
                        } else {
                            jsonResult.setMessage("\u70b9\u8bc4\u95ee\u7b54\u5931\u8d25-\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7");
                            jsonResult.setStatus_code(-5);
                            jsonResult.setData((Object)aid);
                        }
                    } else {
                        jsonResult.setMessage("\u70b9\u8bc4\u95ee\u7b54\u5931\u8d25-\u6d88\u606f\u8bb0\u5f55mid\u4e0d\u5b58\u5728");
                        jsonResult.setStatus_code(-4);
                        jsonResult.setData((Object)aid);
                    }
                } else {
                    jsonResult.setMessage("\u70b9\u8bc4\u95ee\u7b54\u5931\u8d25-aid\u672a\u627e\u5230");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)aid);
                }
            } else {
                jsonResult.setMessage("\u70b9\u8bc4\u95ee\u7b54\u5931\u8d25-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/get"})
    public JsonResult getAnswers(Principal principal, @RequestParam(value="categoryId") Integer categoryId, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"updatedAt"});
                if (categoryId == 0) {
                    Page answerPage = this.answerRepository.findByUserAndRelated((User)adminOptional.get(), false, (Pageable)pageable);
                    jsonResult.setMessage("\u83b7\u53d6\u9996\u9875\u95ee\u7b54\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)answerPage);
                } else {
                    Optional categoryOptional = this.categoryRepository.findById((Object)categoryId);
                    if (categoryOptional.isPresent()) {
                        Page answerPage = this.answerRepository.findByCategoriesContains((Category)categoryOptional.get(), (Pageable)pageable);
                        jsonResult.setMessage("\u83b7\u53d6\u5206\u7c7b\u95ee\u7b54\u6210\u529f");
                        jsonResult.setStatus_code(200);
                        jsonResult.setData((Object)answerPage);
                    } else {
                        jsonResult.setMessage("\u7c7b\u522bid\u9519\u8bef");
                        jsonResult.setStatus_code(-3);
                        jsonResult.setData((Object)categoryId);
                    }
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public JsonResult create(Principal principal, @RequestBody Map map) {
        String question = (String)map.get("question");
        List relateds = (List)map.get("relateds");
        String answerStr = (String)map.get("answer");
        List categories = (List)map.get("categories");
        this.logger.info("question {}, relateds {}, answer {}, categories {}", new Object[]{question, relateds, answerStr, categories});
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            int i;
            Answer answer = new Answer();
            answer.setAid(JpaUtil.randomId());
            answer.setQuestion(question);
            answer.setAnswer(answerStr);
            answer.setRelated(false);
            for (i = 0; i < relateds.size(); ++i) {
                String quest = (String)relateds.get(i);
                Answer related = new Answer();
                related.setAid(JpaUtil.randomId());
                related.setQuestion(quest);
                related.setAnswer(answerStr);
                related.setRelated(true);
                related.setUser((User)adminOptional.get());
                this.answerRepository.save((Object)related);
                answer.getRelateds().add(related);
            }
            answer.setUser((User)adminOptional.get());
            for (i = 0; i < categories.size(); ++i) {
                Long categoryId = (long)((Integer)categories.get(i));
                Optional categoryOptional = this.categoryRepository.findById((Object)categoryId);
                if (!categoryOptional.isPresent()) continue;
                answer.getCategories().add(categoryOptional.get());
            }
            this.answerRepository.save((Object)answer);
            jsonResult.setMessage("\u521b\u5efa\u667a\u80fd\u95ee\u7b54\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)answer);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public JsonResult update(Principal principal, @RequestBody Map map) {
        String aid = (String)map.get("aid");
        String question = (String)map.get("question");
        List relateds = (List)map.get("relateds");
        String answerStr = (String)map.get("answer");
        List categories = (List)map.get("categories");
        this.logger.info("question {}, relateds {}, answer {}, categories {}", new Object[]{question, relateds, answerStr, categories});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Optional answerOptional = this.answerRepository.findByAid(aid);
                if (adminOptional.isPresent()) {
                    ((Answer)answerOptional.get()).setQuestion(question);
                    ((Answer)answerOptional.get()).setAnswer(answerStr);
                    Set relatedSet = ((Answer)answerOptional.get()).getRelateds();
                    Iterator relatedIterator = relatedSet.iterator();
                    while (relatedIterator.hasNext()) {
                        relatedIterator.next();
                        relatedIterator.remove();
                    }
                    ((Answer)answerOptional.get()).getRelateds().clear();
                    for (int i = 0; i < relateds.size(); ++i) {
                        String quest = (String)relateds.get(i);
                        Answer related = new Answer();
                        related.setAid(JpaUtil.randomId());
                        related.setQuestion(quest);
                        related.setAnswer(answerStr);
                        related.setRelated(true);
                        related.setUser((User)adminOptional.get());
                        this.answerRepository.save((Object)related);
                        ((Answer)answerOptional.get()).getRelateds().add(related);
                    }
                    Set categorySet = ((Answer)answerOptional.get()).getCategories();
                    Iterator categoryIterator = categorySet.iterator();
                    while (categoryIterator.hasNext()) {
                        categoryIterator.next();
                        categoryIterator.remove();
                    }
                    for (int i = 0; i < categories.size(); ++i) {
                        Long categoryId = (long)((Integer)categories.get(i));
                        Optional categoryOptional = this.categoryRepository.findById((Object)categoryId);
                        if (!categoryOptional.isPresent()) continue;
                        ((Answer)answerOptional.get()).getCategories().add(categoryOptional.get());
                    }
                    this.answerRepository.save(answerOptional.get());
                    jsonResult.setMessage("\u66f4\u65b0\u667a\u80fd\u95ee\u7b54\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(answerOptional.get());
                } else {
                    jsonResult.setMessage("\u66f4\u65b0\u667a\u80fd\u95ee\u7b54\u5931\u8d25-aid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public JsonResult delete(Principal principal, @RequestBody Map map) {
        String aid = (String)map.get("aid");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Optional answerOptional = this.answerRepository.findByAid(aid);
                if (adminOptional.isPresent()) {
                    Set relatedSet = ((Answer)answerOptional.get()).getRelateds();
                    Iterator relatedIterator = relatedSet.iterator();
                    while (relatedIterator.hasNext()) {
                        relatedIterator.next();
                        relatedIterator.remove();
                    }
                    Set categorySet = ((Answer)answerOptional.get()).getCategories();
                    Iterator categoryIterator = categorySet.iterator();
                    while (categoryIterator.hasNext()) {
                        categoryIterator.next();
                        categoryIterator.remove();
                    }
                    this.answerRepository.delete(answerOptional.get());
                    jsonResult.setMessage("\u5220\u9664\u667a\u80fd\u95ee\u7b54\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)aid);
                } else {
                    jsonResult.setMessage("\u66f4\u65b0\u667a\u80fd\u95ee\u7b54\u5931\u8d25-aid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u5220\u9664-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

