/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Article;
import io.xiaper.jpa.model.ArticleRate;
import io.xiaper.jpa.model.ArticleRead;
import io.xiaper.jpa.model.Category;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.ArticleRateRepository;
import io.xiaper.jpa.repository.ArticleReadRepository;
import io.xiaper.jpa.repository.ArticleRepository;
import io.xiaper.jpa.repository.CategoryRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/article"})
public class ArticleController
extends BaseController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    ArticleRepository articleRepository;
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    ArticleRateRepository articleRateRepository;
    @Autowired
    ArticleReadRepository articleReadRepository;

    @GetMapping(value={"/get"})
    public JsonResult getArticles(Principal principal, @RequestParam(value="categoryId") Integer categoryId, @RequestParam(value="page") int page, @RequestParam(value="size") int size) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                if (categoryId == 0) {
                    Page articlePage = this.articleRepository.findByUser((User)adminOptional.get(), (Pageable)pageable);
                    jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863\u6210\u529f1");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)articlePage);
                } else {
                    Optional categoryOptional = this.categoryRepository.findById((Object)categoryId);
                    if (categoryOptional.isPresent()) {
                        Page articlePage = this.articleRepository.findByCategoriesContains((Category)categoryOptional.get(), (Pageable)pageable);
                        jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863\u6210\u529f2");
                        jsonResult.setStatus_code(200);
                        jsonResult.setData((Object)articlePage);
                    } else {
                        jsonResult.setMessage("\u7c7b\u522bid\u9519\u8bef");
                        jsonResult.setStatus_code(-3);
                        jsonResult.setData((Object)categoryId);
                    }
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/recommends"})
    public JsonResult getRecommends(Principal principal, @RequestParam(value="uid") String uid, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUid(uid);
            if (adminOptional.isPresent()) {
                List articleList = this.articleRepository.findByUserAndRecommend((User)adminOptional.get(), true);
                jsonResult.setMessage("\u83b7\u53d6\u63a8\u8350\u5e2e\u52a9\u6587\u6863\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)articleList);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u63a8\u8350\u5e2e\u52a9\u6587\u6863\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-1);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public JsonResult create(Principal principal, @RequestBody Map map) {
        String title = (String)map.get("title");
        String content = (String)map.get("content");
        boolean recommend = (Boolean)map.get("recommend");
        boolean markdown = (Boolean)map.get("markdown");
        List categories = (List)map.get("categories");
        this.logger.info("content {}, categories {}", (Object)content, (Object)categories);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Article article = new Article();
                article.setAid(JpaUtil.randomId());
                article.setTitle(title);
                article.setContent(content);
                article.setRecommend(recommend);
                article.setMarkdown(markdown);
                article.setUser((User)adminOptional.get());
                for (int i = 0; i < categories.size(); ++i) {
                    Integer categoryId = (Integer)categories.get(i);
                    Optional categoryOptional = this.categoryRepository.findById((Object)categoryId);
                    if (!categoryOptional.isPresent()) continue;
                    article.getCategories().add(categoryOptional.get());
                }
                this.articleRepository.save((Object)article);
                jsonResult.setMessage("\u521b\u5efa\u5e2e\u52a9\u6587\u6863\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)article);
            } else {
                jsonResult.setMessage("\u521b\u5efa\u5e2e\u52a9\u6587\u6863-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public JsonResult update(Principal principal, @RequestBody Map map) {
        Integer articleId = (Integer)map.get("articleId");
        String title = (String)map.get("title");
        String content = (String)map.get("content");
        boolean recommend = (Boolean)map.get("recommend");
        boolean markdown = (Boolean)map.get("markdown");
        List categories = (List)map.get("categories");
        this.logger.info("content {}, categories {}", (Object)content, (Object)categories);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Optional articleOptional = this.articleRepository.findById((Object)articleId);
                if (articleOptional.isPresent()) {
                    ((Article)articleOptional.get()).setTitle(title);
                    ((Article)articleOptional.get()).setContent(content);
                    ((Article)articleOptional.get()).setRecommend(recommend);
                    ((Article)articleOptional.get()).setMarkdown(markdown);
                    ((Article)articleOptional.get()).getCategories().clear();
                    if (categories != null && categories.size() > 0) {
                        for (int i = 0; i < categories.size(); ++i) {
                            Integer categoryId = (Integer)categories.get(i);
                            Optional categoryOptional = this.categoryRepository.findById((Object)categoryId);
                            if (!categoryOptional.isPresent()) continue;
                            ((Article)articleOptional.get()).getCategories().add(categoryOptional.get());
                        }
                    }
                    this.articleRepository.save(articleOptional.get());
                    jsonResult.setMessage("\u66f4\u65b0\u5e2e\u52a9\u6587\u6863\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(articleOptional.get());
                } else {
                    jsonResult.setMessage("\u66f4\u65b0\u5e2e\u52a9\u6587\u6863\u5931\u8d25-\u6587\u6863\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)articleId);
                }
            } else {
                jsonResult.setMessage("\u66f4\u65b0\u5e2e\u52a9\u6587\u6863-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public JsonResult delete(Principal principal, @RequestBody Map map) {
        Integer articleId = (Integer)map.get("articleId");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                this.articleRepository.deleteById((Object)articleId);
                jsonResult.setMessage("\u5220\u9664\u5e2e\u52a9\u6587\u6863\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)articleId);
            } else {
                jsonResult.setMessage("\u5220\u9664\u5e2e\u52a9\u6587\u6863-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/detail"})
    public JsonResult detail(Principal principal, @RequestParam(value="aid") String aid) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                Optional articleOptional = this.articleRepository.findByAid(aid);
                if (articleOptional.isPresent()) {
                    HashMap<String, Object> objectMap = new HashMap<String, Object>(16);
                    if (articleOptional.isPresent()) {
                        ArticleRead articleRead = new ArticleRead();
                        articleRead.setArticle((Article)articleOptional.get());
                        articleRead.setUser((User)visitorOptional.get());
                        this.articleReadRepository.save((Object)articleRead);
                        ((Article)articleOptional.get()).updateReadCount();
                        this.articleRepository.save(articleOptional.get());
                        Category category = (Category)((Article)articleOptional.get()).getCategories().toArray()[0];
                        PageRequest pageable = PageRequest.of((int)0, (int)20, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"updatedAt"});
                        Page articlePage = this.articleRepository.findByCategoriesContains(category, (Pageable)pageable);
                        objectMap.put("article", articleOptional.get());
                        objectMap.put("related", articlePage.getContent());
                    }
                    jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863\u8be6\u60c5\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(objectMap);
                } else {
                    jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863\u8be6\u60c5\u5931\u8d25-aid\u672a\u627e\u5230");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)aid);
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863\u8be6\u60c5\u5931\u8d25-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/rate"})
    @ResponseBody
    public JsonResult rate(Principal principal, @RequestBody Map map) {
        String uid = (String)map.get("uid");
        String aid = (String)map.get("aid");
        Boolean rate = (Boolean)map.get("rate");
        String client = (String)map.get("client");
        this.logger.info("uid {}, aid {}, rate {}, client {}", new Object[]{uid, aid, rate, client});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                Optional articleOptional = this.articleRepository.findByAid(aid);
                if (articleOptional.isPresent()) {
                    Optional articleRateOptional = this.articleRateRepository.findByArticleAndUser((Article)articleOptional.get(), (User)visitorOptional.get());
                    if (!articleRateOptional.isPresent()) {
                        ArticleRate articleRate = new ArticleRate();
                        articleRate.setHelpful(rate.booleanValue());
                        articleRate.setArticle((Article)articleOptional.get());
                        articleRate.setUser((User)visitorOptional.get());
                        this.articleRateRepository.save((Object)articleRate);
                        ((Article)articleOptional.get()).rate(rate.booleanValue());
                        this.articleRepository.save(articleOptional.get());
                        jsonResult.setMessage("\u70b9\u8bc4\u5e2e\u52a9\u6587\u6863\u6210\u529f");
                        jsonResult.setStatus_code(200);
                        jsonResult.setData(articleOptional.get());
                    } else {
                        jsonResult.setMessage("\u70b9\u8bc4\u5e2e\u52a9\u6587\u6863\u5931\u8d25-\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7");
                        jsonResult.setStatus_code(-4);
                        jsonResult.setData((Object)aid);
                    }
                } else {
                    jsonResult.setMessage("\u70b9\u8bc4\u5e2e\u52a9\u6587\u6863\u5931\u8d25-aid\u672a\u627e\u5230");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)aid);
                }
            } else {
                jsonResult.setMessage("\u70b9\u8bc4\u5e2e\u52a9\u6587\u6863\u5931\u8d25-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

