/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.constant.UserConsts;
import io.xiaper.jpa.model.Browse;
import io.xiaper.jpa.model.BrowseInvite;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.Url;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.BrowseInviteRepository;
import io.xiaper.jpa.repository.BrowseRepository;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UrlRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WorkGroupRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.jpa.util.Util;
import io.xiaper.mq.service.BrowseService;
import io.xiaper.mq.service.MessagingTemplate;
import io.xiaper.mq.service.ThreadService;
import io.xiaper.rest.controller.v1.BaseController;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/browse"})
public class BrowseController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(BrowseController.class);
    @Autowired
    UserRepository userRepository;
    @Autowired
    BrowseRepository browseRepository;
    @Autowired
    HttpServletRequest request;
    @Autowired
    WorkGroupRepository workgroupRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    UrlRepository urlRepository;
    @Autowired
    BrowseInviteRepository browseInviteRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    BrowseService browseService;
    @Autowired
    ThreadService threadService;
    @Autowired
    MessagingTemplate messagingTemplate;

    @GetMapping(value={"/request"})
    public JsonResult request(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page browsePage = this.browseRepository.findByWorkGroup_UserAndActioned((User)adminOptional.get(), null, (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u6d4f\u89c8\u8bbf\u5ba2\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)browsePage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/history"})
    public JsonResult history(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page browsePage = this.browseRepository.findByWorkGroup_UserAndActionedNotNull((User)adminOptional.get(), (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u5386\u53f2\u6d4f\u89c8\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)browsePage);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5386\u53f2\u6d4f\u89c8\u5931\u8d25-\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/notify"})
    @ResponseBody
    public JsonResult notify(Principal principal, @RequestBody Map map) {
        String adminUid = (String)map.get("adminUid");
        String workGroupWid = (String)map.get("workGroupWid");
        String client = (String)map.get("client");
        String sessionId = (String)map.get("sessionId");
        String referrer = (String)map.get("referrer");
        String url = (String)map.get("url");
        String title = (String)map.get("title");
        String keywords = (String)map.get("keywords");
        String description = (String)map.get("description");
        logger.info("adminUid: {}, workGroupId: {}, client: {}, sessionId {}, referrer: {}, url: {}, ip: {}, title {}, keywords {}, description {}", new Object[]{adminUid, workGroupWid, client, sessionId, referrer, url, Util.getIpAddress((HttpServletRequest)this.request), title, keywords, description});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            Optional adminOptional = this.userRepository.findByUid(adminUid);
            Optional workGroupOptional = this.workgroupRepository.findByWid(workGroupWid);
            if (adminOptional.isPresent() && workGroupOptional.isPresent()) {
                Url refererObject;
                Url urlObject;
                Optional urlOptional = this.urlRepository.findByUrl(url);
                if (!urlOptional.isPresent()) {
                    urlObject = new Url();
                    urlObject.setUrl(url);
                } else {
                    urlObject = (Url)urlOptional.get();
                }
                try {
                    urlObject.setTitle(URLDecoder.decode(title, "UTF-8"));
                    urlObject.setKeywords(URLDecoder.decode(keywords, "UTF-8"));
                    urlObject.setDescription(URLDecoder.decode(description, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                this.urlRepository.save((Object)urlObject);
                Optional refererOptional = this.urlRepository.findByUrl(referrer);
                if (!refererOptional.isPresent()) {
                    refererObject = new Url();
                    refererObject.setUrl(referrer);
                    this.urlRepository.save((Object)refererObject);
                } else {
                    refererObject = (Url)refererOptional.get();
                }
                Browse browse = new Browse();
                browse.setBid(JpaUtil.randomId());
                browse.setSessionId(sessionId);
                browse.setReferrer(refererObject);
                browse.setUrl(urlObject);
                browse.setWorkGroup((WorkGroup)workGroupOptional.get());
                browse.setVisitor((User)visitorOptional.get());
                this.browseRepository.save((Object)browse);
                this.browseService.notifyBrowseStart((User)visitorOptional.get(), (WorkGroup)workGroupOptional.get(), browse);
                jsonResult.setMessage("\u8bbf\u5ba2\u6d4f\u89c8\u7f51\u9875\u901a\u77e5\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)true);
            } else {
                jsonResult.setMessage("site or workGroup not exist");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/update/sessionId"})
    @ResponseBody
    public JsonResult updateSessionId(Principal principal, @RequestBody Map map) {
        String sessionId = (String)map.get("sessionId");
        String preSessionId = (String)map.get("preSessionId");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            if (sessionId.trim().length() == 0 || preSessionId.trim().length() == 0) {
                jsonResult.setMessage("sessionId \u6216\u8005 preSessionId \u4e0d\u80fd\u4e3a\u7a7a");
                jsonResult.setStatus_code(-4);
                jsonResult.setData((Object)false);
                return jsonResult;
            }
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                Optional browseOptional = this.browseRepository.findFirstBySessionIdAndVisitor(preSessionId, (User)visitorOptional.get());
                if (browseOptional.isPresent()) {
                    ((Browse)browseOptional.get()).setSessionId(sessionId);
                    this.browseRepository.save(browseOptional.get());
                    jsonResult.setMessage("\u66f4\u65b0sessionId\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)true);
                } else {
                    jsonResult.setMessage("pre session id \u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("username \u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/invite"})
    @ResponseBody
    public JsonResult invite(Principal principal, @RequestBody Map map) {
        String bid = (String)map.get("bid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Optional browseOptional = this.browseRepository.findByBid(bid);
                if (browseOptional.isPresent()) {
                    BrowseInvite browseInvite = new BrowseInvite();
                    browseInvite.setbIid(JpaUtil.randomId());
                    browseInvite.setBrowse((Browse)browseOptional.get());
                    browseInvite.setFromUser((User)userOptional.get());
                    browseInvite.setFromClient(client);
                    browseInvite.setToUser(((Browse)browseOptional.get()).getVisitor());
                    browseInvite.setWorkGroup(((Browse)browseOptional.get()).getWorkGroup());
                    this.browseInviteRepository.save((Object)browseInvite);
                    Message message = new Message();
                    message.setMid(JpaUtil.randomId());
                    message.setWid(((Browse)browseOptional.get()).getWorkGroup().getWid());
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setType("notification_browse_invite");
                    message.setContent("\u9080\u8bf7\u8bbf\u5ba2\u4f1a\u8bdd");
                    message.setBrowseInvite(browseInvite);
                    Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                    message.setUser((User)userNotification.get());
                    this.messageRepository.save((Object)message);
                    this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                    jsonResult.setMessage("\u53d1\u9001\u9080\u8bf7\u8bbf\u5ba2\u4f1a\u8bdd\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)message);
                } else {
                    jsonResult.setMessage("\u9080\u8bf7\u8bbf\u5ba2\u5931\u8d25-uid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u9080\u8bf7\u8bbf\u5ba2\u5931\u8d25-\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/invite/accept"})
    @ResponseBody
    public JsonResult inviteAccept(Principal principal, @RequestBody Map map) {
        String biid = (String)map.get("biid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                Optional browseInviteOptional = this.browseInviteRepository.findByBIid(biid);
                if (browseInviteOptional.isPresent()) {
                    ((BrowseInvite)browseInviteOptional.get()).getBrowse().accept();
                    ((BrowseInvite)browseInviteOptional.get()).setToClient(client);
                    ((BrowseInvite)browseInviteOptional.get()).setAccepted(true);
                    ((BrowseInvite)browseInviteOptional.get()).setActionedAt(new Date());
                    this.browseInviteRepository.save(browseInviteOptional.get());
                    Thread thread = this.threadService.getWorkGroupThread((User)visitorOptional.get(), ((BrowseInvite)browseInviteOptional.get()).getWorkGroup(), client);
                    thread.setAgent(((BrowseInvite)browseInviteOptional.get()).getFromUser());
                    thread.getAgents().add(((BrowseInvite)browseInviteOptional.get()).getFromUser());
                    this.threadRepository.save((Object)thread);
                    Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                    Message message = new Message();
                    message.setMid(JpaUtil.randomId());
                    message.setWid(((BrowseInvite)browseInviteOptional.get()).getWorkGroup().getWid());
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setThread(thread);
                    message.setType("notification_browse_invite_accept");
                    message.setContent("\u63a5\u53d7\u9080\u8bf7\u4f1a\u8bdd");
                    message.setUser((User)userNotification.get());
                    message.setBrowseInvite((BrowseInvite)browseInviteOptional.get());
                    this.messageRepository.save((Object)message);
                    this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                    jsonResult.setMessage("\u63a5\u53d7\u9080\u8bf7\u4f1a\u8bdd\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)thread);
                } else {
                    jsonResult.setMessage("\u8bbf\u5ba2\u63a5\u53d7\u9080\u8bf7\u4f1a\u8bdd-uid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u8bbf\u5ba2\u63a5\u53d7\u9080\u8bf7\u4f1a\u8bdd-\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/invite/reject"})
    @ResponseBody
    public JsonResult inviteReject(Principal principal, @RequestBody Map map) {
        String biid = (String)map.get("biid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                Optional browseInviteOptional = this.browseInviteRepository.findByBIid(biid);
                if (browseInviteOptional.isPresent()) {
                    ((BrowseInvite)browseInviteOptional.get()).setToClient(client);
                    ((BrowseInvite)browseInviteOptional.get()).setAccepted(false);
                    ((BrowseInvite)browseInviteOptional.get()).setActionedAt(new Date());
                    this.browseInviteRepository.save(browseInviteOptional.get());
                    Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                    Message message = new Message();
                    message.setMid(JpaUtil.randomId());
                    message.setWid(((BrowseInvite)browseInviteOptional.get()).getWorkGroup().getWid());
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setType("notification_browse_invite_reject");
                    message.setContent("\u62d2\u7edd\u9080\u8bf7\u4f1a\u8bdd");
                    message.setUser((User)userNotification.get());
                    message.setBrowseInvite((BrowseInvite)browseInviteOptional.get());
                    this.messageRepository.save((Object)message);
                    this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                    jsonResult.setMessage("\u62d2\u7edd\u9080\u8bf7\u4f1a\u8bdd\u6210\u529f");
                    jsonResult.setStatus_code(200);
                } else {
                    jsonResult.setMessage("\u8bbf\u5ba2\u62d2\u7edd\u9080\u8bf7\u4f1a\u8bdd-uid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u8bbf\u5ba2\u62d2\u7edd\u9080\u8bf7\u4f1a\u8bdd-\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="nickname") String nickname, @RequestParam(value="createdAtStart") String createdAtStart, @RequestParam(value="createdAtEnd") String createdAtEnd, @RequestParam(value="workGroupNickname") String workGroupNickname, @RequestParam(value="agentRealName") String agentRealName, @RequestParam(value="client") String client) {
        logger.info("page {}, size {}, nickname {}, createdAtStart {}, createdAtEnd {}, wgNickname {}, agentRealName {}, client {}", new Object[]{page, size, nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Specification specification = this.getSpecification((User)adminOptional.get(), "browse", nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client);
                Page browsePage = this.browseRepository.findAll(specification, (Pageable)pageable);
                jsonResult.setMessage("\u641c\u7d22\u6d4f\u89c8\u8bb0\u5f55\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)browsePage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

