/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Article;
import io.xiaper.jpa.model.Category;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.ArticleRepository;
import io.xiaper.jpa.repository.CategoryRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/category"})
public class CategoryController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UserRepository userRepository;
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    ArticleRepository articleRepository;

    @GetMapping(value={"/all"})
    public JsonResult all(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Set categorySet = this.categoryRepository.findByUserAndParent((User)adminOptional.get(), null);
                for (Category category : categorySet) {
                    Set children = this.categoryRepository.findByUserAndParent((User)adminOptional.get(), category);
                    category.setChildren(children);
                }
                jsonResult.setMessage("\u83b7\u53d6\u5168\u90e8\u7c7b\u522b/\u5206\u7ec4\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)categorySet);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5168\u90e8\u7c7b\u522b\u5206\u7ec4\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/robot"})
    public JsonResult robot(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Set categorySet = this.categoryRepository.findByUserAndTypeAndParent((User)adminOptional.get(), "robot", null);
                for (Category category : categorySet) {
                    Set children = this.categoryRepository.findByUserAndTypeAndParent((User)adminOptional.get(), "robot", category);
                    category.setChildren(children);
                }
                jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u7c7b\u522b/\u5206\u7ec4\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)categorySet);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u7c7b\u522b\u5206\u7ec4\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/support"})
    public JsonResult support(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Set categorySet = this.categoryRepository.findByUserAndTypeAndParent((User)adminOptional.get(), "support", null);
                for (Category category : categorySet) {
                    Set children = this.categoryRepository.findByUserAndTypeAndParent((User)adminOptional.get(), "support", category);
                    category.setChildren(children);
                }
                jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u7c7b\u522b/\u5206\u7ec4\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)categorySet);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u7c7b\u522b\u5206\u7ec4\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/feedback"})
    public JsonResult feedback(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Set categorySet = this.categoryRepository.findByUserAndTypeAndParent((User)adminOptional.get(), "feedback", null);
                for (Category category : categorySet) {
                    Set children = this.categoryRepository.findByUserAndTypeAndParent((User)adminOptional.get(), "feedback", category);
                    category.setChildren(children);
                }
                jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u7c7b\u522b/\u5206\u7ec4\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)categorySet);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u7c7b\u522b\u5206\u7ec4\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/cuw/company"})
    public JsonResult cuwCompany(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Set categorySet = this.categoryRepository.findByUserAndTypeAndParent((User)adminOptional.get(), "cuw_company", null);
                for (Category category : categorySet) {
                    Set children = this.categoryRepository.findByUserAndTypeAndParent((User)adminOptional.get(), "cuw_company", category);
                    category.setChildren(children);
                }
                jsonResult.setMessage("\u83b7\u53d6\u516c\u53f8\u5e38\u7528\u8bed\u7c7b\u522b/\u5206\u7ec4\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)categorySet);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u516c\u53f8\u5e38\u7528\u8bed\u7c7b\u522b\u5206\u7ec4\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public JsonResult create(Principal principal, @RequestBody Map map) {
        Integer parentId = (Integer)map.get("parentId");
        String name = (String)map.get("name");
        String type = (String)map.get("type");
        this.logger.info("parent_id {}, name {}", (Object)parentId, (Object)name);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Optional parentCategoryOptional;
                Category category = new Category();
                category.setCid(JpaUtil.randomId());
                category.setType(type);
                category.setName(name);
                category.setUser((User)adminOptional.get());
                if (parentId != null && parentId != 0 && (parentCategoryOptional = this.categoryRepository.findById((Object)parentId)).isPresent()) {
                    category.setParent((Category)parentCategoryOptional.get());
                }
                this.categoryRepository.save((Object)category);
                jsonResult.setMessage("\u521b\u5efa\u7c7b\u522b/\u5206\u7ec4\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)category);
            } else {
                jsonResult.setMessage("\u521b\u5efa\u7c7b\u522b/\u5206\u7ec4\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("\u521b\u5efa\u7c7b\u522b/\u5206\u7ec4\u5931\u8d25-access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public JsonResult update(Principal principal, @RequestBody Map map) {
        Integer categoryId = (Integer)map.get("categoryId");
        String name = (String)map.get("name");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Optional categoryOptional = this.categoryRepository.findById((Object)categoryId);
                if (categoryOptional.isPresent()) {
                    ((Category)categoryOptional.get()).setName(name);
                    this.categoryRepository.save(categoryOptional.get());
                    jsonResult.setMessage("\u66f4\u65b0\u7c7b\u522b/\u5206\u7ec4\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(categoryOptional.get());
                } else {
                    jsonResult.setMessage("\u66f4\u65b0\u7c7b\u522b/\u5206\u7ec4\u5931\u8d25-\u7c7b\u522b\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)categoryId);
                }
            } else {
                jsonResult.setMessage("\u66f4\u65b0\u7c7b\u522b/\u5206\u7ec4\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public JsonResult delete(Principal principal, @RequestBody Map map) {
        Integer categoryId = (Integer)map.get("categoryId");
        this.logger.info("category id {}", (Object)categoryId);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Optional categoryOptional = this.categoryRepository.findById((Object)categoryId);
                if (categoryOptional.isPresent()) {
                    List articleList = this.articleRepository.findByCategoriesContainsOrderByIdDesc((Category)categoryOptional.get());
                    for (Article article : articleList) {
                        article.getCategories().remove(categoryOptional.get());
                        this.articleRepository.save((Object)article);
                    }
                    this.categoryRepository.delete(categoryOptional.get());
                    jsonResult.setMessage("\u5220\u9664\u7c7b\u522b/\u5206\u7ec4\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(categoryOptional.get());
                } else {
                    jsonResult.setMessage("\u5220\u9664\u7c7b\u522b/\u5206\u7ec4\u5931\u8d25-\u7c7b\u522bid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)categoryId);
                }
            } else {
                jsonResult.setMessage("\u5220\u9664\u7c7b\u522b/\u5206\u7ec4\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)categoryId);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)categoryId);
        }
        return jsonResult;
    }

    @GetMapping(value={"/detail"})
    public JsonResult detail(Principal principal, @RequestParam(value="cid") String cid) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Optional categoryOptional = this.categoryRepository.findByCid(cid);
                if (categoryOptional.isPresent()) {
                    HashMap<String, Object> objectMap = new HashMap<String, Object>(2);
                    objectMap.put("category", categoryOptional.get());
                    objectMap.put("articles", ((Category)categoryOptional.get()).getArticles());
                    jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863\u7c7b\u522b\u8be6\u60c5\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(objectMap);
                } else {
                    jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863\u7c7b\u522b\u8be6\u60c5\u5931\u8d25-\u7c7b\u522b\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)cid);
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5e2e\u52a9\u6587\u6863\u7c7b\u522b\u8be6\u60c5\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/search"})
    public JsonResult search(Principal principal, @RequestParam(value="content") String content) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)0, (int)20, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page articlePage = this.articleRepository.findByTitleContainingOrContentContaining(content, content, (Pageable)pageable);
                jsonResult.setMessage("\u641c\u7d22\u5e2e\u52a9\u6587\u6863\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)articlePage);
            } else {
                jsonResult.setMessage("\u641c\u7d22\u5e2e\u52a9\u6587\u6863\u5931\u8d25-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

