/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Category;
import io.xiaper.jpa.model.Cuw;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.CategoryRepository;
import io.xiaper.jpa.repository.CuwRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cuw"})
public class CuwController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UserRepository userRepository;
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    CuwRepository cuwRepository;

    @GetMapping(value={"/get"})
    public JsonResult get(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            Set platformCategorySet = this.categoryRepository.findByType("cuw_platform");
            for (Category category : platformCategorySet) {
                Set cuwSet = this.cuwRepository.findByCategory(category);
                category.setCuwChildren(cuwSet);
            }
            User admin = ((User)userOptional.get()).getAdmin();
            Set companyCategorySet = this.categoryRepository.findByTypeAndUser("cuw_company", admin);
            for (Category category : companyCategorySet) {
                Set cuwSet = this.cuwRepository.findByCategory(category);
                category.setCuwChildren(cuwSet);
            }
            Set mineCategorySet = this.categoryRepository.findByTypeAndUser("cuw_mine", (User)userOptional.get());
            for (Category category : mineCategorySet) {
                Set cuwSet = this.cuwRepository.findByCategory(category);
                category.setCuwChildren(cuwSet);
            }
            HashMap<String, Set> objectMap = new HashMap<String, Set>(3);
            objectMap.put("platform", platformCategorySet);
            objectMap.put("company", companyCategorySet);
            objectMap.put("mine", mineCategorySet);
            jsonResult.setMessage("\u83b7\u53d6\u5e38\u7528\u8bed\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData(objectMap);
        } else {
            jsonResult.setMessage("\u83b7\u53d6\u5e38\u7528\u8bed\u5931\u8d25-access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/company"})
    public JsonResult company(Principal principal, @RequestParam(value="categoryId") Integer categoryId, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"updatedAt"});
                if (categoryId == 0) {
                    Set companyCategorySet = this.categoryRepository.findByTypeAndUser("cuw_company", (User)adminOptional.get());
                    for (Category category : companyCategorySet) {
                        Set cuwSet = this.cuwRepository.findByCategory(category);
                        category.setCuwChildren(cuwSet);
                    }
                    jsonResult.setMessage("\u83b7\u53d6\u516c\u53f8\u7c7b\u578b\u5e38\u7528\u8bed\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)companyCategorySet);
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u516c\u53f8\u7c7b\u578b\u5e38\u7528\u8bed\u5931\u8d25-\u7ba1\u7406\u5458\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("\u83b7\u53d6\u516c\u53f8\u7c7b\u578b\u5e38\u7528\u8bed\u5931\u8d25-access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public JsonResult create(Principal principal, @RequestBody Map map) {
        Integer categoryId = (Integer)map.get("categoryId");
        String name = (String)map.get("name");
        String content = (String)map.get("content");
        this.logger.info("create: categoryId {}, name {}, content {}", new Object[]{categoryId, name, content});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Cuw cuw = new Cuw();
                cuw.setCid(JpaUtil.randomId());
                cuw.setName(name);
                cuw.setContent(content);
                Optional categoryOptional = this.categoryRepository.findById((Object)categoryId);
                if (categoryOptional.isPresent()) {
                    cuw.setCategory((Category)categoryOptional.get());
                }
                cuw.setUser((User)userOptional.get());
                this.cuwRepository.save((Object)cuw);
                HashMap<String, Object> objectMap = new HashMap<String, Object>(2);
                objectMap.put("cuw", cuw);
                objectMap.put("category", cuw.getCategory());
                jsonResult.setMessage("\u521b\u5efa\u5e38\u7528\u8bed\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData(objectMap);
            } else {
                jsonResult.setMessage("\u521b\u5efa\u5e38\u7528\u8bed\u5931\u8d25-\u7528\u6237\u540d\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public JsonResult update(Principal principal, @RequestBody Map map) {
        Integer id = (Integer)map.get("id");
        String name = (String)map.get("name");
        String content = (String)map.get("content");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional cuwOptional = this.cuwRepository.findById((Object)id);
            if (cuwOptional.isPresent()) {
                ((Cuw)cuwOptional.get()).setName(name);
                ((Cuw)cuwOptional.get()).setContent(content);
                this.cuwRepository.save(cuwOptional.get());
                HashMap<String, Object> objectMap = new HashMap<String, Object>(2);
                objectMap.put("cuw", cuwOptional.get());
                objectMap.put("category", ((Cuw)cuwOptional.get()).getCategory());
                jsonResult.setMessage("\u66f4\u65b0\u5e38\u7528\u8bed\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData(objectMap);
            } else {
                jsonResult.setMessage("\u66f4\u65b0\u5e38\u7528\u8bed\u5931\u8d25");
                jsonResult.setStatus_code(-1);
                jsonResult.setData((Object)id);
            }
        } else {
            jsonResult.setMessage("\u66f4\u65b0\u5e38\u7528\u8bed\u5931\u8d25-access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public JsonResult delete(Principal principal, @RequestBody Map map) {
        Integer id = (Integer)map.get("id");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional cuwOptional = this.cuwRepository.findById((Object)id);
            if (cuwOptional.isPresent()) {
                this.cuwRepository.delete(cuwOptional.get());
            }
            HashMap<String, Object> objectMap = new HashMap<String, Object>(2);
            objectMap.put("cuw", cuwOptional.get());
            objectMap.put("category", ((Cuw)cuwOptional.get()).getCategory());
            jsonResult.setMessage("\u5220\u9664\u5e38\u7528\u8bed\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData(objectMap);
        } else {
            jsonResult.setMessage("\u5220\u9664\u5e38\u7528\u8bed\u5931\u8d25-access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

