/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.LeaveMessage;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.LeaveMessageRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WorkGroupRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/leavemsg"})
public class LeaveMessageController
extends BaseController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    LeaveMessageRepository leaveMessageRepository;
    @Autowired
    WorkGroupRepository workGroupRepository;

    @GetMapping(value={"/get"})
    public JsonResult get(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Page leaveMessagePage;
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                if (((User)adminOptional.get()).isAdmin()) {
                    leaveMessagePage = this.leaveMessageRepository.findBySubDomain(((User)adminOptional.get()).getSubDomain(), (Pageable)pageable);
                } else if (((User)adminOptional.get()).isWorkGroupAdmin()) {
                    WorkGroup workGroup = (WorkGroup)((User)adminOptional.get()).getWorkGroups().toArray()[0];
                    leaveMessagePage = this.leaveMessageRepository.findByWorkGroup(workGroup, (Pageable)pageable);
                } else {
                    leaveMessagePage = this.leaveMessageRepository.findByAgent((User)adminOptional.get(), (Pageable)pageable);
                }
                jsonResult.setMessage("\u83b7\u53d6\u7559\u8a00\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)leaveMessagePage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/unclaimed"})
    public JsonResult unclaimed(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional agentOptional = this.userRepository.findByUsername(principal.getName());
            if (agentOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page leaveMessagePage = this.leaveMessageRepository.findBySubDomainAndStatus(((User)agentOptional.get()).getSubDomain(), "unclaimed", (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u672a\u88ab\u9886\u53d6\u7559\u8a00\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)leaveMessagePage);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u672a\u88ab\u9886\u53d6\u7559\u8a00\u5931\u8d25-\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-1);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/claimed"})
    public JsonResult claimed(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional agentOptional = this.userRepository.findByUsername(principal.getName());
            if (agentOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page leaveMessagePage = this.leaveMessageRepository.findByClaimer((User)agentOptional.get(), (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u5df2\u88ab\u9886\u53d6\u7559\u8a00\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)leaveMessagePage);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5df2\u88ab\u9886\u53d6\u7559\u8a00\u5931\u8d25-\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-1);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/claim"})
    @ResponseBody
    public JsonResult claim(Principal principal, @RequestBody Map map) {
        String lid = (String)map.get("lid");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional agentOptional = this.userRepository.findByUsername(principal.getName());
            if (agentOptional.isPresent()) {
                Optional leaveMessageOptional = this.leaveMessageRepository.findByLid(lid);
                if (leaveMessageOptional.isPresent()) {
                    ((LeaveMessage)leaveMessageOptional.get()).setStatus("claimed");
                    ((LeaveMessage)leaveMessageOptional.get()).setClaimer((User)agentOptional.get());
                    this.leaveMessageRepository.save(leaveMessageOptional.get());
                    jsonResult.setMessage("\u9886\u53d6\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)lid);
                } else {
                    jsonResult.setMessage("\u9886\u53d6\u7559\u8a00\u5931\u8d25-\u7559\u8a00\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-2);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u9886\u53d6\u7559\u8a00\u5931\u8d25-\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-1);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/summarize"})
    @ResponseBody
    public JsonResult summarize(Principal principal, @RequestBody Map map) {
        String lid = (String)map.get("lid");
        String summary = (String)map.get("summary");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional agentOptional = this.userRepository.findByUsername(principal.getName());
            if (agentOptional.isPresent()) {
                Optional leaveMessageOptional = this.leaveMessageRepository.findByLid(lid);
                if (leaveMessageOptional.isPresent()) {
                    ((LeaveMessage)leaveMessageOptional.get()).setStatus("summarized");
                    ((LeaveMessage)leaveMessageOptional.get()).setSummary(summary);
                    this.leaveMessageRepository.save(leaveMessageOptional.get());
                    jsonResult.setMessage("\u5c0f\u7ed3\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)lid);
                } else {
                    jsonResult.setMessage("\u9886\u53d6\u7559\u8a00\u5931\u8d25-\u7559\u8a00\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-2);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u7559\u8a00\u5c0f\u7ed3\u5931\u8d25-\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-1);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    public JsonResult save(Principal principal, @RequestBody Map map) {
        String wid = (String)map.get("wid");
        String aid = (String)map.get("aid");
        String type = (String)map.get("type");
        String mobile = (String)map.get("mobile");
        String email = (String)map.get("email");
        String content = (String)map.get("content");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (null == mobile || mobile.trim().length() == 0 || null == content || content.trim().length() == 0) {
            jsonResult.setMessage("\u7559\u8a00\u5931\u8d25-\u624b\u673a\u53f7\u548c\u7559\u8a00\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            jsonResult.setStatus_code(-4);
            jsonResult.setData((Object)false);
            return jsonResult;
        }
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                LeaveMessage leaveMessage = new LeaveMessage();
                leaveMessage.setLid(JpaUtil.randomId());
                leaveMessage.setMobile(mobile);
                leaveMessage.setEmail(email);
                leaveMessage.setContent(content);
                leaveMessage.setType(type);
                leaveMessage.setVisitor((User)visitorOptional.get());
                leaveMessage.setStatus("unclaimed");
                if (type.equals("appointed")) {
                    Optional agentOptional = this.userRepository.findByUid(aid);
                    if (agentOptional.isPresent()) {
                        leaveMessage.setAgent((User)agentOptional.get());
                        leaveMessage.setSubDomain(((User)agentOptional.get()).getAdmin().getSubDomain());
                    }
                } else {
                    Optional workGroupOptional = this.workGroupRepository.findByWid(wid);
                    if (workGroupOptional.isPresent()) {
                        leaveMessage.setWorkGroup((WorkGroup)workGroupOptional.get());
                        leaveMessage.setSubDomain(((WorkGroup)workGroupOptional.get()).getUser().getSubDomain());
                    }
                }
                this.leaveMessageRepository.save((Object)leaveMessage);
                jsonResult.setMessage("\u7559\u8a00\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)leaveMessage);
            } else {
                jsonResult.setMessage("\u7559\u8a00\u5931\u8d25-\u8bbf\u5ba2\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-3);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/reply"})
    @ResponseBody
    public JsonResult reply(Principal principal, @RequestBody Map map) {
        String lid = (String)map.get("lid");
        Boolean replied = (Boolean)map.get("replied");
        String reply = (String)map.get("reply");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Optional leaveMessageOptional = this.leaveMessageRepository.findByLid(lid);
                if (leaveMessageOptional.isPresent()) {
                    ((LeaveMessage)leaveMessageOptional.get()).setReplied(replied.booleanValue());
                    ((LeaveMessage)leaveMessageOptional.get()).setReply(reply);
                    this.leaveMessageRepository.save(leaveMessageOptional.get());
                    jsonResult.setMessage("\u5907\u6ce8\u7559\u8a00\u56de\u590d\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(leaveMessageOptional.get());
                } else {
                    jsonResult.setMessage("\u5907\u6ce8\u7559\u8a00\u56de\u590d\u5931\u8d25-\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-2);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u5907\u6ce8\u7559\u8a00\u56de\u590d\u5931\u8d25-\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("\u5907\u6ce8\u7559\u8a00\u56de\u590d\u5931\u8d25-access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="nickname") String nickname, @RequestParam(value="createdAtStart") String createdAtStart, @RequestParam(value="createdAtEnd") String createdAtEnd, @RequestParam(value="workGroupNickname") String workGroupNickname, @RequestParam(value="agentRealName") String agentRealName, @RequestParam(value="client") String client) {
        this.logger.info("page {}, size {}, nickname {}, createdAtStart {}, createdAtEnd {}, wgNickname {}, agentRealName {}, client {}", new Object[]{page, size, nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Specification specification = this.getSpecification((User)adminOptional.get(), "leave_message", nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client);
                Page leaveMessagePage = this.leaveMessageRepository.findAll(specification, (Pageable)pageable);
                jsonResult.setMessage("\u641c\u7d22\u7559\u8a00\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)leaveMessagePage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

