/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.QuestionnaireAnswer;
import io.xiaper.jpa.model.QuestionnaireItemItem;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.QuestionnaireAnswerRepository;
import io.xiaper.jpa.repository.QuestionnaireItemItemRepository;
import io.xiaper.jpa.repository.QuestionnaireItemRepository;
import io.xiaper.jpa.repository.QuestionnaireRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WorkGroupRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/questionnaire"})
public class QuestionnaireController
extends BaseController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    WorkGroupRepository workGroupRepository;
    @Autowired
    QuestionnaireRepository questionnaireRepository;
    @Autowired
    QuestionnaireItemRepository questionnaireItemRepository;
    @Autowired
    QuestionnaireItemItemRepository questionnaireItemItemRepository;
    @Autowired
    QuestionnaireAnswerRepository questionnaireAnswerRepository;

    @GetMapping(value={"/all"})
    public JsonResult all(Principal principal, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                List questionnaireList = this.questionnaireRepository.findByUser((User)userOptional.get());
                jsonResult.setMessage("\u83b7\u53d6\u5168\u90e8\u95ee\u5377\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)questionnaireList);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5168\u90e8\u95ee\u5377\u5931\u8d25-\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/query"})
    public JsonResult query(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page questionnairePage = this.questionnaireRepository.findByUser((User)userOptional.get(), (Pageable)pageable);
                jsonResult.setMessage("\u5206\u9875\u83b7\u53d6\u95ee\u5377\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)questionnairePage);
            } else {
                jsonResult.setMessage("\u5206\u9875\u83b7\u53d6\u95ee\u5377\u5931\u8d25-\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public JsonResult create(Principal principal, @RequestBody Map map) {
        JsonResult jsonResult = new JsonResult();
        if (principal == null) {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/create/item/item/answer"})
    @ResponseBody
    public JsonResult createItemItemAnswer(Principal principal, @RequestBody Map map) {
        String qid = (String)map.get("qid");
        String content = (String)map.get("content");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            Optional questionnaireItemItemOptional = this.questionnaireItemItemRepository.findByQid(qid);
            if (questionnaireItemItemOptional.isPresent()) {
                QuestionnaireAnswer questionnaireAnswer = new QuestionnaireAnswer();
                questionnaireAnswer.setQid(JpaUtil.randomId());
                questionnaireAnswer.setInputContent(content);
                questionnaireAnswer.setQuestionnaireItem(((QuestionnaireItemItem)questionnaireItemItemOptional.get()).getQuestionnaireItem());
                questionnaireAnswer.setQuestionnaireItemItem((QuestionnaireItemItem)questionnaireItemItemOptional.get());
                questionnaireAnswer.setUser((User)userOptional.get());
                this.questionnaireAnswerRepository.save((Object)questionnaireAnswer);
                ((QuestionnaireItemItem)questionnaireItemItemOptional.get()).getQuestionnaireAnswers().add(questionnaireAnswer);
                this.questionnaireItemItemRepository.save(questionnaireItemItemOptional.get());
                jsonResult.setMessage("\u521b\u5efaItemItemAnswer\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)questionnaireAnswer);
            } else {
                jsonResult.setMessage("access token invalid");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete/item/item/answer"})
    @ResponseBody
    public JsonResult deleteItemItemAnswer(Principal principal, @RequestBody Map map) {
        String qid = (String)map.get("qid");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional questionnaireAnswerOptional = this.questionnaireAnswerRepository.findByQid(qid);
            if (questionnaireAnswerOptional.isPresent()) {
                QuestionnaireItemItem questionnaireItemItem = ((QuestionnaireAnswer)questionnaireAnswerOptional.get()).getQuestionnaireItemItem();
                questionnaireItemItem.getQuestionnaireAnswers().remove(questionnaireAnswerOptional.get());
                this.questionnaireItemItemRepository.save((Object)questionnaireItemItem);
                this.questionnaireAnswerRepository.delete(questionnaireAnswerOptional.get());
                jsonResult.setMessage("\u5220\u9664ItemItemAnswer\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)qid);
            } else {
                jsonResult.setMessage("\u5220\u9664ItemItemAnswer\u5931\u8d25-qid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/query/item/item/workGroup"})
    public JsonResult queryItemItemWorkGroup(Principal principal, @RequestParam(value="qid") String qid, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional questionnaireItemItemOptional = this.questionnaireItemItemRepository.findByQid(qid);
            if (questionnaireItemItemOptional.isPresent()) {
                HashMap<String, Set> workGroupsMap = new HashMap<String, Set>(2);
                workGroupsMap.put(qid, ((QuestionnaireItemItem)questionnaireItemItemOptional.get()).getWorkGroups());
                jsonResult.setMessage("\u83b7\u53d6ItemItemWorkGroup\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData(workGroupsMap);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/update/item/item/workGroup"})
    @ResponseBody
    public JsonResult updateItemItemWorkGroup(Principal principal, @RequestBody Map map) {
        String qid = (String)map.get("qid");
        List workGroups = (List)map.get("workGroups");
        this.logger.info("qid {}", (Object)qid);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional questionnaireItemItemOptional = this.questionnaireItemItemRepository.findByQid(qid);
            if (questionnaireItemItemOptional.isPresent()) {
                ((QuestionnaireItemItem)questionnaireItemItemOptional.get()).getWorkGroups().clear();
                for (String wid : workGroups) {
                    Optional workGroupOptional = this.workGroupRepository.findByWid(wid);
                    if (!workGroupOptional.isPresent()) continue;
                    ((QuestionnaireItemItem)questionnaireItemItemOptional.get()).getWorkGroups().add(workGroupOptional.get());
                }
                this.questionnaireItemItemRepository.save(questionnaireItemItemOptional.get());
                jsonResult.setMessage("\u66f4\u65b0ItemItemWorkGroup\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData(questionnaireItemItemOptional.get());
            } else {
                jsonResult.setMessage("\u66f4\u65b0ItemItemWorkGroup\u5931\u8d25-qid\u9519\u8bef");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete/item/item/workGroup"})
    @ResponseBody
    public JsonResult deleteItemItemWorkGroup(Principal principal, @RequestBody Map map) {
        String qid = (String)map.get("qid");
        String wid = (String)map.get("wid");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional questionnaireItemItemOptional = this.questionnaireItemItemRepository.findByQid(qid);
            if (questionnaireItemItemOptional.isPresent()) {
                Optional workGroupOptional = this.workGroupRepository.findByWid(wid);
                if (workGroupOptional.isPresent()) {
                    ((QuestionnaireItemItem)questionnaireItemItemOptional.get()).getWorkGroups().remove(workGroupOptional.get());
                }
                this.questionnaireItemItemRepository.save(questionnaireItemItemOptional.get());
                jsonResult.setMessage("\u5220\u9664ItemItemWorkGroup\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)qid);
            } else {
                jsonResult.setMessage("\u5220\u9664ItemItemAnswer\u5931\u8d25-qid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public JsonResult update(Principal principal, @RequestBody Map map) {
        JsonResult jsonResult = new JsonResult();
        if (principal == null) {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public JsonResult delete(Principal principal, @RequestBody Map map) {
        JsonResult jsonResult = new JsonResult();
        if (principal == null) {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="content") String content, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal == null) {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }
}

