/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.constant.UserConsts;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Queue;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.QueueRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.mq.service.MessagingTemplate;
import io.xiaper.mq.service.redis.RedisQueueService;
import io.xiaper.mq.service.redis.RedisStatisticService;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/queue"})
public class QueueController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(QueueController.class);
    @Autowired
    UserRepository userRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    RedisQueueService redisQueueService;
    @Autowired
    RedisStatisticService redisStatisticService;
    @Autowired
    MessagingTemplate messagingTemplate;

    @GetMapping(value={"/get"})
    public JsonResult get(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"id"});
                Page queuePage = this.queueRepository.findByWorkGroup_UsersContainsAndStatus((User)adminOptional.get(), "queuing", (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u6392\u961f\u8bbf\u5ba2\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)queuePage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/accept"})
    @ResponseBody
    public JsonResult accept(Principal principal, @RequestBody Map map) {
        String qid = (String)map.get("qid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional agentOptional = this.userRepository.findByUsername(principal.getName());
            Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
            if (agentOptional.isPresent()) {
                Optional queueOptional = this.queueRepository.findByQid(qid);
                if (queueOptional.isPresent()) {
                    if (((Queue)queueOptional.get()).queuing()) {
                        this.redisQueueService.deleteQueuedWorkGroup(((Queue)queueOptional.get()).getWorkGroup().getWid(), ((Queue)queueOptional.get()).getVisitor().getUid());
                        ((Queue)queueOptional.get()).setAgent((User)agentOptional.get());
                        ((Queue)queueOptional.get()).setAgentClient(client);
                        ((Queue)queueOptional.get()).accept();
                        this.queueRepository.save(queueOptional.get());
                        Thread thread = ((Queue)queueOptional.get()).getThread();
                        thread.setContent("\u63a5\u5165\u961f\u5217\u4f1a\u8bdd");
                        thread.setTimestamp(new Date());
                        thread.setUnreadCount(0);
                        thread.setVisitor(((Queue)queueOptional.get()).getVisitor());
                        thread.setAgent((User)agentOptional.get());
                        thread.getAgents().add(agentOptional.get());
                        thread.setStartedAt(new Date());
                        this.threadRepository.save((Object)thread);
                        Message message = new Message();
                        message.setMid(JpaUtil.randomId());
                        message.setWid(((Queue)queueOptional.get()).getWorkGroup().getWid());
                        message.setClient(ClientConsts.CLIENT_SYSTEM);
                        message.setThread(thread);
                        message.setQueue((Queue)queueOptional.get());
                        message.setType("notification_queue_accept");
                        message.setContent("\u63a5\u5165\u961f\u5217\u4f1a\u8bdd");
                        message.setUser((User)userNotification.get());
                        this.messageRepository.save((Object)message);
                        this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                        this.messagingTemplate.convertAndSend("message.workGroup.#", (Object)message);
                        String agentUid = ((User)agentOptional.get()).getUid();
                        this.redisStatisticService.removeCurrentQueue(((User)agentOptional.get()).getSubDomain(), ((Queue)queueOptional.get()).getQid());
                        this.redisStatisticService.increaseAcceptQueueCount(((User)agentOptional.get()).getSubDomain());
                        if (((Queue)queueOptional.get()).waitLength() <= 60L) {
                            this.redisStatisticService.increaseAgentAcceptCountLt1m(agentUid);
                            this.redisStatisticService.increaseAcceptCountLt1m(((User)agentOptional.get()).getSubDomain());
                        } else if (((Queue)queueOptional.get()).waitLength() <= 180L) {
                            this.redisStatisticService.increaseAgentAcceptCountLt3m(agentUid);
                            this.redisStatisticService.increaseAcceptCountLt3m(((User)agentOptional.get()).getSubDomain());
                        } else if (((Queue)queueOptional.get()).waitLength() <= 300L) {
                            this.redisStatisticService.increaseAgentAcceptCountLt5m(agentUid);
                            this.redisStatisticService.increaseAcceptCountLt5m(((User)agentOptional.get()).getSubDomain());
                        } else {
                            this.redisStatisticService.increaseAgentAcceptCountGt5m(agentUid);
                            this.redisStatisticService.increaseAcceptCountGt5m(((User)agentOptional.get()).getSubDomain());
                        }
                        jsonResult.setMessage("\u63a5\u5165\u961f\u5217\u8bbf\u5ba2\u6210\u529f");
                        jsonResult.setStatus_code(200);
                        jsonResult.setData((Object)message);
                    } else {
                        jsonResult.setMessage("\u63a5\u5165\u961f\u5217\u5931\u8d25-\u5df2\u7ecf\u88ab\u5176\u4ed6\u5ba2\u670d\u63a5\u5165");
                        jsonResult.setStatus_code(-4);
                        jsonResult.setData((Object)false);
                    }
                } else {
                    jsonResult.setMessage("\u63a5\u5165\u961f\u5217\u5931\u8d25-qid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u63a5\u5165\u961f\u5217\u5931\u8d25-\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("\u63a5\u5165\u961f\u5217\u5931\u8d25-access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/request"})
    public JsonResult request(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page queuePage = this.queueRepository.findByAgent_User((User)adminOptional.get(), (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u6392\u961f\u8bb0\u5f55\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)queuePage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="nickname") String nickname, @RequestParam(value="createdAtStart") String createdAtStart, @RequestParam(value="createdAtEnd") String createdAtEnd, @RequestParam(value="workGroupNickname") String workGroupNickname, @RequestParam(value="agentRealName") String agentRealName, @RequestParam(value="client") String client) {
        logger.info("page {}, size {}, nickname {}, createdAtStart {}, createdAtEnd {}, wgNickname {}, agentRealName {}, client {}", new Object[]{page, size, nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Specification specification = this.getSpecification((User)adminOptional.get(), "queue", nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client);
                Page queuePage = this.queueRepository.findAll(specification, (Pageable)pageable);
                jsonResult.setMessage("\u641c\u7d22\u6392\u961f\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)queuePage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

