/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Rate;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.RateRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.mq.service.MessagingTemplate;
import io.xiaper.mq.service.UserService;
import io.xiaper.mq.service.redis.RedisStatisticService;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rate"})
public class RateController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(RateController.class);
    @Autowired
    UserRepository userRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    RateRepository rateRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    RedisStatisticService redisStatisticService;
    @Autowired
    UserService userService;
    @Autowired
    MessagingTemplate messagingTemplate;

    @GetMapping(value={"/get"})
    public JsonResult get(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Page ratePage;
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                if (((User)adminOptional.get()).isAdmin()) {
                    ratePage = this.rateRepository.findByUser((User)adminOptional.get(), (Pageable)pageable);
                } else if (((User)adminOptional.get()).isWorkGroupAdmin()) {
                    WorkGroup workGroup = (WorkGroup)((User)adminOptional.get()).getWorkGroups().toArray()[0];
                    ratePage = this.rateRepository.findByAgent_WorkGroupsContains(workGroup, (Pageable)pageable);
                } else {
                    ratePage = this.rateRepository.findByAgent((User)adminOptional.get(), (Pageable)pageable);
                }
                jsonResult.setMessage("\u83b7\u53d6\u6ee1\u610f\u5ea6\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)ratePage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/invite"})
    @ResponseBody
    public JsonResult invite(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional agentOptional = this.userRepository.findByUsername(principal.getName());
            Optional threadOptional = this.threadRepository.findByTid(tid);
            if (agentOptional.isPresent() && threadOptional.isPresent()) {
                if (((Thread)threadOptional.get()).isRated()) {
                    jsonResult.setMessage("\u9080\u8bf7\u8bc4\u4ef7\u5931\u8d25-\u8bbf\u5ba2\u5df2\u7ecf\u8bc4\u4ef7");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                    return jsonResult;
                }
                Message message = new Message();
                message.setMid(JpaUtil.randomId());
                if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                    message.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                } else {
                    message.setWid("appointed");
                }
                message.setType("notification_invite_rate");
                message.setClient(client);
                message.setContent("\u9080\u8bf7\u8bc4\u4ef7");
                message.setThread((Thread)threadOptional.get());
                message.setUser(this.userService.getNotificationUser());
                this.messageRepository.save((Object)message);
                this.messagingTemplate.convertAndSend("message.thread.#", (Object)message);
                jsonResult.setMessage("\u6210\u529f\u53d1\u9001\u9080\u8bf7\u8bc4\u4ef7");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)message);
            } else {
                jsonResult.setMessage("\u9080\u8bf7\u8bc4\u4ef7\u5931\u8d25-\u5ba2\u670d\u8d26\u53f7\u6216\u8005\u4f1a\u8bddtid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/do"})
    @ResponseBody
    public JsonResult rate(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String score = (String)map.get("score");
        String note = (String)map.get("note");
        String invite = (String)map.get("invite");
        String client = (String)map.get("client");
        logger.info("invite: " + invite + " note:" + note);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            Optional threadOptional = this.threadRepository.findByTid(tid);
            if (visitorOptional.isPresent() && threadOptional.isPresent()) {
                if (((Thread)threadOptional.get()).getAgent() == null) {
                    jsonResult.setMessage("\u8bbf\u5ba2\u8bc4\u4ef7-\u672a\u6210\u529f\u5bf9\u63a5\u5ba2\u670d\u4e4b\u524d\u4e0d\u80fd\u8bc4\u4ef7");
                    jsonResult.setStatus_code(-4);
                    jsonResult.setData((Object)false);
                    return jsonResult;
                }
                if (((Thread)threadOptional.get()).isRated()) {
                    jsonResult.setMessage("\u8bbf\u5ba2\u8bc4\u4ef7-\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                    return jsonResult;
                }
                ((Thread)threadOptional.get()).setRated(true);
                this.threadRepository.save(threadOptional.get());
                Rate rate = new Rate();
                rate.setScore(Integer.valueOf(score).intValue());
                rate.setNote(note);
                rate.setTotal(5);
                rate.setAuto(false);
                rate.setInvite(invite.equals("1"));
                rate.setClient(client);
                rate.setThread((Thread)threadOptional.get());
                rate.setVisitor((User)visitorOptional.get());
                User agent = ((Thread)threadOptional.get()).getAgent();
                rate.setAgent(agent);
                rate.setUser(agent.getAdmin());
                if (((Thread)threadOptional.get()).getType().equals("workGroup")) {
                    this.redisStatisticService.increaseRateCount(agent.getSubDomain());
                    if (Integer.valueOf(score) >= 4) {
                        this.redisStatisticService.increaseSatisfyCount(agent.getAdmin().getUid());
                    }
                }
                this.rateRepository.save((Object)rate);
                Message message = new Message();
                message.setMid(JpaUtil.randomId());
                if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                    message.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                } else {
                    message.setWid("appointed");
                }
                message.setType("notification_rate_result");
                message.setContent("\u5df2\u8bc4\u4ef7");
                message.setThread((Thread)threadOptional.get());
                message.setUser(this.userService.getNotificationUser());
                this.messageRepository.save((Object)message);
                this.messagingTemplate.convertAndSend("message.thread.#", (Object)message);
                jsonResult.setMessage("\u6210\u529f\u8bc4\u4ef7");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)message);
            } else {
                jsonResult.setMessage("\u8bbf\u5ba2\u8bc4\u4ef7-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="nickname") String nickname, @RequestParam(value="createdAtStart") String createdAtStart, @RequestParam(value="createdAtEnd") String createdAtEnd, @RequestParam(value="workGroupNickname") String workGroupNickname, @RequestParam(value="agentRealName") String agentRealName, @RequestParam(value="client") String client) {
        logger.info("page {}, size {}, nickname {}, createdAtStart {}, createdAtEnd {}, wgNickname {}, agentRealName {}, client {}", new Object[]{page, size, nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Specification specification = this.getSpecification((User)adminOptional.get(), "rate", nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client);
                Page ratePage = this.rateRepository.findAll(specification, (Pageable)pageable);
                jsonResult.setMessage("\u641c\u7d22\u8bc4\u4ef7\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)ratePage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

