/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Role;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.QueueRepository;
import io.xiaper.jpa.repository.RoleRepository;
import io.xiaper.jpa.repository.StatisticDetailRepository;
import io.xiaper.jpa.repository.StatisticRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.mq.service.redis.RedisStatisticService;
import io.xiaper.rest.controller.v1.BaseController;
import java.io.Serializable;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/statistic"})
public class StatisticController
extends BaseController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    StatisticRepository statisticRepository;
    @Autowired
    StatisticDetailRepository statisticDetailRepository;
    @Autowired
    RedisStatisticService redisStatisticService;

    @GetMapping(value={"/all"})
    public JsonResult all(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            String subDomain = ((User)adminOptional.get()).getSubDomain();
            Long onlineAgentCount = this.redisStatisticService.onlineAgentCount(subDomain);
            Long currentThreadCount = this.redisStatisticService.currentThreadCount(subDomain);
            Long currentQueueCount = this.redisStatisticService.currentQueueCount(subDomain);
            Long todayLeaveQueueCount = this.redisStatisticService.leaveQueueCount(subDomain);
            Long todayTotalThreadCount = this.redisStatisticService.totalThreadCount(subDomain);
            Long todayTotalQueueCount = this.redisStatisticService.totalQueueCount(subDomain);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String dateString = dateFormat.format(new Date());
            Date date = null;
            try {
                date = dateFormat.parse(dateString);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            String timeTypeHour = "hour";
            List statisticList = this.statisticRepository.findByDateAndTypeAndUser(date, timeTypeHour, (User)adminOptional.get());
            HashMap<String, Object> objectMap = new HashMap<String, Object>(8);
            objectMap.put("onlineAgentCount", onlineAgentCount);
            objectMap.put("currentThreadCount", currentThreadCount);
            objectMap.put("currentQueueCount", currentQueueCount);
            objectMap.put("todayTotalThreadCount", todayTotalThreadCount);
            objectMap.put("todayTotalQueueCount", todayTotalQueueCount);
            objectMap.put("todayLeaveQueueCount", todayLeaveQueueCount);
            objectMap.put("statisticList", statisticList);
            jsonResult.setMessage("\u83b7\u53d6\u7edf\u8ba1\u6570\u636e\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData(objectMap);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/detail"})
    public JsonResult detail(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String dateString = dateFormat.format(new Date());
            Date date = null;
            try {
                date = dateFormat.parse(dateString);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            String timeTypeHour = "hour";
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            Page statisticDetailPage = this.statisticDetailRepository.findByDateAndTimeTypeAndUser_User(date, timeTypeHour, (User)adminOptional.get(), (Pageable)pageable);
            jsonResult.setMessage("\u83b7\u53d6\u4f1a\u8bdd\u8be6\u60c5\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)statisticDetailPage);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/rate"})
    public JsonResult rate(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            jsonResult.setMessage("\u83b7\u53d6\u6ee1\u610f\u5ea6\u8bc4\u4ef7\u6570\u636e\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData(new HashMap(1));
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/onlineAgent"})
    public JsonResult onlineAgent(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            Optional roleOptional = this.roleRepository.findByValue("ROLE_VISITOR");
            Page userPage = this.userRepository.findBySubDomainAndConnectionStatusAndRolesNotContains(((User)adminOptional.get()).getSubDomain(), "connected", (Role)roleOptional.get(), (Pageable)pageable);
            jsonResult.setMessage("\u83b7\u53d6\u5f53\u524d\u5728\u7ebf\u5ba2\u670d\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)userPage);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/currentThread"})
    public JsonResult currentThread(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
                ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
                predicateList.add(criteriaBuilder.equal((Expression)root.get("visitor").get("subDomain"), (Object)((User)adminOptional.get()).getSubDomain()));
                predicateList.add(criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("type"), (Object)"thread"), (Expression)criteriaBuilder.equal((Expression)root.get("type"), (Object)"appointed")));
                predicateList.add(criteriaBuilder.equal((Expression)root.get("closed"), (Object)false));
                predicateList.add(criteriaBuilder.isNotNull((Expression)root.get("agent")));
                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            };
            Page threadPage = this.threadRepository.findAll((Specification)specification, (Pageable)pageable);
            jsonResult.setMessage("\u83b7\u53d6\u5f53\u524d\u4f1a\u8bdd\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)threadPage);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/currentQueue"})
    public JsonResult currentQueue(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
                ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
                predicateList.add(criteriaBuilder.equal((Expression)root.get("visitor").get("subDomain"), (Object)((User)adminOptional.get()).getSubDomain()));
                predicateList.add(criteriaBuilder.equal((Expression)root.get("status"), (Object)"queuing"));
                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            };
            Page queuePage = this.queueRepository.findAll((Specification)specification, (Pageable)pageable);
            jsonResult.setMessage("\u83b7\u53d6\u5f53\u524d\u6392\u961f\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)queuePage);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/leaveQueue"})
    public JsonResult leaveQueue(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
                List<Predicate> predicateList = new ArrayList<Predicate>();
                predicateList.add(criteriaBuilder.equal((Expression)root.get("visitor").get("subDomain"), (Object)((User)adminOptional.get()).getSubDomain()));
                predicateList.add(criteriaBuilder.equal((Expression)root.get("status"), (Object)"leaved"));
                predicateList = this.todayPredictLimit(predicateList, root, criteriaBuilder);
                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            };
            Page queuePage = this.queueRepository.findAll((Specification)specification, (Pageable)pageable);
            jsonResult.setMessage("\u83b7\u53d6\u5f53\u65e5\u653e\u5f03\u6392\u961f\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)queuePage);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/totalQueue"})
    public JsonResult totalQueue(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
                List<Predicate> predicateList = new ArrayList<Predicate>();
                predicateList.add(criteriaBuilder.equal((Expression)root.get("visitor").get("subDomain"), (Object)((User)adminOptional.get()).getSubDomain()));
                predicateList = this.todayPredictLimit(predicateList, root, criteriaBuilder);
                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            };
            Page queuePage = this.queueRepository.findAll((Specification)specification, (Pageable)pageable);
            jsonResult.setMessage("\u83b7\u53d6\u5f53\u65e5\u6392\u961f\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)queuePage);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/totalThread"})
    public JsonResult totalThread(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
                List<Predicate> predicateList = new ArrayList<Predicate>();
                predicateList.add(criteriaBuilder.equal((Expression)root.get("visitor").get("subDomain"), (Object)((User)adminOptional.get()).getSubDomain()));
                predicateList.add(criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("type"), (Object)"thread"), (Expression)criteriaBuilder.equal((Expression)root.get("type"), (Object)"appointed")));
                predicateList = this.todayPredictLimit(predicateList, root, criteriaBuilder);
                predicateList.add(criteriaBuilder.isNotNull((Expression)root.get("agent")));
                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            };
            Page threadPage = this.threadRepository.findAll((Specification)specification, (Pageable)pageable);
            jsonResult.setMessage("\u83b7\u53d6\u5f53\u65e5\u4f1a\u8bdd\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)threadPage);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="date") String date, @RequestParam(value="realName") String realName, @RequestParam(value="client") String client) {
        this.logger.info("page {}, size {}, date {}, realName {}, client {}", new Object[]{page, size, date, realName, client});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
                    ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
                    String invalidDate = "Invalid date";
                    if (null != date && !date.equals("") && !date.equals(invalidDate)) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        Date startAt = new Date();
                        try {
                            startAt = dateFormat.parse(date);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        String timeType = "day";
                        predicateList.add(criteriaBuilder.equal((Expression)root.get("date"), (Object)startAt));
                        predicateList.add(criteriaBuilder.equal((Expression)root.get("timeType"), (Object)timeType));
                    }
                    if (null != realName) {
                        predicateList.add(criteriaBuilder.like((Expression)root.get("user").get("realName"), "%" + realName + "%"));
                    }
                    predicateList.add(criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("user").get("username"), (Object)principal.getName()), (Expression)criteriaBuilder.equal((Expression)root.get("user").get("user").get("username"), (Object)principal.getName())));
                    return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
                };
                Page statisticDetailPage = this.statisticDetailRepository.findAll((Specification)specification, (Pageable)pageable);
                jsonResult.setMessage("\u641c\u7d22\u7edf\u8ba1\u8be6\u60c5\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)statisticDetailPage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    private List<Predicate> todayPredictLimit(List<Predicate> predicateList, Root root, CriteriaBuilder criteriaBuilder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String today = dateFormat.format(new Date());
        this.logger.info("today: " + today);
        try {
            Date todayDate = dateFormat.parse(today);
            predicateList.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)todayDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        Date tomorrowDate = calendar.getTime();
        String tomorrow = dateFormat.format(tomorrowDate);
        this.logger.info("tomorrow: " + tomorrow);
        try {
            Date tomorrowDay = dateFormat.parse(tomorrow);
            predicateList.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)tomorrowDay));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return predicateList;
    }
}

