/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Status;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.StatusRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WorkGroupRepository;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.mq.service.StatusService;
import io.xiaper.mq.service.redis.RedisConnectService;
import io.xiaper.mq.service.redis.RedisService;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/status"})
public class StatusController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    UserRepository userRepository;
    @Autowired
    StatusRepository statusRepository;
    @Autowired
    WorkGroupRepository workgroupRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    RedisService redisService;
    @Autowired
    StatusService statusService;
    @Autowired
    RedisConnectService redisConnectService;

    @GetMapping(value={"/request"})
    public JsonResult request(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page statusPage = this.statusRepository.findByUserOrUser_User((User)adminOptional.get(), (User)adminOptional.get(), (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u72b6\u6001\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)statusPage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/set"})
    @ResponseBody
    public JsonResult set(Principal principal, @RequestBody Map map) {
        String status = (String)map.get("status");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Status statusObject = new Status();
                statusObject.setClient(client);
                statusObject.setStatus(status);
                statusObject.setUser((User)adminOptional.get());
                this.statusRepository.save((Object)statusObject);
                if (status.equals("online")) {
                    for (WorkGroup workGroup : ((User)adminOptional.get()).getWorkGroups()) {
                        boolean isExist = this.redisService.isRoundRobinAgentExist(workGroup.getWid(), ((User)adminOptional.get()).getUid());
                        if (isExist) continue;
                        this.redisService.addRoundRobinAgent(workGroup.getWid(), ((User)adminOptional.get()).getUid());
                    }
                } else {
                    for (WorkGroup workGroup : ((User)adminOptional.get()).getWorkGroups()) {
                        this.redisService.removeRoundRobinAgent(workGroup.getWid(), ((User)adminOptional.get()).getUid());
                    }
                }
                ((User)adminOptional.get()).setAcceptStatus(status);
                this.userRepository.save(adminOptional.get());
                this.statusService.notifyAcceptStatus((User)adminOptional.get(), client, status);
                jsonResult.setMessage("\u8bbe\u7f6e\u63a5\u5f85\u72b6\u6001\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)statusObject);
            } else {
                jsonResult.setMessage("\u8bbe\u7f6e\u63a5\u5f85\u72b6\u6001-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/connect"})
    @ResponseBody
    public JsonResult connect(Principal principal, @RequestBody Map map) {
        String sessionId = (String)map.get("sessionId");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Optional statusOptional = this.statusRepository.findByStatusAndSessionIdAndClientAndUser("connected", sessionId, null, (User)userOptional.get());
                if (statusOptional.isPresent()) {
                    ((Status)statusOptional.get()).setClient(client);
                    this.statusRepository.save(statusOptional.get());
                    jsonResult.setMessage("\u8bbe\u7f6e\u8fde\u63a5\u72b6\u6001\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(statusOptional.get());
                } else {
                    jsonResult.setMessage("\u8bbe\u7f6e\u8fde\u63a5\u72b6\u6001\u5931\u8d25-status\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                }
            } else {
                jsonResult.setMessage("\u8bbe\u7f6e\u8fde\u63a5-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/disconnect"})
    @ResponseBody
    public JsonResult disconnect(Principal principal, @RequestBody Map map) {
        String sessionId = (String)map.get("sessionId");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Optional statusOptional = this.statusRepository.findByStatusAndSessionIdAndClientAndUser("disconnected", sessionId, null, (User)userOptional.get());
                if (statusOptional.isPresent()) {
                    ((Status)statusOptional.get()).setClient(client);
                    this.statusRepository.save(statusOptional.get());
                    jsonResult.setMessage("\u8bbe\u7f6e\u65ad\u5f00\u8fde\u63a5\u72b6\u6001\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(statusOptional.get());
                } else {
                    jsonResult.setMessage("\u8bbe\u7f6e\u65ad\u5f00\u8fde\u63a5\u72b6\u6001\u5931\u8d25-status\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                }
            } else {
                jsonResult.setMessage("\u8bbe\u7f6e\u65ad\u5f00\u8fde\u63a5-\u7ba1\u7406\u5458\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/agent"})
    public JsonResult agent(Principal principal, @RequestParam(value="uid") String uid, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Optional agentOptional = this.userRepository.findByUid(uid);
                if (agentOptional.isPresent()) {
                    HashMap<String, String> objectMap = new HashMap<String, String>(2);
                    objectMap.put("uid", uid);
                    objectMap.put("status", this.redisConnectService.isConnectedAgent(uid) ? "online" : "offline");
                    jsonResult.setMessage("\u83b7\u53d6\u5ba2\u670d\u5f53\u524d\u5728\u7ebf\u72b6\u6001\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(objectMap);
                } else {
                    jsonResult.setMessage("\u83b7\u53d6\u5ba2\u670d\u5f53\u524d\u5728\u7ebf\u72b6\u6001-\u5ba2\u670d\u8d26\u53f7\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5ba2\u670d\u5f53\u524d\u5728\u7ebf\u72b6\u6001-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/workGroup"})
    public JsonResult workGroup(Principal principal, @RequestParam(value="wid") String wid, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                Optional workGroupOptional = this.workgroupRepository.findByWid(wid);
                if (workGroupOptional.isPresent()) {
                    HashMap<String, String> objectMap = new HashMap<String, String>(2);
                    objectMap.put("wid", wid);
                    objectMap.put("status", this.redisService.hasRoundRobinAgentOnline(((WorkGroup)workGroupOptional.get()).getWid()) ? "online" : "offline");
                    jsonResult.setMessage("\u83b7\u53d6\u5de5\u4f5c\u7ec4\u5f53\u524d\u5728\u7ebf\u72b6\u6001\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(objectMap);
                } else {
                    jsonResult.setMessage("\u83b7\u53d6\u5de5\u4f5c\u7ec4\u5f53\u524d\u5728\u7ebf\u72b6\u6001-\u5de5\u4f5c\u7ec4\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u5de5\u4f5c\u7ec4\u5f53\u524d\u5728\u7ebf\u72b6\u6001-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="createdAtStart") String createdAtStart, @RequestParam(value="createdAtEnd") String createdAtEnd, @RequestParam(value="agentRealName") String agentRealName, @RequestParam(value="client") String client) {
        this.logger.info("page {}, size {}, createdAtStart {},  createdAtEnd {},  agentRealName {}, client {}", new Object[]{page, size, createdAtStart, createdAtEnd, agentRealName, client});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Specification specification = this.getSpecification((User)adminOptional.get(), "status", "", createdAtStart, createdAtEnd, "", agentRealName, client);
                Page statusPage = this.statusRepository.findAll(specification, (Pageable)pageable);
                jsonResult.setMessage("\u641c\u7d22\u5728\u7ebf\u72b6\u6001\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)statusPage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

