/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Synonym;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.SynonymRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/synonym"})
public class SynonymController
extends BaseController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    SynonymRepository synonymRepository;

    @GetMapping(value={"/get"})
    public JsonResult get(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page synonymPage = this.synonymRepository.findByUserAndSynonym((User)adminOptional.get(), false, (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u76f8\u4f3c\u8bcd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)synonymPage);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u76f8\u4f3c\u8bcd\u5931\u8d25-\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public JsonResult create(Principal principal, @RequestBody Map map) {
        String standard = (String)map.get("standard");
        List synonyms = (List)map.get("synonyms");
        this.logger.info("standard {}, synonyms {}", (Object)standard, (Object)synonyms);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            Synonym synonym = new Synonym();
            synonym.setSid(JpaUtil.randomId());
            synonym.setStandard(standard);
            synonym.setSynonym(false);
            synonym.setUser((User)adminOptional.get());
            for (String syn : synonyms) {
                Synonym synonym1 = new Synonym();
                synonym1.setSid(JpaUtil.randomId());
                synonym1.setStandard(syn);
                synonym1.setSynonym(true);
                synonym1.setUser((User)adminOptional.get());
                this.synonymRepository.save((Object)synonym1);
                synonym.getSynonyms().add(synonym1);
            }
            this.synonymRepository.save((Object)synonym);
            jsonResult.setMessage("\u521b\u5efa\u76f8\u4f3c\u8bcd\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)synonym);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public JsonResult update(Principal principal, @RequestBody Map map) {
        String sid = (String)map.get("sid");
        String standard = (String)map.get("standard");
        List synonyms = (List)map.get("synonyms");
        this.logger.info("standard {}, synonyms {}", (Object)standard, (Object)synonyms);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            Optional synonymOptional = this.synonymRepository.findBySid(sid);
            if (synonymOptional.isPresent()) {
                ((Synonym)synonymOptional.get()).setStandard(standard);
                Iterator iterator = ((Synonym)synonymOptional.get()).getSynonyms().iterator();
                while (iterator.hasNext()) {
                    Synonym syn = (Synonym)iterator.next();
                    this.synonymRepository.delete((Object)syn);
                    iterator.remove();
                }
                for (String syn : synonyms) {
                    Synonym synonymSyn = new Synonym();
                    synonymSyn.setSid(JpaUtil.randomId());
                    synonymSyn.setStandard(syn);
                    synonymSyn.setSynonym(true);
                    synonymSyn.setUser((User)adminOptional.get());
                    ((Synonym)synonymOptional.get()).getSynonyms().add(synonymSyn);
                }
                this.synonymRepository.save(synonymOptional.get());
                jsonResult.setMessage("\u66f4\u65b0\u76f8\u4f3c\u8bcd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData(synonymOptional.get());
            } else {
                jsonResult.setMessage("\u66f4\u65b0\u76f8\u4f3c\u8bcd\u5931\u8d25-sid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-3);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("\u66f4\u65b0\u76f8\u4f3c\u8bcd\u5931\u8d25-access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public JsonResult delete(Principal principal, @RequestBody Map map) {
        String sid = (String)map.get("sid");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional synonymOptional = this.synonymRepository.findBySid(sid);
            Iterator iterator = ((Synonym)synonymOptional.get()).getSynonyms().iterator();
            while (iterator.hasNext()) {
                Synonym syn = (Synonym)iterator.next();
                this.synonymRepository.delete((Object)syn);
                iterator.remove();
            }
            this.synonymRepository.delete(synonymOptional.get());
            jsonResult.setMessage("\u5220\u9664\u76f8\u4f3c\u8bcd\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)sid);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

