/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Taboo;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.TabooRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/taboo"})
public class TabooController
extends BaseController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    TabooRepository tabooRepository;

    @GetMapping(value={"/get"})
    public JsonResult get(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            Page filterList = this.tabooRepository.findByUserAndSynonym((User)adminOptional.get(), false, (Pageable)pageable);
            jsonResult.setMessage("\u83b7\u53d6\u654f\u611f\u8bcd\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)filterList);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public JsonResult create(Principal principal, @RequestBody Map map) {
        String standard = (String)map.get("standard");
        List synonyms = (List)map.get("synonyms");
        this.logger.info("standard {}, synonyms {}", (Object)standard, (Object)synonyms);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            Taboo taboo = new Taboo();
            taboo.setTid(JpaUtil.randomId());
            taboo.setStandard(standard);
            taboo.setSynonym(false);
            taboo.setUser((User)adminOptional.get());
            for (String syn : synonyms) {
                Taboo taboo1 = new Taboo();
                taboo1.setTid(JpaUtil.randomId());
                taboo1.setStandard(syn);
                taboo1.setSynonym(true);
                taboo1.setUser((User)adminOptional.get());
                this.tabooRepository.save((Object)taboo1);
                taboo.getTaboos().add(taboo1);
            }
            this.tabooRepository.save((Object)taboo);
            jsonResult.setMessage("\u521b\u5efa\u654f\u611f\u8bcd\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)taboo);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public JsonResult update(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String standard = (String)map.get("standard");
        List synonyms = (List)map.get("synonyms");
        this.logger.info("standard {}, synonyms {}", (Object)standard, (Object)synonyms);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            Optional tabooOptional = this.tabooRepository.findByTid(tid);
            if (tabooOptional.isPresent()) {
                ((Taboo)tabooOptional.get()).setStandard(standard);
                Iterator iterator = ((Taboo)tabooOptional.get()).getTaboos().iterator();
                while (iterator.hasNext()) {
                    Taboo taboo = (Taboo)iterator.next();
                    this.tabooRepository.delete((Object)taboo);
                    iterator.remove();
                }
                for (String syn : synonyms) {
                    Taboo taboo = new Taboo();
                    taboo.setTid(JpaUtil.randomId());
                    taboo.setStandard(syn);
                    taboo.setSynonym(true);
                    taboo.setUser((User)adminOptional.get());
                    this.tabooRepository.save((Object)taboo);
                    ((Taboo)tabooOptional.get()).getTaboos().add(taboo);
                }
                this.tabooRepository.save(tabooOptional.get());
                jsonResult.setMessage("\u66f4\u65b0\u654f\u611f\u8bcd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData(tabooOptional.get());
            } else {
                jsonResult.setMessage("\u66f4\u65b0\u654f\u611f\u8bcd\u5931\u8d25-tid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-3);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public JsonResult delete(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional tabooOptional = this.tabooRepository.findByTid(tid);
            Iterator iterator = ((Taboo)tabooOptional.get()).getTaboos().iterator();
            while (iterator.hasNext()) {
                Taboo taboo = (Taboo)iterator.next();
                this.tabooRepository.delete((Object)taboo);
                iterator.remove();
            }
            this.tabooRepository.delete(tabooOptional.get());
            jsonResult.setMessage("\u5220\u9664\u654f\u611f\u8bcd\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)tid);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="nickname") String nickname) {
        JsonResult jsonResult = new JsonResult();
        if (principal == null) {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }
}

