/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.model.Tag;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.TagRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JsonResult;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tag"})
public class TagController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    TagRepository tagRepository;

    @GetMapping(value={"/get"})
    public JsonResult tags(Principal principal, @RequestParam(value="robot") boolean robot) {
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        JsonResult jsonResult = new JsonResult();
        if (userOptional.isPresent()) {
            jsonResult.setMessage("\u83b7\u53d6\u6807\u7b7e\u6210\u529f");
            jsonResult.setStatus_code(200);
            List tagList = this.tagRepository.findByUserAndRobot((User)userOptional.get(), robot);
            jsonResult.setData((Object)tagList);
        } else {
            jsonResult.setMessage("\u83b7\u53d6\u6807\u7b7e\u5931\u8d25");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public JsonResult tagCreate(Principal principal, @RequestBody Map map) {
        String name = (String)map.get("name");
        boolean robot = (Boolean)map.get("robot");
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        JsonResult jsonResult = new JsonResult();
        if (userOptional.isPresent()) {
            jsonResult.setMessage("\u521b\u5efa\u6807\u7b7e\u6210\u529f");
            jsonResult.setStatus_code(200);
            Tag tag = new Tag();
            tag.setName(name);
            tag.setRobot(robot);
            tag.setUser((User)userOptional.get());
            this.tagRepository.save((Object)tag);
            jsonResult.setData((Object)tag);
        } else {
            jsonResult.setMessage("\u521b\u5efa\u6807\u7b7e\u5931\u8d25");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/make"})
    @ResponseBody
    public JsonResult tagMake(Principal principal, @RequestBody Map map) {
        String username = (String)map.get("username");
        String name = (String)map.get("name");
        boolean robot = (Boolean)map.get("robot");
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        JsonResult jsonResult = new JsonResult();
        if (userOptional.isPresent()) {
            jsonResult.setMessage("\u6807\u7b7e\u6210\u529f");
            jsonResult.setStatus_code(200);
            Tag tag = new Tag();
            tag.setName(name);
            tag.setRobot(robot);
            tag.setUser((User)userOptional.get());
            this.tagRepository.save((Object)tag);
            jsonResult.setData((Object)tag);
        } else {
            jsonResult.setMessage("\u521b\u5efa\u6807\u7b7e\u5931\u8d25");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public JsonResult tagDelete(Principal principal, @RequestBody Map map) {
        Integer tagId = (Integer)map.get("id");
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        JsonResult jsonResult = new JsonResult();
        if (userOptional.isPresent()) {
            jsonResult.setMessage("\u5220\u9664\u6807\u7b7e\u6210\u529f");
            jsonResult.setStatus_code(200);
            this.tagRepository.deleteById((Object)tagId);
            jsonResult.setData((Object)tagId);
        } else {
            jsonResult.setMessage("\u5220\u9664\u6807\u7b7e\u5931\u8d25");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/user"})
    public JsonResult user(Principal principal, @RequestParam(value="username") String username) {
        JsonResult jsonResult = new JsonResult();
        return jsonResult;
    }
}

