/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.constant.UserConsts;
import io.xiaper.jpa.model.Company;
import io.xiaper.jpa.model.Invite;
import io.xiaper.jpa.model.Ip;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Region;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.Transfer;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.AppRepository;
import io.xiaper.jpa.repository.BlockRepository;
import io.xiaper.jpa.repository.BrowseRepository;
import io.xiaper.jpa.repository.CompanyRepository;
import io.xiaper.jpa.repository.CountryRepository;
import io.xiaper.jpa.repository.InviteRepository;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.QueueRepository;
import io.xiaper.jpa.repository.RegionRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.TransferRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WorkGroupRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.mq.service.IpService;
import io.xiaper.mq.service.MessagingTemplate;
import io.xiaper.mq.service.ThreadService;
import io.xiaper.mq.service.UserService;
import io.xiaper.mq.service.impl.RouteServiceImpl;
import io.xiaper.mq.service.redis.RedisConnectService;
import io.xiaper.mq.service.redis.RedisQueueService;
import io.xiaper.mq.service.redis.RedisService;
import io.xiaper.mq.service.redis.RedisStatisticService;
import io.xiaper.mq.service.redis.RedisThreadService;
import io.xiaper.rest.controller.v1.BaseController;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/thread"})
public class ThreadController
extends BaseController {
    @Autowired
    AppRepository appRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    WorkGroupRepository workgroupRepository;
    @Autowired
    BrowseRepository browseRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    TransferRepository transferRepository;
    @Autowired
    InviteRepository inviteRepository;
    @Autowired
    CompanyRepository companyRepository;
    @Autowired
    CountryRepository countryRepository;
    @Autowired
    RegionRepository regionRepository;
    @Autowired
    BlockRepository blockRepository;
    @Autowired
    RedisService redisService;
    @Autowired
    RedisConnectService redisConnectService;
    @Autowired
    RedisQueueService redisQueueService;
    @Autowired
    RedisThreadService redisThreadService;
    @Autowired
    RedisStatisticService redisStatisticService;
    @Autowired
    RouteServiceImpl routeService;
    @Autowired
    ThreadService threadService;
    @Autowired
    UserService userService;
    @Autowired
    IpService ipService;
    @Autowired
    MessagingTemplate messagingTemplate;

    @GetMapping(value={"/request"})
    public JsonResult request(Principal principal, @RequestParam(value="wId") String workGroupWid, @RequestParam(value="type") String requestType, @RequestParam(value="aId") String agentUid, @RequestParam(value="client") String client) {
        this.logger.info("workGroupWid: {}, requestType {}, agentUid {}, client: {}", new Object[]{workGroupWid, requestType, agentUid, client});
        if (requestType.equals("appointed")) {
            return this.appoint(principal, agentUid, client);
        }
        return this.workGroup(principal, workGroupWid, client);
    }

    @GetMapping(value={"/request/shop"})
    public JsonResult requestShop(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        return jsonResult;
    }

    @GetMapping(value={"/appoint"})
    public JsonResult appoint(Principal principal, @RequestParam(value="aId") String agentUid, @RequestParam(value="client") String client) {
        this.logger.info("agentUid {}, client: {}", (Object)agentUid, (Object)client);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            User notificationUser = this.userService.getNotificationUser();
            Optional agentOptional = this.userRepository.findByUid(agentUid);
            Thread thread = this.threadService.getAppointThread((User)visitorOptional.get(), (User)agentOptional.get(), client);
            if (this.redisConnectService.isConnectedAgent(agentUid)) {
                Message message;
                Optional messageOptional = this.messageRepository.findFirstByThreadAndTypeOrderByIdDesc(thread, "notification_thread");
                if (messageOptional.isPresent()) {
                    message = (Message)messageOptional.get();
                } else {
                    message = new Message();
                    message.setMid(JpaUtil.randomId());
                    message.setWid("appointed");
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setThread(thread);
                    message.setType("notification_thread");
                    message.setContent(((User)agentOptional.get()).getWelcomeTip());
                    message.setUser(notificationUser);
                    this.messageRepository.save((Object)message);
                }
                this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                this.redisStatisticService.addCurrentThread(((User)visitorOptional.get()).getSubDomain(), message.getThread().getTid());
                jsonResult.setMessage("\u5f00\u59cb\u65b0\u4f1a\u8bdd");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)message);
            } else {
                Message message;
                this.threadService.closeOfflineThread(thread);
                Optional messageOptional = this.messageRepository.findFirstByThreadAndTypeOrderByIdDesc(thread, "notification_offline");
                if (messageOptional.isPresent()) {
                    message = (Message)messageOptional.get();
                } else {
                    message = new Message();
                    message.setMid(JpaUtil.randomId());
                    message.setWid("appointed");
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setThread(thread);
                    message.setType("notification_offline");
                    message.setContent("\u5f53\u524d\u5ba2\u670d\u4e0d\u5728\u7ebf\uff0c\u8bf7\u7559\u8a00");
                    message.setUser(notificationUser);
                    this.messageRepository.save((Object)message);
                }
                jsonResult.setMessage("\u6307\u5b9a\u5ba2\u670d\u4e0d\u5728\u7ebf\uff0c\u8bf7\u81ea\u52a9\u67e5\u8be2\u6216\u7559\u8a00");
                jsonResult.setStatus_code(204);
                jsonResult.setData((Object)message);
            }
            return jsonResult;
        }
        jsonResult.setMessage("\u8bf7\u6c42\u4f1a\u8bdd\u5931\u8d25-access token\u65e0\u6548");
        jsonResult.setStatus_code(-1);
        jsonResult.setData((Object)false);
        return jsonResult;
    }

    @GetMapping(value={"/workGroup"})
    public JsonResult workGroup(Principal principal, @RequestParam(value="wId") String workGroupWid, @RequestParam(value="client") String client) {
        this.logger.info("workGroup wId {}, client {}", (Object)workGroupWid, (Object)client);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            User notificationUser = this.userService.getNotificationUser();
            Optional workGroupOptional = this.workgroupRepository.findByWid(workGroupWid);
            if (workGroupOptional.isPresent()) {
                Thread thread = this.threadService.getWorkGroupThread((User)visitorOptional.get(), (WorkGroup)workGroupOptional.get(), client);
                if (((WorkGroup)workGroupOptional.get()).isQuestionnaire()) {
                    Message message;
                    Optional messageOptional = this.messageRepository.findFirstByThreadAndTypeOrderByIdDesc(thread, "questionnaire");
                    if (messageOptional.isPresent()) {
                        message = (Message)messageOptional.get();
                    } else {
                        message = new Message();
                        message.setWid(workGroupWid);
                        message.setMid(JpaUtil.randomId());
                        message.setClient(ClientConsts.CLIENT_SYSTEM);
                        message.setThread(thread);
                        message.setType("questionnaire");
                        message.setContent("\u54a8\u8be2\u524d\u95ee\u5377");
                        message.setQuestionnaire(((WorkGroup)workGroupOptional.get()).getQuestionnaire());
                        message.setUser(notificationUser);
                        this.messageRepository.save((Object)message);
                    }
                    jsonResult.setMessage("\u8c03\u67e5\u95ee\u5377");
                    jsonResult.setStatus_code(205);
                    jsonResult.setData((Object)message);
                    return jsonResult;
                }
                return this.routeService.route((WorkGroup)workGroupOptional.get(), thread, (User)visitorOptional.get(), notificationUser, client);
            }
            jsonResult.setMessage("\u8bf7\u6c42\u4f1a\u8bdd\u5931\u8d25-wId\u4e0d\u5b58\u5728");
            jsonResult.setStatus_code(-2);
            jsonResult.setData((Object)false);
        } else {
            jsonResult.setMessage("\u8bf7\u6c42\u4f1a\u8bdd\u5931\u8d25-access token\u65e0\u6548");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/questionnaire"})
    public JsonResult questionnaire(Principal principal, @RequestParam(value="tId") String threadTid, @RequestParam(value="itemQid") String questionnaireItemItemQid, @RequestParam(value="client") String client) {
        this.logger.info("threadId {}, itemQid {}, client {}", new Object[]{threadTid, questionnaireItemItemQid, client});
        JsonResult jsonResult = new JsonResult();
        Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
        Optional threadOptional = this.threadRepository.findByTid(threadTid);
        if (principal != null) {
            if (threadOptional.isPresent()) {
                Set workGroups;
                if (questionnaireItemItemQid.equals("201810061551181")) {
                    this.logger.warn("\u7559\u5b66\uff0c\u9700\u8981\u5339\u914d\u5750\u6807");
                } else {
                    this.logger.info("\u5176\u4ed6");
                }
                Ip ip = this.ipService.getIPZone();
                Company company = new Company();
                Optional regionCityOptional = this.regionRepository.findFirstByNameContaining(ip.getCity());
                if (regionCityOptional.isPresent()) {
                    Set companies = ((Region)regionCityOptional.get()).getCompanies();
                    for (Company myCompany : companies) {
                        if (!myCompany.getUser().getUid().equals(((Thread)threadOptional.get()).getWorkGroup().getUser().getUid())) continue;
                        company = myCompany;
                    }
                } else {
                    Optional regionOptional = this.regionRepository.findFirstByNameContaining(ip.getRegion());
                    if (regionOptional.isPresent()) {
                        Set companies = ((Region)regionCityOptional.get()).getCompanies();
                        for (Company myCompany : companies) {
                            if (!myCompany.getUser().getUid().equals(((Thread)threadOptional.get()).getWorkGroup().getUser().getUid())) continue;
                            company = myCompany;
                        }
                    } else {
                        Optional companyOptional = this.companyRepository.findFirstByNameContaining("\u5317\u4eac");
                        if (companyOptional.isPresent()) {
                            company = (Company)companyOptional.get();
                        }
                    }
                }
                if ((workGroups = this.workgroupRepository.findByCompany(company)).size() > 1) {
                    Message message = new Message();
                    message.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                    message.setMid(JpaUtil.randomId());
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setThread((Thread)threadOptional.get());
                    message.setType("workGroup");
                    message.setContent("\u8bf7\u9009\u62e9\u5de5\u4f5c\u7ec4");
                    message.setWorkGroups(workGroups);
                    message.setUser(this.userService.getNotificationUser());
                    this.messageRepository.save((Object)message);
                    jsonResult.setMessage("\u83b7\u53d6\u5de5\u4f5c\u7ec4\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData((Object)message);
                } else {
                    if (workGroups.size() == 1) {
                        WorkGroup workGroup2 = new WorkGroup();
                        for (WorkGroup workGroup2 : workGroups) {
                        }
                        return this.routeService.route(workGroup2, (Thread)threadOptional.get(), (User)visitorOptional.get(), this.userService.getNotificationUser(), client);
                    }
                    jsonResult.setMessage("\u672a\u627e\u5230\u76f8\u5e94\u5de5\u4f5c\u7ec4");
                    jsonResult.setStatus_code(-2);
                    jsonResult.setData((Object)"failed");
                }
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u56fd\u5bb6\u5931\u8d25-\u4f1a\u8bdd\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)"failed");
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/choose/workGroup/liuxue"})
    public JsonResult chooseWorkGroupLiuXue(Principal principal, @RequestParam(value="wId") String workGroupWid, @RequestParam(value="nickname") String workGroupNickname, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
        Optional workGroupOptional = this.workgroupRepository.findByWid(workGroupWid);
        Thread thread = this.threadService.getWorkGroupThread((User)visitorOptional.get(), (WorkGroup)workGroupOptional.get(), client);
        if (principal != null) {
            Ip ip = this.ipService.getIPZone();
            Company company2 = new Company();
            Optional regionCityOptional = this.regionRepository.findFirstByNameContaining(ip.getCity());
            if (regionCityOptional.isPresent()) {
                Set companies = ((Region)regionCityOptional.get()).getCompanies();
                for (Company company2 : companies) {
                }
            } else {
                Optional regionOptional = this.regionRepository.findFirstByNameContaining(ip.getRegion());
                if (regionOptional.isPresent()) {
                    Set companies = ((Region)regionCityOptional.get()).getCompanies();
                    for (Company company2 : companies) {
                    }
                } else {
                    return this.routeService.route((WorkGroup)workGroupOptional.get(), thread, (User)visitorOptional.get(), this.userService.getNotificationUser(), client);
                }
            }
            boolean flag = false;
            Set workGroups = this.workgroupRepository.findByCompany(company2);
            if (workGroups.size() >= 1) {
                for (WorkGroup workGroup : workGroups) {
                    if (!workGroup.getNickname().equals(workGroupNickname)) continue;
                    flag = true;
                    return this.routeService.route(workGroup, thread, (User)visitorOptional.get(), this.userService.getNotificationUser(), client);
                }
            }
            if (!flag) {
                return this.routeService.route((WorkGroup)workGroupOptional.get(), thread, (User)visitorOptional.get(), this.userService.getNotificationUser(), client);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/choose/workGroup"})
    public JsonResult chooseWorkGroup(Principal principal, @RequestParam(value="wId") String workGroupWid, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
        Optional workGroupOptional = this.workgroupRepository.findByWid(workGroupWid);
        Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
        if (principal != null) {
            Thread thread = this.threadService.getWorkGroupThread((User)visitorOptional.get(), (WorkGroup)workGroupOptional.get(), client);
            return this.routeService.route((WorkGroup)workGroupOptional.get(), thread, (User)visitorOptional.get(), (User)userNotification.get(), client);
        }
        jsonResult.setMessage("access token invalid");
        jsonResult.setStatus_code(-1);
        jsonResult.setData((Object)"failed");
        return jsonResult;
    }

    @PostMapping(value={"/transfer"})
    @ResponseBody
    public JsonResult transfer(Principal principal, @RequestBody Map map) {
        String uid = (String)map.get("uid");
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional fromUserOptional = this.userRepository.findByUsername(principal.getName());
            if (fromUserOptional.isPresent()) {
                Optional toUserOptional = this.userRepository.findByUid(uid);
                if (toUserOptional.isPresent()) {
                    if (this.redisConnectService.isConnectedAgent(((User)toUserOptional.get()).getUid())) {
                        Optional threadOptional = this.threadRepository.findByTid(tid);
                        if (threadOptional.isPresent()) {
                            Transfer threadTransfer = new Transfer();
                            threadTransfer.settTid(JpaUtil.randomId());
                            threadTransfer.setThread((Thread)threadOptional.get());
                            threadTransfer.setFromUser((User)fromUserOptional.get());
                            threadTransfer.setFromClient(client);
                            threadTransfer.setToUser((User)toUserOptional.get());
                            this.transferRepository.save((Object)threadTransfer);
                            Message message = new Message();
                            message.setMid(JpaUtil.randomId());
                            if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                                message.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                            } else {
                                message.setWid("appointed");
                            }
                            message.setClient(ClientConsts.CLIENT_SYSTEM);
                            message.setThread((Thread)threadOptional.get());
                            message.setType("notification_transfer");
                            message.setContent("\u8f6c\u63a5\u4f1a\u8bdd");
                            message.setUser(this.userService.getNotificationUser());
                            message.setTransfer(threadTransfer);
                            this.messageRepository.save((Object)message);
                            this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                            jsonResult.setMessage("\u8f6c\u63a5\u4f1a\u8bdd\u6210\u529f");
                            jsonResult.setStatus_code(200);
                            jsonResult.setData((Object)threadTransfer);
                        } else {
                            jsonResult.setMessage("\u4f1a\u8bddtid\u4e0d\u5b58\u5728");
                            jsonResult.setStatus_code(-4);
                            jsonResult.setData((Object)false);
                        }
                    } else {
                        jsonResult.setMessage("\u5ba2\u670d\u8d26\u53f7" + ((User)toUserOptional.get()).getRealName() + "\u4e0d\u5728\u7ebf");
                        jsonResult.setStatus_code(-4);
                        jsonResult.setData((Object)false);
                    }
                } else {
                    jsonResult.setMessage("\u88ab\u8f6c\u63a5\u5ba2\u670d\u8d26\u53f7\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/transfer/workGroup"})
    @ResponseBody
    public JsonResult transferWorkGroup(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String wid = (String)map.get("wid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            Optional workGroupOptional = this.workgroupRepository.findByWid(wid);
            if (threadOptional.isPresent() && workGroupOptional.isPresent()) {
                User visitor = ((Thread)threadOptional.get()).getVisitor();
                User notificationUser = this.userService.getNotificationUser();
                return this.routeService.route((WorkGroup)workGroupOptional.get(), (Thread)threadOptional.get(), visitor, notificationUser, client);
            }
            jsonResult.setMessage("\u8f6c\u63a5\u5931\u8d25-tid\u6216\u8005wid\u4e0d\u5b58\u5728");
            jsonResult.setStatus_code(-2);
            jsonResult.setData((Object)"failed");
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/transfer/accept"})
    @ResponseBody
    public JsonResult transferAccept(Principal principal, @RequestBody Map map) {
        String tTid = (String)map.get("ttid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Optional threadTransferOptional = this.transferRepository.findByTTid(tTid);
                if (threadTransferOptional.isPresent()) {
                    Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                    ((Transfer)threadTransferOptional.get()).getThread().setAgent((User)userOptional.get());
                    ((Transfer)threadTransferOptional.get()).getThread().getAgents().remove(((Transfer)threadTransferOptional.get()).getFromUser());
                    ((Transfer)threadTransferOptional.get()).getThread().getAgents().add(((Transfer)threadTransferOptional.get()).getToUser());
                    ((Transfer)threadTransferOptional.get()).setToClient(client);
                    ((Transfer)threadTransferOptional.get()).setAccepted(true);
                    ((Transfer)threadTransferOptional.get()).setActionedAt(new Date());
                    this.transferRepository.save(threadTransferOptional.get());
                    Message message = new Message();
                    message.setMid(JpaUtil.randomId());
                    if (((Transfer)threadTransferOptional.get()).getThread().getWorkGroup() != null) {
                        message.setWid(((Transfer)threadTransferOptional.get()).getThread().getWorkGroup().getWid());
                    } else {
                        message.setWid("appointed");
                    }
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setThread(((Transfer)threadTransferOptional.get()).getThread());
                    message.setType("notification_transfer_accept");
                    message.setContent("\u63a5\u53d7\u8f6c\u63a5\u4f1a\u8bdd");
                    message.setUser((User)userNotification.get());
                    message.setTransfer((Transfer)threadTransferOptional.get());
                    this.messageRepository.save((Object)message);
                    this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                    jsonResult.setMessage("\u63a5\u53d7\u8f6c\u63a5\u4f1a\u8bdd\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(threadTransferOptional.get());
                } else {
                    jsonResult.setMessage("\u4f1a\u8bdd\u8f6c\u63a5\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/transfer/reject"})
    @ResponseBody
    public JsonResult transferReject(Principal principal, @RequestBody Map map) {
        String tTid = (String)map.get("ttid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Optional threadTransferOptional = this.transferRepository.findByTTid(tTid);
                if (threadTransferOptional.isPresent()) {
                    ((Transfer)threadTransferOptional.get()).setToClient(client);
                    ((Transfer)threadTransferOptional.get()).setAccepted(false);
                    ((Transfer)threadTransferOptional.get()).setActionedAt(new Date());
                    this.transferRepository.save(threadTransferOptional.get());
                    Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                    Message message = new Message();
                    message.setMid(JpaUtil.randomId());
                    if (((Transfer)threadTransferOptional.get()).getThread().getWorkGroup() != null) {
                        message.setWid(((Transfer)threadTransferOptional.get()).getThread().getWorkGroup().getWid());
                    } else {
                        message.setWid("appointed");
                    }
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setThread(((Transfer)threadTransferOptional.get()).getThread());
                    message.setType("notification_transfer_reject");
                    message.setContent("\u62d2\u7edd\u8f6c\u63a5\u4f1a\u8bdd");
                    message.setUser((User)userNotification.get());
                    message.setTransfer((Transfer)threadTransferOptional.get());
                    this.messageRepository.save((Object)message);
                    this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                    jsonResult.setMessage("\u62d2\u7edd\u8f6c\u63a5\u4f1a\u8bdd\u6210\u529f");
                    jsonResult.setStatus_code(200);
                    jsonResult.setData(threadTransferOptional.get());
                } else {
                    jsonResult.setMessage("\u4f1a\u8bdd\u8f6c\u63a5\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/invite"})
    @ResponseBody
    public JsonResult invite(Principal principal, @RequestBody Map map) {
        List uids = (List)map.get("uids");
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional fromUserOptional = this.userRepository.findByUsername(principal.getName());
            if (fromUserOptional.isPresent()) {
                Optional threadOptional = this.threadRepository.findByTid(tid);
                if (threadOptional.isPresent()) {
                    Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                    for (int i = 0; i < uids.size(); ++i) {
                        Optional toUserOptional = this.userRepository.findByUid((String)uids.get(i));
                        if (!toUserOptional.isPresent()) continue;
                        if (this.redisConnectService.isConnectedAgent(((User)toUserOptional.get()).getUid())) {
                            Invite threadInvite = new Invite();
                            threadInvite.settIid(JpaUtil.randomId());
                            threadInvite.setType("thread");
                            threadInvite.setThread((Thread)threadOptional.get());
                            threadInvite.setFromUser((User)fromUserOptional.get());
                            threadInvite.setFromClient(client);
                            threadInvite.setToUser((User)toUserOptional.get());
                            this.inviteRepository.save((Object)threadInvite);
                            Message message = new Message();
                            message.setMid(JpaUtil.randomId());
                            if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                                message.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                            } else {
                                message.setWid("appointed");
                            }
                            message.setClient(ClientConsts.CLIENT_SYSTEM);
                            message.setThread((Thread)threadOptional.get());
                            message.setType("notification_invite");
                            message.setContent("\u9080\u8bf7\u4f1a\u8bdd");
                            message.setUser((User)userNotification.get());
                            message.setInvite(threadInvite);
                            this.messageRepository.save((Object)message);
                            this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                            jsonResult.setMessage("\u9080\u8bf7\u4f1a\u8bdd\u6210\u529f");
                            jsonResult.setStatus_code(200);
                            jsonResult.setData((Object)threadInvite);
                            continue;
                        }
                        jsonResult.setMessage("\u5ba2\u670d\u8d26\u53f7" + ((User)toUserOptional.get()).getRealName() + "\u4e0d\u5728\u7ebf");
                        jsonResult.setStatus_code(-4);
                        jsonResult.setData((Object)false);
                    }
                } else {
                    jsonResult.setMessage("\u4f1a\u8bddtid\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/invite/accept"})
    @ResponseBody
    public JsonResult inviteAccept(Principal principal, @RequestBody Map map) {
        String tIid = (String)map.get("tiid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Optional threadInviteOptional = this.inviteRepository.findByTIid(tIid);
                if (threadInviteOptional.isPresent()) {
                    ((Invite)threadInviteOptional.get()).getThread().getAgents().add(((Invite)threadInviteOptional.get()).getThread().getAgent());
                    ((Invite)threadInviteOptional.get()).setToClient(client);
                    ((Invite)threadInviteOptional.get()).setAccepted(true);
                    ((Invite)threadInviteOptional.get()).setActionedAt(new Date());
                    this.inviteRepository.save(threadInviteOptional.get());
                    Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                    Message message = new Message();
                    message.setMid(JpaUtil.randomId());
                    if (((Invite)threadInviteOptional.get()).getThread().getWorkGroup() != null) {
                        message.setWid(((Invite)threadInviteOptional.get()).getThread().getWorkGroup().getWid());
                    } else {
                        message.setWid("appointed");
                    }
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setThread(((Invite)threadInviteOptional.get()).getThread());
                    message.setType("notification_invite_accept");
                    message.setContent("\u63a5\u53d7\u9080\u8bf7\u4f1a\u8bdd");
                    message.setUser((User)userNotification.get());
                    message.setInvite((Invite)threadInviteOptional.get());
                    this.messageRepository.save((Object)message);
                    this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                    jsonResult.setMessage("\u63a5\u53d7\u9080\u8bf7\u4f1a\u8bdd\u6210\u529f");
                    jsonResult.setStatus_code(200);
                } else {
                    jsonResult.setMessage("\u88ab\u9080\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/invite/reject"})
    @ResponseBody
    public JsonResult inviteReject(Principal principal, @RequestBody Map map) {
        String tIid = (String)map.get("tiid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Optional threadInviteOptional = this.inviteRepository.findByTIid(tIid);
                if (threadInviteOptional.isPresent()) {
                    ((Invite)threadInviteOptional.get()).setToClient(client);
                    ((Invite)threadInviteOptional.get()).setAccepted(false);
                    ((Invite)threadInviteOptional.get()).setActionedAt(new Date());
                    this.inviteRepository.save(threadInviteOptional.get());
                    Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                    Message message = new Message();
                    message.setMid(JpaUtil.randomId());
                    if (((Invite)threadInviteOptional.get()).getThread().getWorkGroup() != null) {
                        message.setWid(((Invite)threadInviteOptional.get()).getThread().getWorkGroup().getWid());
                    } else {
                        message.setWid("appointed");
                    }
                    message.setClient(ClientConsts.CLIENT_SYSTEM);
                    message.setThread(((Invite)threadInviteOptional.get()).getThread());
                    message.setType("notification_invite_reject");
                    message.setContent("\u62d2\u7edd\u9080\u8bf7\u4f1a\u8bdd");
                    message.setUser((User)userNotification.get());
                    message.setInvite((Invite)threadInviteOptional.get());
                    this.messageRepository.save((Object)message);
                    this.messagingTemplate.convertAndSend("message.user.#", (Object)message);
                    jsonResult.setMessage("\u62d2\u7edd\u9080\u8bf7\u4f1a\u8bdd\u6210\u529f");
                    jsonResult.setStatus_code(200);
                } else {
                    jsonResult.setMessage("\u88ab\u9080\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    jsonResult.setStatus_code(-3);
                    jsonResult.setData((Object)false);
                }
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"/invite/exit"})
    @ResponseBody
    public JsonResult inviteExit(Principal principal, @RequestBody Map map) {
        String tIid = (String)map.get("tiid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (!userOptional.isPresent()) return jsonResult;
        }
        jsonResult.setMessage("access token invalid");
        jsonResult.setStatus_code(-1);
        jsonResult.setData((Object)"failed");
        return jsonResult;
    }

    @PostMapping(value={"/update/current"})
    @ResponseBody
    public JsonResult updateCurrent(Principal principal, @RequestBody Map map) {
        String preTid = (String)map.get("preTid");
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional;
            Optional preThreadOptional = this.threadRepository.findByTid(preTid);
            if (preThreadOptional.isPresent()) {
                ((Thread)preThreadOptional.get()).setCurrent(false);
                this.threadRepository.save(preThreadOptional.get());
            }
            if ((threadOptional = this.threadRepository.findByTid(tid)).isPresent()) {
                ((Thread)threadOptional.get()).clearUnreadCount();
                ((Thread)threadOptional.get()).setCurrent(true);
                this.threadRepository.save(threadOptional.get());
                HashMap<String, String> objectMap = new HashMap<String, String>(2);
                objectMap.put("preTid", preTid);
                objectMap.put("tid", tid);
                jsonResult.setMessage("\u66f4\u65b0\u5f53\u524d\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData(objectMap);
            } else {
                jsonResult.setMessage("\u66f4\u65b0\u5f53\u524d\u4f1a\u8bdd\u5931\u8d25-preTid \u6216 tid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)"failed");
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/is/top"})
    public JsonResult isTop(Principal principal, @RequestParam(value="tid") String tid, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            Optional threadOptional = this.threadRepository.findByTid(tid);
            if (threadOptional.isPresent()) {
                boolean contains = ((Thread)threadOptional.get()).getTopSet().contains(userOptional.get());
                jsonResult.setMessage("\u67e5\u8be2\u4f1a\u8bdd\u7f6e\u9876\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)contains);
            } else {
                jsonResult.setMessage("\u67e5\u8be2\u4f1a\u8bdd\u7f6e\u9876\u5931\u8d25-\u4f1a\u8bdd\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)tid);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/mark/top"})
    @ResponseBody
    public JsonResult markTop(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (threadOptional.isPresent()) {
                ((Thread)threadOptional.get()).getTopSet().add(userOptional.get());
                this.threadRepository.save(threadOptional.get());
                jsonResult.setMessage("\u8bbe\u7f6e\u4f1a\u8bdd\u7f6e\u9876\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)tid);
            } else {
                jsonResult.setMessage("\u8bbe\u7f6e\u4f1a\u8bdd\u7f6e\u9876\u5931\u8d25-tid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)"failed");
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/unmark/top"})
    @ResponseBody
    public JsonResult unMarkTop(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (threadOptional.isPresent()) {
                ((Thread)threadOptional.get()).getTopSet().remove(userOptional.get());
                this.threadRepository.save(threadOptional.get());
                jsonResult.setMessage("\u53d6\u6d88\u4f1a\u8bdd\u7f6e\u9876\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)tid);
            } else {
                jsonResult.setMessage("\u53d6\u6d88\u4f1a\u8bdd\u7f6e\u9876\u5931\u8d25-tid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)"failed");
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/mark/nodisturb"})
    @ResponseBody
    public JsonResult markNoDisturb(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (threadOptional.isPresent()) {
                ((Thread)threadOptional.get()).getNoDisturbSet().add(userOptional.get());
                this.threadRepository.save(threadOptional.get());
                jsonResult.setMessage("\u8bbe\u7f6e\u4f1a\u8bdd\u514d\u6253\u6270\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)tid);
            } else {
                jsonResult.setMessage("\u8bbe\u7f6e\u4f1a\u8bdd\u514d\u6253\u6270\u5931\u8d25-tid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)"failed");
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/unmark/nodisturb"})
    @ResponseBody
    public JsonResult unmarkNoDisturb(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (threadOptional.isPresent()) {
                ((Thread)threadOptional.get()).getNoDisturbSet().remove(userOptional.get());
                this.threadRepository.save(threadOptional.get());
                jsonResult.setMessage("\u53d6\u6d88\u4f1a\u8bdd\u514d\u6253\u6270\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)tid);
            } else {
                jsonResult.setMessage("\u53d6\u6d88\u4f1a\u8bdd\u514d\u6253\u6270\u5931\u8d25-tid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)"failed");
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/mark/unread"})
    @ResponseBody
    public JsonResult markUnread(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (threadOptional.isPresent()) {
                ((Thread)threadOptional.get()).getUnreadSet().add(userOptional.get());
                this.threadRepository.save(threadOptional.get());
                jsonResult.setMessage("\u6807\u8bb0\u4f1a\u8bdd\u672a\u8bfb\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)tid);
            } else {
                jsonResult.setMessage("\u6807\u8bb0\u4f1a\u8bdd\u672a\u8bfb\u5931\u8d25-tid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)"failed");
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/unmark/unread"})
    @ResponseBody
    public JsonResult unmarkUnread(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (threadOptional.isPresent()) {
                ((Thread)threadOptional.get()).getUnreadSet().remove(userOptional.get());
                this.threadRepository.save(threadOptional.get());
                jsonResult.setMessage("\u53d6\u6d88\u6807\u8bb0\u4f1a\u8bdd\u672a\u8bfb\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)tid);
            } else {
                jsonResult.setMessage("\u53d6\u6d88\u6807\u8bb0\u4f1a\u8bdd\u672a\u8bfb\u5931\u8d25-tid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)"failed");
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/mark/deleted"})
    @ResponseBody
    public JsonResult markDeleted(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (threadOptional.isPresent()) {
                ((Thread)threadOptional.get()).getDeletedSet().add(userOptional.get());
                this.threadRepository.save(threadOptional.get());
                jsonResult.setMessage("\u6807\u8bb0\u4f1a\u8bdd\u5220\u9664\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)tid);
            } else {
                jsonResult.setMessage("\u6807\u8bb0\u4f1a\u8bdd\u5220\u9664\u5931\u8d25-tid\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)"failed");
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/get"})
    public JsonResult get(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(10, -24);
                PageRequest pageable = PageRequest.of((int)0, (int)100, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"timestamp"});
                Page threadPage = this.threadRepository.findByTimestampAfterAndAgentsContains(calendar.getTime(), (User)userOptional.get(), (Pageable)pageable);
                LinkedList agentThreadList = new LinkedList(threadPage.getContent());
                HashSet<String> visitorUidSet = new HashSet<String>(16);
                Iterator iterator = agentThreadList.iterator();
                while (iterator.hasNext()) {
                    Thread thread = (Thread)iterator.next();
                    if (visitorUidSet.contains(thread.getVisitor().getUid())) {
                        iterator.remove();
                        continue;
                    }
                    visitorUidSet.add(thread.getVisitor().getUid());
                }
                List contactThreadList = this.threadRepository.findByAgentAndTypeAndDeletedSetNotContains((User)userOptional.get(), "contact", (User)userOptional.get());
                List groupThreadList = this.threadRepository.findByGroup_MembersContainsAndGroup_DismissedAndTypeAndDeletedSetNotContains((User)userOptional.get(), false, "group", (User)userOptional.get());
                HashMap<String, List> objectMap = new HashMap<String, List>(3);
                objectMap.put("agentThreads", agentThreadList);
                objectMap.put("contactThreads", contactThreadList);
                objectMap.put("groupThreads", groupThreadList);
                jsonResult.setMessage("\u83b7\u53d6\u5f53\u524d\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData(objectMap);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/contact"})
    public JsonResult contact(Principal principal, @RequestParam(value="cid") String contactCid, @RequestParam(value="client") String client) {
        this.logger.info("cid {}, client {}", (Object)contactCid, (Object)client);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            Optional contactOptional = this.userRepository.findByUid(contactCid);
            if (contactOptional.isPresent()) {
                Thread thread = this.threadService.getContactThread((User)userOptional.get(), (User)contactOptional.get());
                jsonResult.setMessage("\u83b7\u53d6\u8054\u7cfb\u4eba\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)thread);
            } else {
                jsonResult.setMessage("");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/group"})
    public JsonResult group(Principal principal, @RequestParam(value="gid") String groupGid, @RequestParam(value="client") String client) {
        this.logger.info("gid {}, client {}", (Object)groupGid, (Object)client);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Thread thread = this.threadService.getGroupThread(groupGid);
            if (thread != null) {
                jsonResult.setMessage("\u83b7\u53d6\u7fa4\u7ec4\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)thread);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u7fa4\u7ec4\u4f1a\u8bdd\u5931\u8d25");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/history"})
    public JsonResult history(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                Page threadPage;
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                if (((User)adminOptional.get()).isAdmin()) {
                    Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
                        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
                        predicateList.add(criteriaBuilder.equal((Expression)root.get("visitor").get("subDomain"), (Object)((User)adminOptional.get()).getSubDomain()));
                        predicateList.add(criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get("type"), (Object)"thread"), (Expression)criteriaBuilder.equal((Expression)root.get("type"), (Object)"appointed")));
                        predicateList.add(criteriaBuilder.equal((Expression)root.get("closed"), (Object)true));
                        predicateList.add(criteriaBuilder.isNotNull((Expression)root.get("agent")));
                        return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
                    };
                    threadPage = this.threadRepository.findAll((Specification)specification, (Pageable)pageable);
                } else {
                    threadPage = ((User)adminOptional.get()).isWorkGroupAdmin() ? this.threadRepository.findByWorkGroup_UsersContainsAndClosedAndWorkGroup_AdminAndAgentNotNull((User)adminOptional.get(), true, (User)adminOptional.get(), (Pageable)pageable) : this.threadRepository.findByAgentsContainsAndClosed((User)adminOptional.get(), true, (Pageable)pageable);
                }
                jsonResult.setMessage("\u83b7\u53d6\u5386\u53f2\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)threadPage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/monitor"})
    public JsonResult monitor(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page threadPage = this.threadRepository.findByAgentsContainsAndClosed((User)adminOptional.get(), false, (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u76d1\u63a7\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)threadPage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/quality"})
    public JsonResult quality(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page threadPage = this.threadRepository.findByAgentsContainsAndClosed((User)adminOptional.get(), true, (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u8d28\u91cf\u68c0\u67e5\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)threadPage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/agent/close"})
    @ResponseBody
    public JsonResult agentClose(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            if (threadOptional.isPresent() && !((Thread)threadOptional.get()).isClosed()) {
                this.threadService.agentCloseThread((Thread)threadOptional.get());
                Set userSet = ((Thread)threadOptional.get()).getAgents();
                for (User user : userSet) {
                    this.redisService.increaseAgentIdleCount(user.getUid());
                    if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                        this.redisThreadService.decreaseWorkGroupAgentThreadCount(((Thread)threadOptional.get()).getWorkGroup().getWid(), user.getUid());
                        continue;
                    }
                    this.redisThreadService.decreaseAgentThreadCount(user.getUid());
                }
                Message message = new Message();
                message.setMid(JpaUtil.randomId());
                if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                    message.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                } else {
                    message.setWid("appointed");
                }
                message.setType("notification_agent_close");
                message.setContent("\u5ba2\u670d\u5173\u95ed\u4f1a\u8bdd");
                message.setThread((Thread)threadOptional.get());
                message.setUser(this.userService.getNotificationUser());
                this.messageRepository.save((Object)message);
                this.messagingTemplate.convertAndSend("message.thread.#", (Object)message);
                this.redisStatisticService.removeCurrentThread(((Thread)threadOptional.get()).getVisitor().getSubDomain(), ((Thread)threadOptional.get()).getTid());
                jsonResult.setMessage("\u5173\u95ed\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)true);
            } else if (((Thread)threadOptional.get()).isClosed()) {
                jsonResult.setMessage("\u5ba2\u670d\u5173\u95ed\u4f1a\u8bdd\u5931\u8d25-\u4f1a\u8bdd\u5df2\u7ecf\u5173\u95ed,\u65e0\u9700\u91cd\u590d\u5173\u95ed");
                jsonResult.setStatus_code(-3);
                jsonResult.setData((Object)false);
            } else {
                jsonResult.setMessage("\u5ba2\u670d\u5173\u95ed\u4f1a\u8bdd\u5931\u8d25-\u672a\u627e\u5230\u4f1a\u8bdd");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/visitor/close"})
    @ResponseBody
    public JsonResult visitorClose(Principal principal, @RequestBody Map map) {
        String tid = (String)map.get("tid");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional threadOptional = this.threadRepository.findByTid(tid);
            if (threadOptional.isPresent() && !((Thread)threadOptional.get()).isClosed()) {
                this.threadService.visitorCloseThread((Thread)threadOptional.get());
                Set userSet = ((Thread)threadOptional.get()).getAgents();
                for (User user : userSet) {
                    this.redisService.increaseAgentIdleCount(user.getUid());
                    if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                        this.redisThreadService.decreaseWorkGroupAgentThreadCount(((Thread)threadOptional.get()).getWorkGroup().getWid(), user.getUid());
                        continue;
                    }
                    this.redisThreadService.decreaseAgentThreadCount(user.getUid());
                }
                Message message = new Message();
                message.setMid(JpaUtil.randomId());
                if (((Thread)threadOptional.get()).getWorkGroup() != null) {
                    message.setWid(((Thread)threadOptional.get()).getWorkGroup().getWid());
                } else {
                    message.setWid("appointed");
                }
                message.setType("notification_visitor_close");
                message.setContent("\u8bbf\u5ba2\u5173\u95ed\u4f1a\u8bdd");
                message.setThread((Thread)threadOptional.get());
                message.setUser(this.userService.getNotificationUser());
                this.messageRepository.save((Object)message);
                this.messagingTemplate.convertAndSend("message.thread.#", (Object)message);
                this.redisStatisticService.removeCurrentThread(((Thread)threadOptional.get()).getVisitor().getSubDomain(), ((Thread)threadOptional.get()).getTid());
                jsonResult.setMessage("\u8bbf\u5ba2\u5173\u95ed\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)true);
            } else if (((Thread)threadOptional.get()).isClosed()) {
                jsonResult.setMessage("\u8bbf\u5ba2\u5173\u95ed\u4f1a\u8bdd\u5931\u8d25-\u4f1a\u8bdd\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u80fd\u91cd\u590d\u5173\u95ed");
                jsonResult.setStatus_code(-3);
                jsonResult.setData((Object)false);
            } else {
                jsonResult.setMessage("\u8bbf\u5ba2\u5173\u95ed\u4f1a\u8bdd\u5931\u8d25-\u672a\u627e\u5230\u4f1a\u8bdd");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="nickname") String nickname, @RequestParam(value="createdAtStart") String createdAtStart, @RequestParam(value="createdAtEnd") String createdAtEnd, @RequestParam(value="workGroupNickname") String workGroupNickname, @RequestParam(value="agentRealName") String agentRealName, @RequestParam(value="client") String client) {
        this.logger.info("page {}, size {}, nickname {}, createdAtStart {}, createdAtEnd {}, wgNickname {}, agentRealName {}, client {}", new Object[]{page, size, nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client});
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            if (adminOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Specification specification = this.getSpecification((User)adminOptional.get(), "thread", nickname, createdAtStart, createdAtEnd, workGroupNickname, agentRealName, client);
                Page threadPage = this.threadRepository.findAll(specification, (Pageable)pageable);
                jsonResult.setMessage("\u641c\u7d22\u5386\u53f2\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)threadPage);
            } else {
                jsonResult.setMessage("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/visitor/history"})
    public JsonResult visitorHistory(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                PageRequest pageable = PageRequest.of((int)page, (int)20, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                Page threadPage = this.threadRepository.findByVisitor((User)visitorOptional.get(), (Pageable)pageable);
                jsonResult.setMessage("\u83b7\u53d6\u8bbf\u5ba2\u6240\u6709\u5386\u53f2\u4f1a\u8bdd\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)threadPage);
            } else {
                jsonResult.setMessage("\u83b7\u53d6\u8bbf\u5ba2\u6240\u6709\u5386\u53f2\u4f1a\u8bdd-\u8bbf\u5ba2\u8d26\u53f7\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

