/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v1;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.xiaper.jpa.model.Company;
import io.xiaper.jpa.model.Questionnaire;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.model.WorkTime;
import io.xiaper.jpa.repository.AppRepository;
import io.xiaper.jpa.repository.CompanyRepository;
import io.xiaper.jpa.repository.QuestionnaireRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WorkGroupRepository;
import io.xiaper.jpa.repository.WorkTimeRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import java.io.Serializable;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/workgroup"})
public class WorkGroupController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UserRepository userRepository;
    @Autowired
    WorkGroupRepository workGroupRepository;
    @Autowired
    WorkTimeRepository workTimeRepository;
    @Autowired
    AppRepository appRepository;
    @Autowired
    CompanyRepository companyRepository;
    @Autowired
    QuestionnaireRepository questionnaireRepository;

    @GetMapping(value={"/get"})
    public JsonResult get(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="client") String client) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                Page workGroupPage;
                PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
                if (((User)userOptional.get()).isAdmin()) {
                    workGroupPage = this.workGroupRepository.findByUser((User)userOptional.get(), (Pageable)pageable);
                } else {
                    User admin = ((User)userOptional.get()).getAdmin();
                    workGroupPage = this.workGroupRepository.findByUser(admin, (Pageable)pageable);
                }
                jsonResult.setMessage("\u83b7\u53d6\u5de5\u4f5c\u7ec4\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)workGroupPage);
            } else {
                jsonResult.setMessage("\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public JsonResult create(Principal principal, @RequestBody Map map) {
        String nickname = (String)map.get("nickname");
        String avatar = (String)map.get("avatar");
        boolean defaultRobot = (Boolean)map.get("defaultRobot");
        boolean offlineRobot = (Boolean)map.get("offlineRobot");
        boolean forceRate = (Boolean)map.get("forceRate");
        String routeType = (String)map.get("routeType");
        String welcomeTip = (String)map.get("welcomeTip");
        String acceptTip = (String)map.get("acceptTip");
        String offlineTip = (String)map.get("offlineTip");
        String workTimes = (String)map.get("workTimes");
        List users = (List)map.get("users");
        String onDutyWorkGroupWid = (String)map.get("onDutyWorkGroupWid");
        String adminUid = (String)map.get("admin");
        String companyCid = (String)map.get("companyCid");
        String questionnaireQid = (String)map.get("questionnaireQid");
        this.logger.info("nickname {}, routeType {}, welcomeTip {}, acceptTip {}, offlineTip {}, workTimes {}, users {}, onDutyWorkGroupWid {}, admin {}", new Object[]{nickname, routeType, welcomeTip, acceptTip, offlineTip, workTimes, users, onDutyWorkGroupWid, adminUid});
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            Optional questionnaireOptional;
            Optional companyOptional;
            Optional appOptional = this.appRepository.findFirstByUser((User)adminOptional.get());
            WorkGroup workGroup = new WorkGroup();
            workGroup.setWid(JpaUtil.randomId());
            workGroup.setNickname(nickname);
            workGroup.setAvatar(avatar);
            workGroup.setDefaultRobot(defaultRobot);
            workGroup.setOfflineRobot(offlineRobot);
            workGroup.setForceRate(forceRate);
            workGroup.setRouteType(routeType);
            workGroup.setDepartment(false);
            workGroup.setWelcomeTip(welcomeTip);
            workGroup.setAcceptTip(acceptTip);
            workGroup.setOfflineTip(offlineTip);
            workGroup.setNonWorkingTimeTip("\u5f53\u524d\u975e\u5de5\u4f5c\u65f6\u95f4\uff0c\u8bf7\u81ea\u52a9\u67e5\u8be2\u6216\u7559\u8a00");
            workGroup.setUser((User)adminOptional.get());
            workGroup.getApps().add(appOptional.get());
            if (onDutyWorkGroupWid != null && onDutyWorkGroupWid.trim().length() > 0) {
                Optional onDutyWorkGroupOptional = this.workGroupRepository.findByWid(onDutyWorkGroupWid);
                if (onDutyWorkGroupOptional.isPresent()) {
                    workGroup.setOnDutyWorkGroup((WorkGroup)onDutyWorkGroupOptional.get());
                }
            } else {
                workGroup.setOnDutyWorkGroup(null);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
            JSONArray jsonArray = JSONArray.parseArray((String)workTimes);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String startTime = (String)jsonObject.get((Object)"startTime");
                String endTime = (String)jsonObject.get((Object)"endTime");
                WorkTime workTime = new WorkTime();
                try {
                    workTime.setStartTime(dateFormat.parse(startTime));
                    workTime.setEndTime(dateFormat.parse(endTime));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                workGroup.getWorkTimes().add(workTime);
            }
            Optional workGroupAdminOptional = this.userRepository.findByUid(adminUid);
            if (workGroupAdminOptional.isPresent()) {
                workGroup.setAdmin((User)workGroupAdminOptional.get());
            }
            if ((companyOptional = this.companyRepository.findByCid(companyCid)).isPresent()) {
                workGroup.setCompany((Company)companyOptional.get());
            }
            if ((questionnaireOptional = this.questionnaireRepository.findByQid(questionnaireQid)).isPresent()) {
                workGroup.setQuestionnaire((Questionnaire)questionnaireOptional.get());
            }
            for (String uid : users) {
                Optional userOptional = this.userRepository.findByUid(uid);
                if (!userOptional.isPresent()) continue;
                workGroup.getUsers().add(userOptional.get());
            }
            this.workGroupRepository.save((Object)workGroup);
            jsonResult.setMessage("\u5de5\u4f5c\u7ec4\u521b\u5efa\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)workGroup);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public JsonResult update(Principal principal, @RequestBody Map map) {
        Integer id = (Integer)map.get("id");
        String nickname = (String)map.get("nickname");
        String avatar = (String)map.get("avatar");
        boolean defaultRobot = (Boolean)map.get("defaultRobot");
        boolean offlineRobot = (Boolean)map.get("offlineRobot");
        boolean forceRate = (Boolean)map.get("forceRate");
        String routeType = (String)map.get("routeType");
        String welcomeTip = (String)map.get("welcomeTip");
        String acceptTip = (String)map.get("acceptTip");
        String offlineTip = (String)map.get("offlineTip");
        String workTimes = (String)map.get("workTimes");
        List users = (List)map.get("users");
        String onDutyWorkGroupWid = (String)map.get("onDutyWorkGroupWid");
        String adminUid = (String)map.get("admin");
        String companyCid = (String)map.get("companyCid");
        String questionnaireQid = (String)map.get("questionnaireQid");
        this.logger.info("nickname {}, routeType {}, welcomeTip {}, acceptTip {}, offlineTip {}, workTimes {}, users {}, onDutyWorkGroupWid {}, admin {}", new Object[]{nickname, routeType, welcomeTip, acceptTip, offlineTip, workTimes, users, onDutyWorkGroupWid, adminUid});
        JsonResult jsonResult = new JsonResult();
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            Optional workGroupOptional = this.workGroupRepository.findById((Object)id);
            if (workGroupOptional.isPresent()) {
                Optional companyOptional;
                WorkGroup workGroup = (WorkGroup)workGroupOptional.get();
                workGroup.setNickname(nickname);
                workGroup.setAvatar(avatar);
                workGroup.setDefaultRobot(defaultRobot);
                workGroup.setOfflineRobot(offlineRobot);
                workGroup.setForceRate(forceRate);
                workGroup.setRouteType(routeType);
                workGroup.setDepartment(false);
                workGroup.setWelcomeTip(welcomeTip);
                workGroup.setAcceptTip(acceptTip);
                workGroup.setOfflineTip(offlineTip);
                if (onDutyWorkGroupWid != null && onDutyWorkGroupWid.trim().length() > 0) {
                    Optional onDutyWorkGroupOptional = this.workGroupRepository.findByWid(onDutyWorkGroupWid);
                    if (onDutyWorkGroupOptional.isPresent()) {
                        workGroup.setOnDutyWorkGroup((WorkGroup)onDutyWorkGroupOptional.get());
                    }
                } else {
                    workGroup.setOnDutyWorkGroup(null);
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
                JSONArray jsonArray = JSONArray.parseArray((String)workTimes);
                HashSet<WorkTime> workTimeSet = new HashSet<WorkTime>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String startTime = (String)jsonObject.get((Object)"startTime");
                    String endTime = (String)jsonObject.get((Object)"endTime");
                    WorkTime workTime = new WorkTime();
                    try {
                        workTime.setStartTime(dateFormat.parse(startTime));
                        workTime.setEndTime(dateFormat.parse(endTime));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    workTimeSet.add(workTime);
                }
                workGroup.setWorkTimes(workTimeSet);
                Optional workGroupAdminOptional = this.userRepository.findByUid(adminUid);
                if (workGroupAdminOptional.isPresent()) {
                    workGroup.setAdmin((User)workGroupAdminOptional.get());
                }
                if ((companyOptional = this.companyRepository.findByCid(companyCid)).isPresent()) {
                    workGroup.setCompany((Company)companyOptional.get());
                } else {
                    workGroup.setCompany(null);
                }
                Optional questionnaireOptional = this.questionnaireRepository.findByQid(questionnaireQid);
                if (questionnaireOptional.isPresent()) {
                    workGroup.setQuestionnaire((Questionnaire)questionnaireOptional.get());
                } else {
                    workGroup.setQuestionnaire(null);
                }
                workGroup.getUsers().clear();
                for (String uid : users) {
                    Optional userOptional = this.userRepository.findByUid(uid);
                    if (!userOptional.isPresent()) continue;
                    ((User)userOptional.get()).getWorkGroups().add(workGroup);
                    this.userRepository.save(userOptional.get());
                    workGroup.getUsers().add(userOptional.get());
                }
                this.workGroupRepository.save((Object)workGroup);
                jsonResult.setMessage("\u5de5\u4f5c\u7ec4\u66f4\u65b0\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)workGroup);
            } else {
                jsonResult.setMessage("\u5de5\u4f5c\u7ec4\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)id);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public JsonResult delete(Principal principal, @RequestBody Map map) {
        Integer id = (Integer)map.get("id");
        JsonResult jsonResult = new JsonResult();
        this.logger.info("delete workgroup id {}", (Object)id);
        Optional adminOptional = this.userRepository.findByUsername(principal.getName());
        if (adminOptional.isPresent()) {
            Optional workGroup = this.workGroupRepository.findById((Object)id);
            if (workGroup.isPresent()) {
                this.workGroupRepository.deleteById((Object)id);
                jsonResult.setMessage("\u5220\u9664\u5de5\u4f5c\u7ec4\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)id);
            } else {
                jsonResult.setMessage("\u5220\u9664\u5de5\u4f5c\u7ec4\u5931\u8d25-id\u4e0d\u5b58\u5728 ");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }

    @GetMapping(value={"/all"})
    public JsonResult all(Principal principal) {
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional userOptional = this.userRepository.findByUsername(principal.getName());
            if (userOptional.isPresent()) {
                List workGroups = ((User)userOptional.get()).isAdmin() ? this.workGroupRepository.findByUser((User)userOptional.get()) : (((User)userOptional.get()).isWorkGroupAdmin() ? this.workGroupRepository.findByUsersContains((User)userOptional.get()) : this.workGroupRepository.findByUsersContains((User)userOptional.get()));
                jsonResult.setMessage("\u83b7\u53d6\u6240\u6709\u5de5\u4f5c\u7ec4\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)workGroups);
            } else {
                jsonResult.setMessage("\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-2);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)"failed");
        }
        return jsonResult;
    }

    @GetMapping(value={"/filter"})
    public JsonResult filter(Principal principal, @RequestParam(value="page") int page, @RequestParam(value="size") int size, @RequestParam(value="nickname") String nickname, @RequestParam(value="client") String client) {
        this.logger.info(" nickname {}, client {}", (Object)nickname, (Object)client);
        JsonResult jsonResult = new JsonResult();
        if (principal != null) {
            Optional adminOptional = this.userRepository.findByUsername(principal.getName());
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
            Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
                ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
                predicateList.add(criteriaBuilder.like((Expression)root.get("nickname"), "%" + nickname + "%"));
                predicateList.add(criteriaBuilder.equal((Expression)root.get("user").get("subDomain"), (Object)((User)adminOptional.get()).getSubDomain()));
                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            };
            Page workGroupPage = this.workGroupRepository.findAll((Specification)specification, (Pageable)pageable);
            jsonResult.setMessage("\u641c\u7d22\u5de5\u4f5c\u7ec4\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData((Object)workGroupPage);
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

