/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v2;

import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.model.Answer;
import io.xiaper.jpa.model.AnswerQuery;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Synonym;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.AnswerQueryRepository;
import io.xiaper.jpa.repository.AnswerRepository;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.SynonymRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WorkGroupRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.mq.service.ThreadService;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/answer"})
public class AnswerControllerV2
extends BaseController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    WorkGroupRepository workGroupRepository;
    @Autowired
    AnswerRepository answerRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    AnswerQueryRepository answerQueryRepository;
    @Autowired
    SynonymRepository synonymRepository;
    @Autowired
    ThreadService threadService;

    @GetMapping(value={"/init"})
    public JsonResult init(Principal principal, @RequestParam(value="wid") String workGroupWid, @RequestParam(value="type") String requestType, @RequestParam(value="aid") String agentUid, @RequestParam(value="client") String client) {
        User admin;
        Thread thread;
        this.logger.info("workGroupWid: {}, requestType {}, agentUid {}, client: {}", new Object[]{workGroupWid, requestType, agentUid, client});
        JsonResult jsonResult = new JsonResult();
        Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
        Message replyMessage = new Message();
        replyMessage.setMid(JpaUtil.randomId());
        if (requestType.equals("appointed")) {
            Optional agentOptional = this.userRepository.findByUid(agentUid);
            thread = this.threadService.getAppointThread((User)visitorOptional.get(), (User)agentOptional.get(), client);
            replyMessage.setWid("appointed");
            admin = ((User)agentOptional.get()).getAdmin();
        } else {
            Optional workGroupOptional = this.workGroupRepository.findByWid(workGroupWid);
            thread = this.threadService.getWorkGroupThread((User)visitorOptional.get(), (WorkGroup)workGroupOptional.get(), client);
            replyMessage.setWid(workGroupWid);
            admin = ((WorkGroup)workGroupOptional.get()).getUser();
        }
        replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
        replyMessage.setThread(thread);
        replyMessage.setType("robot");
        replyMessage.setContent(admin.getRoBotUser().getWelcomeTip());
        replyMessage.setUser(admin.getRoBotUser());
        Set answers = this.answerRepository.findTop5ByUserAndRelatedOrderByQueryCountDesc(admin, false);
        replyMessage.setAnswers(answers);
        this.messageRepository.save((Object)replyMessage);
        jsonResult.setMessage("\u521d\u59cb\u5316\u81ea\u52a9\u7b54\u7591\u6210\u529f");
        jsonResult.setStatus_code(200);
        jsonResult.setData((Object)replyMessage);
        return jsonResult;
    }

    @GetMapping(value={"/message"})
    public JsonResult message(Principal principal, @RequestParam(value="wid") String workGroupWid, @RequestParam(value="type") String requestType, @RequestParam(value="aid") String agentUid, @RequestParam(value="content") String content, @RequestParam(value="client") String client) {
        User admin;
        Thread thread;
        this.logger.info("workGroupWid: {}, requestType {}, agentUid {}, client: {}, content: {}", new Object[]{workGroupWid, requestType, agentUid, client, content});
        JsonResult jsonResult = new JsonResult();
        Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
        Message queryMessage = new Message();
        queryMessage.setMid(JpaUtil.randomId());
        Message replyMessage = new Message();
        replyMessage.setMid(JpaUtil.randomId());
        if (requestType.equals("appointed")) {
            Optional agentOptional = this.userRepository.findByUid(agentUid);
            thread = this.threadService.getAppointThread((User)visitorOptional.get(), (User)agentOptional.get(), client);
            queryMessage.setWid("appointed");
            replyMessage.setWid("appointed");
            admin = ((User)agentOptional.get()).getAdmin();
        } else {
            Optional workGroupOptional = this.workGroupRepository.findByWid(workGroupWid);
            thread = this.threadService.getWorkGroupThread((User)visitorOptional.get(), (WorkGroup)workGroupOptional.get(), client);
            queryMessage.setWid(workGroupWid);
            replyMessage.setWid(workGroupWid);
            admin = ((WorkGroup)workGroupOptional.get()).getUser();
        }
        queryMessage.setClient(client);
        queryMessage.setThread(thread);
        queryMessage.setType("robot");
        queryMessage.setContent(content);
        queryMessage.setUser((User)visitorOptional.get());
        this.messageRepository.save((Object)queryMessage);
        Optional answerOptional = this.answerRepository.findFirstByUserAndQuestionContainingOrAnswerContaining(admin, content, content);
        if (answerOptional.isPresent()) {
            this.logger.info("1. content {}, answer {}", (Object)content, (Object)((Answer)answerOptional.get()).getAnswer());
            AnswerQuery answerQuery = new AnswerQuery();
            answerQuery.setAnswer((Answer)answerOptional.get());
            answerQuery.setUser((User)visitorOptional.get());
            this.answerQueryRepository.save((Object)answerQuery);
            ((Answer)answerOptional.get()).updateQueryCount();
            this.answerRepository.save(answerOptional.get());
            replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
            replyMessage.setThread(thread);
            replyMessage.setType("robot");
            replyMessage.setContent(((Answer)answerOptional.get()).getAnswer());
            replyMessage.setAnswer((Answer)answerOptional.get());
            replyMessage.setUser(admin.getRoBotUser());
            this.messageRepository.save((Object)replyMessage);
            HashMap<String, Message> objectMap = new HashMap<String, Message>(2);
            objectMap.put("query", queryMessage);
            objectMap.put("reply", replyMessage);
            jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u6210\u529f");
            jsonResult.setStatus_code(200);
            jsonResult.setData(objectMap);
        } else {
            List synonymList = this.synonymRepository.findByUser(admin);
            for (Synonym synonym : synonymList) {
                if (synonym.getStandard().trim().length() <= 0 || !content.contains(synonym.getStandard())) continue;
                this.logger.info("2. content: {}, synonym: {}", (Object)content, (Object)synonym.getStandard());
                Optional optionalAnswer = this.answerRepository.findFirstByUserAndQuestionContainingOrAnswerContaining(admin, synonym.getStandard(), synonym.getStandard());
                if (!optionalAnswer.isPresent()) continue;
                AnswerQuery answerQuery = new AnswerQuery();
                answerQuery.setAnswer((Answer)optionalAnswer.get());
                answerQuery.setUser((User)visitorOptional.get());
                this.answerQueryRepository.save((Object)answerQuery);
                ((Answer)optionalAnswer.get()).updateQueryCount();
                this.answerRepository.save(optionalAnswer.get());
                replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
                replyMessage.setThread(thread);
                replyMessage.setType("robot");
                replyMessage.setContent(((Answer)optionalAnswer.get()).getAnswer());
                replyMessage.setAnswer((Answer)optionalAnswer.get());
                replyMessage.setUser(admin.getRoBotUser());
                this.messageRepository.save((Object)replyMessage);
                HashMap<String, Message> objectMap = new HashMap<String, Message>(2);
                objectMap.put("query", queryMessage);
                objectMap.put("reply", replyMessage);
                jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData(objectMap);
                return jsonResult;
            }
            replyMessage.setClient(ClientConsts.CLIENT_SYSTEM);
            replyMessage.setThread(thread);
            replyMessage.setType("robot");
            replyMessage.setContent("\u62b1\u6b49\uff0c\u672a\u627e\u5230\u76f8\u5e94\u7b54\u6848");
            replyMessage.setUser(admin.getRoBotUser());
            this.messageRepository.save((Object)replyMessage);
            HashMap<String, Message> objectMap = new HashMap<String, Message>(2);
            objectMap.put("query", queryMessage);
            objectMap.put("reply", replyMessage);
            jsonResult.setMessage("\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u5931\u8d25-\u672a\u627e\u5230\u76f8\u5e94\u7b54\u6848");
            jsonResult.setStatus_code(201);
            jsonResult.setData(objectMap);
        }
        return jsonResult;
    }
}

