/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restkefu.controller.v2;

import io.xiaper.jpa.model.LeaveMessage;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.LeaveMessageRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WorkGroupRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.rest.controller.v1.BaseController;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/leavemsg"})
public class LeaveMessageControllerV2
extends BaseController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    WorkGroupRepository workGroupRepository;
    @Autowired
    LeaveMessageRepository leaveMessageRepository;

    @PostMapping(value={"/save/dxz"})
    @ResponseBody
    public JsonResult saveDxz(Principal principal, @RequestBody Map map) {
        String wid = (String)map.get("wid");
        String aid = (String)map.get("aid");
        String type = (String)map.get("type");
        String mobile = (String)map.get("mobile");
        String email = (String)map.get("email");
        String nickname = (String)map.get("nickname");
        String location = (String)map.get("location");
        String country = (String)map.get("country");
        String content = (String)map.get("content");
        String client = (String)map.get("client");
        JsonResult jsonResult = new JsonResult();
        if (null == mobile || mobile.trim().length() == 0 || null == content || content.trim().length() == 0) {
            jsonResult.setMessage("\u7559\u8a00\u5931\u8d25-\u624b\u673a\u53f7\u548c\u7559\u8a00\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            jsonResult.setStatus_code(-4);
            jsonResult.setData((Object)false);
            return jsonResult;
        }
        if (principal != null) {
            Optional visitorOptional = this.userRepository.findByUsername(principal.getName());
            if (visitorOptional.isPresent()) {
                LeaveMessage leaveMessage = new LeaveMessage();
                leaveMessage.setLid(JpaUtil.randomId());
                leaveMessage.setMobile(mobile);
                leaveMessage.setEmail(email);
                leaveMessage.setContent(content);
                leaveMessage.setType(type);
                leaveMessage.setVisitor((User)visitorOptional.get());
                leaveMessage.setStatus("unclaimed");
                leaveMessage.setNickname(nickname);
                leaveMessage.setLocation(location);
                leaveMessage.setCountry(country);
                if (type.equals("appointed")) {
                    Optional agentOptional = this.userRepository.findByUid(aid);
                    if (agentOptional.isPresent()) {
                        leaveMessage.setAgent((User)agentOptional.get());
                        leaveMessage.setSubDomain(((User)agentOptional.get()).getAdmin().getSubDomain());
                    }
                } else {
                    Optional workGroupOptional = this.workGroupRepository.findByWid(wid);
                    if (workGroupOptional.isPresent()) {
                        leaveMessage.setWorkGroup((WorkGroup)workGroupOptional.get());
                        leaveMessage.setSubDomain(((WorkGroup)workGroupOptional.get()).getUser().getSubDomain());
                    }
                }
                this.leaveMessageRepository.save((Object)leaveMessage);
                jsonResult.setMessage("\u7559\u8a00\u6210\u529f");
                jsonResult.setStatus_code(200);
                jsonResult.setData((Object)leaveMessage);
            } else {
                jsonResult.setMessage("\u7559\u8a00\u5931\u8d25-\u8bbf\u5ba2\u7528\u6237\u4e0d\u5b58\u5728");
                jsonResult.setStatus_code(-3);
                jsonResult.setData((Object)false);
            }
        } else {
            jsonResult.setMessage("access token invalid");
            jsonResult.setStatus_code(-1);
            jsonResult.setData((Object)false);
        }
        return jsonResult;
    }
}

