/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restwechat.controller.v1;

import io.xiaper.jpa.model.FuncInfo;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WeChat;
import io.xiaper.jpa.repository.MiniProgramInfoRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WeChatRepository;
import io.xiaper.jpa.repository.WeChatUserInfoRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.mq.service.wechat.WeChatOpenService;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.builder.kefu.TextBuilder;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.bean.auth.WxOpenAuthorizationInfo;
import me.chanjar.weixin.open.bean.auth.WxOpenAuthorizerInfo;
import me.chanjar.weixin.open.bean.message.WxOpenXmlMessage;
import me.chanjar.weixin.open.bean.result.WxOpenAuthorizerInfoResult;
import me.chanjar.weixin.open.bean.result.WxOpenQueryAuthResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat"})
public class WeChatController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    WeChatOpenService weChatOpenService;
    @Autowired
    WeChatRepository weChatRepository;
    @Autowired
    MiniProgramInfoRepository weChatMiniRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    WeChatUserInfoRepository weChatUserInfoRepository;

    @GetMapping(value={"/mp/oauth/redirect"})
    public void gotoPreAuthUrl(HttpServletResponse response) {
        try {
            String url = this.weChatOpenService.getWxOpenComponentService().getPreAuthUrl("https://wechat.bytedesk.com/wechat/mp/oauth/callback");
            response.sendRedirect(url);
        }
        catch (IOException | WxErrorException e) {
            this.logger.error("gotoPreAuthUrl", e);
            throw new RuntimeException(e);
        }
    }

    @GetMapping(value={"/mp/oauth/callback"})
    @ResponseBody
    public void oauthCallback(@RequestParam(value="auth_code") String authorizationCode, HttpSession session, HttpServletResponse response) {
        String uid = (String)session.getAttribute("uid");
        this.logger.info("\u5904\u7406\u6388\u6743\u4e8b\u4ef6Get session uid {}", (Object)uid);
        Optional userOptional = this.userRepository.findByUid(uid);
        try {
            WxOpenQueryAuthResult queryAuthResult = this.weChatOpenService.getWxOpenComponentService().getQueryAuth(authorizationCode);
            WxOpenAuthorizationInfo authorizationInfo = queryAuthResult.getAuthorizationInfo();
            String authorizerAppId = authorizationInfo.getAuthorizerAppid();
            WxOpenAuthorizerInfoResult authorizerInfoResult = this.weChatOpenService.getWxOpenComponentService().getAuthorizerInfo(authorizerAppId);
            WxOpenAuthorizerInfo authorizerInfo = authorizerInfoResult.getAuthorizerInfo();
            Optional weChatMpOptional = this.weChatRepository.findByAuthorizerAppId(authorizerAppId);
            WeChat weChat = weChatMpOptional.isPresent() ? (WeChat)weChatMpOptional.get() : new WeChat();
            weChat.setWid(JpaUtil.randomId());
            weChat.setNickname(authorizerInfo.getNickName());
            weChat.setHeadImg(authorizerInfo.getHeadImg());
            weChat.setServiceTypeInfo(authorizerInfo.getServiceTypeInfo());
            weChat.setVerifyTypeInfo(authorizerInfo.getVerifyTypeInfo());
            weChat.setUserName(authorizerInfo.getUserName());
            weChat.setPrincipalName(authorizerInfo.getPrincipalName());
            weChat.setAlias(authorizerInfo.getAlias());
            weChat.setQrcodeUrl(authorizerInfo.getQrcodeUrl());
            weChat.setSignature(authorizerInfo.getSignature());
            weChat.setBusinessInfoOpenPay((Integer)authorizerInfo.getBusinessInfo().get("open_pay"));
            weChat.setBusinessInfoOpenShake((Integer)authorizerInfo.getBusinessInfo().get("open_shake"));
            weChat.setBusinessInfoOpenScan((Integer)authorizerInfo.getBusinessInfo().get("open_scan"));
            weChat.setBusinessInfoOpenCard((Integer)authorizerInfo.getBusinessInfo().get("open_card"));
            weChat.setBusinessInfoOpenStore((Integer)authorizerInfo.getBusinessInfo().get("open_store"));
            weChat.setAuthorizationCode(authorizationCode);
            weChat.setAuthorizerAppId(authorizationInfo.getAuthorizerAppid());
            weChat.setAuthorizerAccessToken(authorizationInfo.getAuthorizerAccessToken());
            weChat.setAuthorizerRefreshToken(authorizationInfo.getAuthorizerRefreshToken());
            weChat.setExpiresIn(authorizationInfo.getExpiresIn());
            for (Integer funcScopeCategoryId : authorizationInfo.getFuncInfo()) {
                FuncInfo funcinfo = new FuncInfo();
                funcinfo.setFuncScopeCategoryId(funcScopeCategoryId.intValue());
                weChat.getFuncInfos().add(funcinfo);
            }
            if (authorizerInfoResult.isMiniProgram()) {
                weChat.setMiniProgram(false);
            } else {
                weChat.setMiniProgram(true);
            }
            weChat.setWorkGroup(((User)userOptional.get()).defaultWorkGroup());
            weChat.setUser((User)userOptional.get());
            this.weChatRepository.save((Object)weChat);
        }
        catch (WxErrorException e) {
            this.logger.error("gotoPreAuthUrl", (Throwable)e);
            throw new RuntimeException(e);
        }
        String url = "https://" + ((User)userOptional.get()).getSubDomain() + ".bytedesk.com/admin#/admin/setting/app";
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/mp/oauth/callback"})
    public Object oauthCallback(@RequestBody(required=false) String requestBody, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="signature") String signature, @RequestParam(name="encrypt_type", required=false) String encType, @RequestParam(name="msg_signature", required=false) String msgSignature, HttpSession session) {
        this.logger.info("\u6388\u6743\u4e8b\u4ef6\u63a5\u6536URL\uff1a[signature=[{}], encType=[{}], msgSignature=[{}], timestamp=[{}], nonce=[{}], requestBody=[{}] session uid {}", new Object[]{signature, encType, msgSignature, timestamp, nonce, requestBody, session.getAttribute("uid")});
        return "success";
    }

    @RequestMapping(value={"/mp/msgevent/{appId}/callback"})
    public Object msgEventCallback(@RequestBody(required=false) String requestBody, @PathVariable(value="appId") String appId, @RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="openid") String openid, @RequestParam(value="encrypt_type") String encType, @RequestParam(value="msg_signature") String msgSignature) {
        this.logger.info("\u6d88\u606f\u4e0e\u4e8b\u4ef6\u63a5\u6536URL\uff1a[appId=[{}], openid=[{}], signature=[{}], encType=[{}], msgSignature=[{}], timestamp=[{}], nonce=[{}], requestBody=[\n{}\n] ", new Object[]{appId, openid, signature, encType, msgSignature, timestamp, nonce, requestBody});
        if (!StringUtils.equalsIgnoreCase((CharSequence)"aes", (CharSequence)encType) || !this.weChatOpenService.getWxOpenComponentService().checkSignature(timestamp, nonce, signature)) {
            throw new IllegalArgumentException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u53ef\u80fd\u5c5e\u4e8e\u4f2a\u9020\u7684\u8bf7\u6c42\uff01");
        }
        WxMpXmlMessage inMessage = WxOpenXmlMessage.fromEncryptedMpXml((String)requestBody, (WxOpenConfigStorage)this.weChatOpenService.getWxOpenConfigStorage(), (String)timestamp, (String)nonce, (String)msgSignature);
        Optional weChatOptional = this.weChatRepository.findByUserName(inMessage.getToUser());
        if (!weChatOptional.isPresent()) {
            return "";
        }
        if (inMessage.getMsgType().equals("event") && inMessage.getEventKey().equals("unsubscribe")) {
            return "";
        }
        return "success";
    }

    public Object fullNetPublish(WxMpXmlMessage inMessage, String requestBody, String appId, String signature, String timestamp, String nonce, String openid, String encType, String msgSignature) {
        String out = "";
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)appId, (CharSequence[])new CharSequence[]{"wxd101a85aa106f53e", "wx570bc396a51b8ff8"})) {
            try {
                if (StringUtils.equals((CharSequence)inMessage.getMsgType(), (CharSequence)"text")) {
                    if (StringUtils.equals((CharSequence)inMessage.getContent(), (CharSequence)"TESTCOMPONENT_MSG_TYPE_TEXT")) {
                        out = WxOpenXmlMessage.wxMpOutXmlMessageToEncryptedXml((WxMpXmlOutMessage)((me.chanjar.weixin.mp.builder.outxml.TextBuilder)((me.chanjar.weixin.mp.builder.outxml.TextBuilder)WxMpXmlOutMessage.TEXT().content("TESTCOMPONENT_MSG_TYPE_TEXT_callback").fromUser(inMessage.getToUser())).toUser(inMessage.getFromUser())).build(), (WxOpenConfigStorage)this.weChatOpenService.getWxOpenConfigStorage());
                    } else if (StringUtils.startsWith((CharSequence)inMessage.getContent(), (CharSequence)"QUERY_AUTH_CODE:")) {
                        String msg = inMessage.getContent().replace("QUERY_AUTH_CODE:", "") + "_from_api";
                        WxMpKefuMessage kefuMessage = ((TextBuilder)WxMpKefuMessage.TEXT().content(msg).toUser(inMessage.getFromUser())).build();
                        this.weChatOpenService.getWxOpenComponentService().getWxMpServiceByAppid(appId).getKefuService().sendKefuMessage(kefuMessage);
                    }
                } else if (StringUtils.equals((CharSequence)inMessage.getMsgType(), (CharSequence)"event")) {
                    WxMpKefuMessage kefuMessage = ((TextBuilder)WxMpKefuMessage.TEXT().content(inMessage.getEvent() + "from_callback").toUser(inMessage.getFromUser())).build();
                    this.weChatOpenService.getWxOpenComponentService().getWxMpServiceByAppid(appId).getKefuService().sendKefuMessage(kefuMessage);
                }
            }
            catch (WxErrorException e) {
                this.logger.error("callback", (Throwable)e);
            }
        } else {
            WxMpXmlOutMessage outMessage = this.weChatOpenService.getWxOpenMessageRouter().route(inMessage, appId);
            if (outMessage != null) {
                out = WxOpenXmlMessage.wxMpOutXmlMessageToEncryptedXml((WxMpXmlOutMessage)outMessage, (WxOpenConfigStorage)this.weChatOpenService.getWxOpenConfigStorage());
            }
        }
        return out;
    }

    @PostMapping(value={"/mp/push"})
    @ResponseBody
    public void mpPush(@RequestBody Map map) {
        this.logger.info("mp push");
    }

    @PostMapping(value={"/mini/push"})
    @ResponseBody
    public void miniPush(@RequestBody Map map) {
        this.logger.info("mini push");
    }
}

