/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restwechat.controller.v1;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaMessage;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import com.alibaba.fastjson.JSONObject;
import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WeChat;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WeChatRepository;
import io.xiaper.jpa.repository.WeChatUserInfoRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.UserService;
import io.xiaper.mq.service.impl.RouteServiceImpl;
import io.xiaper.mq.service.wechat.WeChatMiniService;
import io.xiaper.rest.controller.v1.BaseController;
import io.xiaper.rest.util.AliYunOss;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat/mini"})
public class WeChatMiniController
extends BaseController {
    @Autowired
    WeChatRepository weChatRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserService userService;
    @Autowired
    RouteServiceImpl routeService;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    MessageService messageService;
    @Autowired
    WeChatMiniService weChatMiniService;
    @Autowired
    WeChatUserInfoRepository weChatUserInfoRepository;
    @Autowired
    AliYunOss aliYunOss;

    @GetMapping(value={"/push/{token}"})
    public String authGet(@PathVariable String token, @RequestParam(name="signature", required=false) String signature, @RequestParam(name="timestamp", required=false) String timestamp, @RequestParam(name="nonce", required=false) String nonce, @RequestParam(name="echostr", required=false) String echostr) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signature, timestamp, nonce, echostr})) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6838\u5b9e!");
        }
        WxMaService maService = this.weChatMiniService.getMaService(token);
        if (maService == null) {
            throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u5bf9\u5e94token=[%d]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", token));
        }
        if (maService.checkSignature(timestamp, nonce, signature)) {
            return echostr;
        }
        return "\u975e\u6cd5\u8bf7\u6c42";
    }

    @PostMapping(value={"/push/{token}"})
    public String post(@PathVariable String token, @RequestBody String requestBody, @RequestParam(value="msg_signature") String msgSignature, @RequestParam(value="encrypt_type") String encryptType, @RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce) {
        Thread thread;
        User visitor;
        this.logger.info("\n\u63a5\u6536\u5c0f\u7a0b\u5e8f\u8bf7\u6c42\uff1a[msg_signature=[{}], encrypt_type=[{}], signature=[{}], timestamp=[{}], nonce=[{}], requestBody=[\n{}\n] ", new Object[]{msgSignature, encryptType, signature, timestamp, nonce, requestBody});
        WxMaService maService = this.weChatMiniService.getMaService(token);
        WxMaMessage inMessage = WxMaMessage.fromEncryptedXml((String)requestBody, (WxMaConfig)maService.getWxMaConfig(), (String)timestamp, (String)nonce, (String)msgSignature);
        this.logger.debug("\n\u6d88\u606f\u89e3\u5bc6\u540e\u5185\u5bb9\u4e3a\uff1a\n{} ", (Object)inMessage.toString());
        Optional weChatOptional = this.weChatRepository.findFirstByToken(token);
        Optional visitorOptional = this.userRepository.findByUsername(inMessage.getFromUser());
        if (weChatOptional.isPresent() && !visitorOptional.isPresent()) {
            this.logger.info("sessionFrom: {}", (Object)inMessage.getSessionFrom());
            JSONObject jsonObject = JSONObject.parseObject((String)inMessage.getSessionFrom());
            visitor = new User();
            visitor.setUid(JpaUtil.randomId());
            visitor.setUsername(inMessage.getFromUser());
            String nickname = jsonObject.getString("nickname") == null ? inMessage.getFromUser() : jsonObject.getString("nickname");
            visitor.setNickname(nickname);
            visitor.setEmail(inMessage.getFromUser() + "@bytedesk.com");
            visitor.setPassword(inMessage.getFromUser());
            visitor.setSubDomain(((WeChat)weChatOptional.get()).getUser().getSubDomain());
            visitor.setClient(ClientConsts.CLIENT_WECHAT_MINI);
            this.userService.saveVisitor(visitor);
        } else {
            visitor = (User)visitorOptional.get();
        }
        WorkGroup workGroup = ((WeChat)weChatOptional.get()).getWorkGroup();
        this.logger.info("save message to mysql");
        Message message = new Message();
        message.setMid(JpaUtil.randomId());
        message.setWid(workGroup.getWid());
        message.setType(inMessage.getMsgType());
        message.setSessionType("thread");
        message.setStatus("stored");
        message.setUser(visitor);
        message.setClient(ClientConsts.CLIENT_WECHAT_MINI);
        Optional threadOptional = this.threadRepository.findFirstByVisitorAndWorkGroupAndAppointedAndClosed(visitor, workGroup, false, false);
        if (threadOptional.isPresent()) {
            thread = (Thread)threadOptional.get();
        } else {
            thread = new Thread();
            thread.setTid(JpaUtil.randomId());
            thread.setToken(token);
            thread.setType("thread");
            thread.setContent(visitor.getNickname() + " \u8bf7\u6c42\u4f1a\u8bdd");
            thread.setTimestamp(new Date());
            thread.setUnreadCount(0);
            thread.setVisitor(visitor);
            thread.setWorkGroup(workGroup);
            thread.setStartedAt(new Date());
            this.threadRepository.save((Object)thread);
        }
        message.setThread(thread);
        switch (inMessage.getMsgType()) {
            case "text": {
                message.setContent(inMessage.getContent());
                thread.setContent(inMessage.getContent());
                break;
            }
            case "image": {
                message.setPicUrl(inMessage.getPicUrl());
                String fileName = inMessage.getFromUser() + "_" + JpaUtil.randomId() + ".png";
                String imageUrl = this.aliYunOss.saveWeChatImageUrl(fileName, inMessage.getPicUrl());
                message.setImageUrl(imageUrl);
                thread.setContent("[\u56fe\u7247]");
                break;
            }
            case "event": {
                if (inMessage.getEvent() == null || !inMessage.getEvent().equals("user_enter_tempsession")) break;
                message.setContent("\u8bbf\u5ba2\u8fdb\u5165\u4f1a\u8bdd");
                break;
            }
            default: {
                this.logger.info("other MINI message type");
            }
        }
        this.messageRepository.save((Object)message);
        this.logger.info("route");
        if (threadOptional.isPresent()) {
            if (!thread.isCurrent()) {
                thread.increaseUnreadCount();
            }
            thread.setTimestamp(message.getCreatedAt());
            this.threadRepository.save((Object)thread);
            this.messageService.autoReply(message);
            this.rabbitTemplate.convertAndSend("amq.topic", "message.thread.#", (Object)message);
        } else {
            this.routeService.route(workGroup, thread, visitor);
        }
        return "";
    }
}

