/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restwechat.controller.v1;

import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.model.WeChat;
import io.xiaper.jpa.model.WeChatUserInfo;
import io.xiaper.jpa.model.WorkGroup;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.repository.WeChatRepository;
import io.xiaper.jpa.repository.WeChatUserInfoRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.UserService;
import io.xiaper.mq.service.impl.RouteServiceImpl;
import io.xiaper.mq.service.wechat.WeChatMpService;
import io.xiaper.rest.controller.v1.BaseController;
import io.xiaper.rest.util.AliYunOss;
import java.io.File;
import java.util.Date;
import java.util.Optional;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpMaterialService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat/mp"})
public class WeChatMpController
extends BaseController {
    @Autowired
    WeChatRepository weChatRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserService userService;
    @Autowired
    RouteServiceImpl routeService;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    MessageService messageService;
    @Autowired
    WeChatMpService weChatMpService;
    @Autowired
    WeChatUserInfoRepository weChatUserInfoRepository;
    @Autowired
    AliYunOss aliYunOss;

    @GetMapping(value={"/push/{token}"})
    public String authGet(@PathVariable String token, @RequestParam(name="signature", required=false) String signature, @RequestParam(name="timestamp", required=false) String timestamp, @RequestParam(name="nonce", required=false) String nonce, @RequestParam(name="echostr", required=false) String echostr) {
        this.logger.info("\n\u63a5\u6536\u5230\u6765\u81ea\u5fae\u4fe1\u670d\u52a1\u5668\u7684\u8ba4\u8bc1\u6d88\u606f\uff1a[{}, {}, {}, {}]", new Object[]{signature, timestamp, nonce, echostr});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signature, timestamp, nonce, echostr})) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6838\u5b9e!");
        }
        if (SHA1.gen((String[])new String[]{token, timestamp, nonce}).equals(signature)) {
            return echostr;
        }
        return "\u975e\u6cd5\u8bf7\u6c42";
    }

    @PostMapping(value={"/push/{token}"})
    public String post(@PathVariable String token, @RequestBody String requestBody, @RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="openid") String openid, @RequestParam(name="encrypt_type", required=false) String encType, @RequestParam(name="msg_signature", required=false) String msgSignature) {
        Thread thread;
        this.logger.info("\n\u63a5\u6536\u516c\u4f17\u53f7\u8bf7\u6c42\uff1a[openid=[{}], [signature=[{}], encType=[{}], msgSignature=[{}], timestamp=[{}], nonce=[{}], requestBody=[\n{}\n] ", new Object[]{openid, signature, encType, msgSignature, timestamp, nonce, requestBody});
        WxMpXmlMessage inMessage = WxMpXmlMessage.fromEncryptedXml((String)requestBody, (WxMpConfigStorage)this.weChatMpService.getMpService(token).getWxMpConfigStorage(), (String)timestamp, (String)nonce, (String)msgSignature);
        this.logger.debug("\n\u6d88\u606f\u89e3\u5bc6\u540e\u5185\u5bb9\u4e3a\uff1a\n{} ", (Object)inMessage.toString());
        if (inMessage.getMsgType().equals("event") && inMessage.getEventKey() != null && inMessage.getEventKey().equals("unsubscribe")) {
            return "";
        }
        Optional weChatOptional = this.weChatRepository.findFirstByToken(token);
        User visitor = new User();
        Optional visitorOptional = this.userRepository.findByUsername(inMessage.getFromUser());
        if (weChatOptional.isPresent() && !visitorOptional.isPresent()) {
            try {
                WxMpUser wxMpUser = this.weChatMpService.getMpService(token).getUserService().userInfo(inMessage.getFromUser());
                this.logger.info("save user info");
                visitor = new User();
                visitor.setUid(JpaUtil.randomId());
                visitor.setUsername(wxMpUser.getOpenId());
                visitor.setNickname(wxMpUser.getNickname() == null ? wxMpUser.getOpenId() : wxMpUser.getNickname());
                visitor.setEmail(wxMpUser.getOpenId() + "@bytedesk.com");
                visitor.setAvatar(wxMpUser.getHeadImgUrl());
                visitor.setPassword(wxMpUser.getOpenId());
                visitor.setSubDomain(((WeChat)weChatOptional.get()).getUser().getSubDomain());
                visitor.setClient(ClientConsts.CLIENT_WECHAT_MP);
                this.userService.saveVisitor(visitor);
                WeChatUserInfo weChatUserInfo = new WeChatUserInfo();
                weChatUserInfo.setSubscribe(wxMpUser.getSubscribe().booleanValue());
                weChatUserInfo.setOpenId(wxMpUser.getOpenId());
                weChatUserInfo.setNickname(visitor.getNickname());
                weChatUserInfo.setSex(wxMpUser.getSex());
                weChatUserInfo.setCity(wxMpUser.getCity());
                weChatUserInfo.setLanguage(wxMpUser.getLanguage());
                weChatUserInfo.setProvince(wxMpUser.getProvince());
                weChatUserInfo.setCountry(wxMpUser.getCountry());
                weChatUserInfo.setHeadImgUrl(wxMpUser.getHeadImgUrl());
                weChatUserInfo.setSubscribeTime(wxMpUser.getSubscribeTime());
                weChatUserInfo.setUnionId(wxMpUser.getUnionId());
                weChatUserInfo.setRemark(wxMpUser.getRemark());
                weChatUserInfo.setGroupId(wxMpUser.getGroupId());
                weChatUserInfo.setWeChat((WeChat)weChatOptional.get());
                weChatUserInfo.setUser(visitor);
                this.weChatUserInfoRepository.save((Object)weChatUserInfo);
            }
            catch (WxErrorException e) {
                e.printStackTrace();
            }
        } else {
            visitor = (User)visitorOptional.get();
        }
        WorkGroup workGroup = ((WeChat)weChatOptional.get()).getWorkGroup();
        Message message = new Message();
        message.setMid(JpaUtil.randomId());
        message.setWid(workGroup.getWid());
        message.setType(inMessage.getMsgType());
        message.setSessionType("thread");
        message.setStatus("stored");
        message.setUser(visitor);
        message.setClient(ClientConsts.CLIENT_WECHAT_MP);
        Optional threadOptional = this.threadRepository.findFirstByVisitorAndWorkGroupAndAppointedAndClosed(visitor, workGroup, false, false);
        if (threadOptional.isPresent()) {
            thread = (Thread)threadOptional.get();
        } else {
            thread = new Thread();
            thread.setTid(JpaUtil.randomId());
            thread.setToken(token);
            thread.setType("thread");
            thread.setContent(visitor.getNickname() + " \u8bf7\u6c42\u4f1a\u8bdd");
            thread.setTimestamp(new Date());
            thread.setUnreadCount(0);
            thread.setVisitor(visitor);
            thread.setWorkGroup(workGroup);
            thread.setStartedAt(new Date());
            this.threadRepository.save((Object)thread);
        }
        message.setThread(thread);
        switch (inMessage.getMsgType()) {
            case "text": {
                message.setContent(inMessage.getContent());
                thread.setContent(inMessage.getContent());
                break;
            }
            case "image": {
                message.setPicUrl(inMessage.getPicUrl());
                String imageName = inMessage.getFromUser() + "_" + JpaUtil.randomId() + ".png";
                String imageUrl = this.aliYunOss.saveWeChatImageUrl(imageName, inMessage.getPicUrl());
                message.setImageUrl(imageUrl);
                message.setMediaId(inMessage.getMediaId());
                thread.setContent("[\u56fe\u7247]");
                break;
            }
            case "voice": {
                String voiceName = inMessage.getFromUser() + "_" + JpaUtil.randomId() + "." + inMessage.getFormat();
                WxMpMaterialService mpMaterialService = this.weChatMpService.getMpService(token).getMaterialService();
                try {
                    File voiceFile = mpMaterialService.mediaDownload(inMessage.getMediaId());
                    String voiceUrl = this.aliYunOss.saveWeChatVoice(voiceName, voiceFile);
                    message.setVoiceUrl(voiceUrl);
                    message.setMediaId(inMessage.getMediaId());
                    message.setFormat(inMessage.getFormat());
                }
                catch (WxErrorException e) {
                    e.printStackTrace();
                }
                thread.setContent("[\u8bed\u97f3]");
                break;
            }
            case "video": 
            case "shortvideo": {
                String videoName = inMessage.getFromUser() + "_" + JpaUtil.randomId();
                String videoThumbName = inMessage.getFromUser() + "_" + JpaUtil.randomId();
                try {
                    File videoFile = this.getMaterialService(token).mediaDownload(inMessage.getMediaId());
                    String videoUrl = this.aliYunOss.saveWeChatVideo(videoName, videoFile);
                    message.setVideoOrShortUrl(videoUrl);
                    File videoThumbFile = this.getMaterialService(token).mediaDownload(inMessage.getThumbMediaId());
                    String videoThumbUrl = this.aliYunOss.saveWeChatThumb(videoThumbName, videoThumbFile);
                    message.setVideoOrShortThumbUrl(videoThumbUrl);
                }
                catch (WxErrorException e) {
                    e.printStackTrace();
                }
                message.setMediaId(inMessage.getMediaId());
                message.setThumbMediaId(inMessage.getThumbMediaId());
                thread.setContent("[\u89c6\u9891]");
                break;
            }
            case "location": {
                message.setLocationX(inMessage.getLocationX().doubleValue());
                message.setLocationY(inMessage.getLocationY().doubleValue());
                message.setScale(inMessage.getScale().doubleValue());
                message.setLabel(inMessage.getLabel());
                thread.setContent("[\u5730\u7406\u4f4d\u7f6e]");
                break;
            }
            case "link": {
                message.setTitle(inMessage.getTitle());
                message.setDescription(inMessage.getDescription());
                message.setUrl(inMessage.getUrl());
                thread.setContent("[\u94fe\u63a5]");
                break;
            }
            case "event": {
                if (!inMessage.getEvent().equals("CLICK") || inMessage.getEventKey().equals("event_agent") || inMessage.getEventKey().equals("event_about")) {
                    // empty if block
                }
                message.setContent(inMessage.getEventKey());
                thread.setContent("[\u4e8b\u4ef6]:" + inMessage.getEvent());
                break;
            }
            default: {
                this.logger.info("other MP message type");
                thread.setContent("[\u5176\u4ed6]");
            }
        }
        this.messageRepository.save((Object)message);
        this.logger.info("route");
        if (threadOptional.isPresent()) {
            if (!thread.isCurrent()) {
                thread.increaseUnreadCount();
            }
            thread.setTimestamp(message.getCreatedAt());
            this.threadRepository.save((Object)thread);
            if (!inMessage.getMsgType().equals("event")) {
                this.rabbitTemplate.convertAndSend("amq.topic", "message.thread.#", (Object)message);
                this.messageService.autoReply(message);
            }
        } else if (!inMessage.getMsgType().equals("event")) {
            this.routeService.route(workGroup, thread, visitor);
        }
        return "";
    }

    private WxMpMaterialService getMaterialService(String token) {
        return this.weChatMpService.getMpService(token).getMaterialService();
    }
}

