package io.xiaper.restwechat.controller.v1;

import io.xiaper.jpa.constant.StatusConsts;
import io.xiaper.jpa.constant.TypeConsts;
import io.xiaper.jpa.model.Payment;
import io.xiaper.jpa.model.Recharge;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.jpa.util.JsonResult;
import io.xiaper.mq.service.PaymentService;
import io.xiaper.mq.service.RechargeService;
import io.xiaper.mq.service.UserService;
import io.xiaper.mq.service.wechat.WeChatPayService;
import io.xiaper.wechat.config.MyWxPayConfig;
import io.xiaper.wechat.sdk.WXPay;
import io.xiaper.wechat.sdk.WXPayUtil;
import io.xiaper.wechat.sdk.WXPayXmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * 微信支付开发文档：https://pay.weixin.qq.com/wiki/doc/api/native.php?chapter=6_5
 * @author bytedesk.com on 2019/3/11
 */
@RestController
@RequestMapping("/wechat/pay")
public class WeChatPayController {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

//    @Value("${wechat.pay.appid}")
//    private String appId;
//
//    @Value("${wechat.pay.mch_id}")
//    private String mchId;

    @Value("${wechat.pay.key}")
    private String key;

//    @Value("${wechat.pay.notify_url}")
//    private String notify_url;

    private static final String return_code = "SUCCESS";

    @Autowired
    WeChatPayService weChatPayService;

    @Autowired
    RechargeService rechargeService;

    /**
     * 接收支付通知
     * 微信以数据流的形式通知
     *
     * TODO: 签名验证,并校验返回的订单金额是否与商户侧的订单金额一致
     *
     * @see <a href="https://pay.weixin.qq.com/wiki/doc/api/native.php">文档</a>
     *
     * @param request request
     * @return string
     */
    @GetMapping("/notification")
    public String notification(HttpServletRequest request) {
        logger.info("notification received");
        //
        String notifyContentXML = weChatPayService.parseRequest(request);
        logger.info("notifyContentXML: " + notifyContentXML);

        try {

            Map<String, String> notifyMap = WXPayUtil.xmlToMap(notifyContentXML);
            boolean isSignatureValid = WXPayUtil.isSignatureValid(notifyContentXML, key);
            String returnCode = notifyMap.get("return_code");

            // 验证签名 && 返回成功
            if (isSignatureValid && return_code.equals(returnCode)) {

                // 用户标识
                String openid = notifyMap.get("openid");
                // 交易类型
                String trade_type = notifyMap.get("trade_type");
                // 付款银行
                String bank_type = notifyMap.get("bank_type");
                // 订单金额, 单位：分
                int total_fee = Integer.valueOf(notifyMap.get("total_fee"));
                // 现金支付金额，单位：分
                int cash_fee = Integer.valueOf(notifyMap.get("cash_fee"));
                // 微信支付订单号
                String transaction_id = notifyMap.get("transaction_id");
                // 商户订单号
                String out_trade_no = notifyMap.get("out_trade_no");
                // 支付完成时间
                String time_end = notifyMap.get("time_end");

                //
                Optional<Recharge> rechargeOptional = rechargeService.findByRid(out_trade_no);
                if (rechargeOptional.isPresent()) {

                    rechargeOptional.get().setStatus(StatusConsts.PAY_STATUS_SUCCESS);
                    rechargeService.save(rechargeOptional.get());

                } else {

                    logger.info("未找到 商户内订单号");
                }

            } else {
                // 支付失败
                logger.info("pay notification: 验证签名失败 或者 支付失败");
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        // 返回结果
        Map<String, String> resultMap = new HashMap<>(2);
        resultMap.put("return_code", "<![CDATA[SUCCESS]]>");
        resultMap.put("return_msg", "<![CDATA[OK]]>");

        String result = null;
        try {
            result = WXPayUtil.mapToXml(resultMap);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return result;
    }




}








