/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.restwechat.controller.v1;

import io.xiaper.jpa.model.Recharge;
import io.xiaper.mq.service.RechargeService;
import io.xiaper.mq.service.wechat.WeChatPayService;
import io.xiaper.wechat.sdk.WXPayUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat/pay"})
public class WeChatPayController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${wechat.pay.key}")
    private String key;
    private static final String return_code = "SUCCESS";
    @Autowired
    WeChatPayService weChatPayService;
    @Autowired
    RechargeService rechargeService;

    @GetMapping(value={"/notification"})
    public String notification(HttpServletRequest request) {
        this.logger.info("notification received");
        String notifyContentXML = this.weChatPayService.parseRequest(request);
        this.logger.info("notifyContentXML: " + notifyContentXML);
        try {
            Map notifyMap = WXPayUtil.xmlToMap((String)notifyContentXML);
            boolean isSignatureValid = WXPayUtil.isSignatureValid((String)notifyContentXML, (String)this.key);
            String returnCode = (String)notifyMap.get("return_code");
            if (isSignatureValid && return_code.equals(returnCode)) {
                String openid = (String)notifyMap.get("openid");
                String trade_type = (String)notifyMap.get("trade_type");
                String bank_type = (String)notifyMap.get("bank_type");
                int total_fee = Integer.valueOf((String)notifyMap.get("total_fee"));
                int cash_fee = Integer.valueOf((String)notifyMap.get("cash_fee"));
                String transaction_id = (String)notifyMap.get("transaction_id");
                String out_trade_no = (String)notifyMap.get("out_trade_no");
                String time_end = (String)notifyMap.get("time_end");
                Optional rechargeOptional = this.rechargeService.findByRid(out_trade_no);
                if (rechargeOptional.isPresent()) {
                    ((Recharge)rechargeOptional.get()).setStatus("success");
                    this.rechargeService.save((Recharge)rechargeOptional.get());
                } else {
                    this.logger.info("\u672a\u627e\u5230 \u5546\u6237\u5185\u8ba2\u5355\u53f7");
                }
            } else {
                this.logger.info("pay notification: \u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25 \u6216\u8005 \u652f\u4ed8\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        resultMap.put("return_code", "<![CDATA[SUCCESS]]>");
        resultMap.put("return_msg", "<![CDATA[OK]]>");
        String result = null;
        try {
            result = WXPayUtil.mapToXml(resultMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

