package io.xiaper.mq.config;

import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import io.xiaper.jpa.constant.MqConsts;
import org.springframework.context.annotation.Bean;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessageType;
import org.springframework.stereotype.Component;

import javax.jms.Queue;
import javax.jms.Topic;

/**
 * @author xiaper.io on 2018/11/17
 */
@Component
public class ActiveConfig {

    @Bean
    public Topic topicPlatform() {
        return new ActiveMQTopic(MqConsts.TOPIC_PLATFORM_MESSAGE);
    }

    @Bean
    public Topic topicCompany() {
        return new ActiveMQTopic(MqConsts.TOPIC_COMPANY_MESSAGE);
    }

    @Bean
    public Topic topicWorkGroup() {
        return new ActiveMQTopic(MqConsts.TOPIC_WORK_GROUP_MESSAGE);
    }

    @Bean
    public Topic topicGroup() {
        return new ActiveMQTopic(MqConsts.TOPIC_GROUP_MESSAGE);
    }

    @Bean
    public Topic topicContact() {
        return new ActiveMQTopic(MqConsts.TOPIC_CONTACT_MESSAGE);
    }

    @Bean
    public Topic topicThread() {
        return new ActiveMQTopic(MqConsts.TOPIC_THREAD_MESSAGE);
    }

    @Bean
    public Topic topicUser() {
        return new ActiveMQTopic(MqConsts.TOPIC_USER_MESSAGE);
    }


//    @Bean
//    public Queue queuePlatform() {
//        return new ActiveMQQueue(MqConsts.TOPIC_PLATFORM_MESSAGE);
//    }
//
//    @Bean
//    public Queue queueCompany() {
//        return new ActiveMQQueue(MqConsts.TOPIC_COMPANY_MESSAGE);
//    }
//
//    @Bean
//    public Queue queueWorkGroup() {
//        return new ActiveMQQueue(MqConsts.TOPIC_WORK_GROUP_MESSAGE);
//    }
//
//    @Bean
//    public Queue queueGroup() {
//        return new ActiveMQQueue(MqConsts.TOPIC_GROUP_MESSAGE);
//    }
//
//    @Bean
//    public Queue queueContact() {
//        return new ActiveMQQueue(MqConsts.TOPIC_CONTACT_MESSAGE);
//    }
//
//    @Bean
//    public Queue queueThread() {
//        return new ActiveMQQueue(MqConsts.TOPIC_THREAD_MESSAGE);
//    }
//
//    @Bean
//    public Queue queueUser() {
//        return new ActiveMQQueue(MqConsts.TOPIC_USER_MESSAGE);
//    }


    /**
     * 传递对象必须
     *
     * @return object
     */
    @Bean
    public MessageConverter jacksonJmsMessageConverter() {
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setTargetType(MessageType.TEXT);
        converter.setTypeIdPropertyName("_type");
        return converter;
    }



}
