package io.xiaper.mq.stomp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.stomp.StompReactorNettyCodec;
import org.springframework.messaging.tcp.reactor.ReactorNettyTcpClient;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

import java.net.InetSocketAddress;

/**
 *
 * @author xiaper.io
 */
@Configuration
@EnableWebSocketMessageBroker
public class StompConfig implements WebSocketMessageBrokerConfigurer {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${spring.activemq.user}")
    private String systemLogin;

    @Value("${spring.activemq.password}")
    private String systemPasscode;

    @Value("${spring.activemq.stomp.login}")
    private String clientLogin;

    @Value("${spring.activemq.stomp.passcode}")
    private String clientPasscode;

    /**
     * setAllowedOrigins 解决跨域问题
     *
     * @param registry registry
     */
    @Override
    public void registerStompEndpoints(StompEndpointRegistry registry) {
        logger.info("registerStompEndpoints");
        registry.addEndpoint("/stomp").setAllowedOrigins("*").withSockJS();
    }

    /**
     * 静态连接一台broker：
     * .setRelayHost(relayHost).setRelayPort(relayPort)
     * .setClientLogin(clientLogin).setClientPasscode(clientPasscode)
     * .setSystemLogin(systemLogin).setSystemPasscode(systemPasscode);
     *
     * 动态配置多台broker：
     * .setTcpClient(createTcpClient());
     *
     * @param config
     */
    @Override
    public void configureMessageBroker(MessageBrokerRegistry config) {
        logger.info("configureMessageBroker");

        // 重要：不能用enableSimpleBroker，要使用Relay版本，方便集群
//        config.enableStompBrokerRelay("/topic", "/queue")
//                .setClientLogin(clientLogin).setClientPasscode(clientPasscode)
//                .setSystemLogin(systemLogin).setSystemPasscode(systemPasscode)
//                .setTcpClient(createTcpClient());

        config.enableSimpleBroker("/topic", "/queue");
        config.setApplicationDestinationPrefixes("/app");
        config.setUserDestinationPrefix("/user");
        // 保证消息有序性，启用有开销，必要时开启
        // config.setPreservePublishOrder(true);
    }

    /**
     * 断线重连到其他服务器
     * https://docs.spring.io/spring/docs/current/spring-framework-reference/web.html#websocket-stomp-handle-broker-relay-configure
     * @return client
     */
    private ReactorNettyTcpClient<byte[]> createTcpClient() {
        logger.info("createTcpClient");

        return new ReactorNettyTcpClient<>(
                client -> client.addressSupplier(() -> {

                    return new InetSocketAddress("121.41.95.115", 61613);
                })
        , new StompReactorNettyCodec());
    }

}



//    @Value("${spring.activemq.host}")
//    private String relayHost;
//
//    @Value("${spring.activemq.stomp.port}")
//    private int relayPort;
//
//    @Value("${spring.activemq.user}")
//    private String systemLogin;
//
//    @Value("${spring.activemq.password}")
//    private String systemPasscode;
//
//    @Value("${spring.activemq.stomp.login}")
//    private String clientLogin;
//
//    @Value("${spring.activemq.stomp.passcode}")
//    private String clientPasscode;