package io.xiaper.mq.stomp.listener;

import io.xiaper.jpa.constant.StatusConsts;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.StatusRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.StatusService;
import io.xiaper.mq.service.redis.RedisConnectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionConnectedEvent;

import java.security.Principal;
import java.util.Optional;

/**
 * published shortly after a SessionConnectEvent when the broker has sent a STOMP CONNECTED frame in response to the CONNECT
 *
 * https://docs.spring.io/spring/docs/current/spring-framework-reference/web.html#websocket-stomp-appplication-context-events
 * @author xiaper.io
 */
@Component
public class StompConnectedListener implements ApplicationListener<SessionConnectedEvent> {

    private static final Logger logger = LoggerFactory.getLogger(StompConnectedListener.class);

    @Autowired
    UserRepository userRepository;

    @Autowired
    StatusRepository statusRepository;

    @Autowired
    MessageRepository messageRepository;

    @Autowired
    ThreadRepository threadRepository;

    @Autowired
    RedisConnectService redisConnectService;

    @Autowired
    StatusService statusService;

    @Autowired
    MessageService messageService;


    @Override
    public void onApplicationEvent(SessionConnectedEvent sessionConnectedEvent) {
        logger.info(sessionConnectedEvent.toString());

        MessageHeaders headers = sessionConnectedEvent.getMessage().getHeaders();
        Principal principal = SimpMessageHeaderAccessor.getUser(headers);
        if (principal == null) {
            return;
        }
        Optional<User> userOptional = userRepository.findByUsername(principal.getName());
        if (!userOptional.isPresent()) {
            return;
        }
        User user = userOptional.get();
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);

        // 更新连线状态
        redisConnectService.updateConnectedStatus(user);

        // 通知上线
        messageService.notifyConnected(user);

//        // 持久化，用户上线
//        Status status = new Status();
//        status.setStatus(StatusConsts.USER_STATUS_CONNECTED);
//        status.setSessionId(sessionId);
//        status.setUser(user);
//        if (user.getClient() != null) {
//            status.setClient(user.getClient());
//        }
//        statusRepository.save(status);

        if (!user.isVisitor()) {
            statusService.notifyConnectionStatus(user, StatusConsts.USER_STATUS_CONNECTED);
        }

    }

}

