/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.config;

import io.xiaper.jpa.model.Group;
import io.xiaper.jpa.model.Invite;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Notice;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.Transfer;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.StatusService;
import io.xiaper.mq.service.ThreadService;
import io.xiaper.mq.service.TransformService;
import io.xiaper.mq.service.redis.RedisConnectService;
import io.xiaper.mq.service.redis.RedisStatisticService;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
public class ActiveMessageListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    MessageService messageService;
    @Autowired
    SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    StatusService statusService;
    @Autowired
    RedisConnectService redisConnectService;
    @Autowired
    RedisStatisticService redisStatisticService;
    @Autowired
    TransformService transformService;
    @Autowired
    ThreadService threadService;

    @JmsListener(destination="message.platform.#")
    public void receivePlatformMessage(Message message) {
        this.logger.info("receive from platformQueue message queue, content: {}", (Object)message.toString());
    }

    @JmsListener(destination="message.subDomain.#")
    public void receiveCompanyMessage(Message message) {
        this.logger.info("receive from companyQueue message queue, content: {}", (Object)message.toString());
        if (null != message.getUser()) {
            String subDomain = message.getUser().getSubDomain();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/subDomain." + subDomain), (Object)message);
        }
    }

    @JmsListener(destination="message.workGroup.#")
    public void receiveWorkGroupMessage(Message message) {
        this.logger.info("receive from workGroupQueue message queue, content: {}", (Object)message.toString());
        if (message.getType().equals("notification_queue")) {
            Map messageMap = this.transformService.getWorkGroupQueueMessageMap(message);
            String wid = message.getWid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/workGroup." + wid), (Object)messageMap);
        } else {
            String wid = message.getWid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/workGroup." + wid), (Object)message);
        }
    }

    @JmsListener(destination="message.group.#")
    public void receiveGroupMessage(Message message) {
        this.logger.info("receive from groupQueue message queue, content: {}", (Object)message.toString());
        Map messageMap = this.transformService.getGroupMessageMap(message);
        String gid = message.getGid();
        this.simpMessagingTemplate.convertAndSend((Object)("/topic/group." + gid), (Object)messageMap);
    }

    @JmsListener(destination="message.contact.#")
    public void receiveContactMessage(Message message) {
        this.logger.info("receive from contactQueue message queue, content: {}", (Object)message.toString());
        Map messageMap = this.transformService.getContactMessageMap(message);
        String cid = message.getCid();
        this.simpMessagingTemplate.convertAndSend((Object)("/topic/contact." + cid), (Object)messageMap);
        User user = message.getThread().getAgent();
        User contact = message.getThread().getContact();
        Thread thread = this.threadService.getContactThread(contact, user);
        message.setThread(thread);
        messageMap = this.transformService.getContactMessageMap(message);
        String uid = message.getUser().getUid();
        this.simpMessagingTemplate.convertAndSend((Object)("/topic/contact." + uid), (Object)messageMap);
    }

    @JmsListener(destination="message.thread.#")
    public void receiveThreadMessage(Message message) {
        this.logger.info("receive from threadQueue message queue, content: {}", (Object)message.toString());
        if (null != message.getThread()) {
            String tid = message.getThread().getTid();
            if (message.getType().equals("notification_preview")) {
                Map messageMap = this.transformService.getThreadPreviewMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else if (message.getType().equals("notification_receipt")) {
                Map messageMap = this.transformService.getThreadReceiptMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else if (message.getType().equals("text") || message.getType().equals("image") || message.getType().equals("file") || message.getType().equals("voice") || message.getType().equals("video") || message.getType().equals("shortvideo") || message.getType().equals("location") || message.getType().equals("link") || message.getType().equals("notification_agent_close") || message.getType().equals("notification_visitor_close") || message.getType().equals("notification_auto_close") || message.getType().equals("notification_invite_rate") || message.getType().equals("notification_rate_result") || message.getType().equals("notification_webrtc_invite") || message.getType().equals("notification_webrtc_cancel") || message.getType().equals("notification_webrtc_accept") || message.getType().equals("notification_webrtc_reject") || message.getType().equals("notification_webrtc_ready") || message.getType().equals("notification_webrtc_busy") || message.getType().equals("notification_webrtc_close")) {
                this.logger.info("\u5904\u7406\u6587\u672c\u3001\u56fe\u7247\u3001\u8fde\u63a5\u3001webrtc \u6d88\u606f {}", (Object)message.getType());
                Map messageMap = this.transformService.getThreadContentMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else if (message.getType().equals("notification_connect") || message.getType().equals("notification_disconnect")) {
                Map messageMap = this.transformService.getThreadConnectionMessageMap(message);
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)messageMap);
            } else {
                this.logger.warn("\u5904\u7406\u5176\u4ed6\u6d88\u606f {}", (Object)message.getType());
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/thread." + tid), (Object)message);
            }
        }
    }

    @JmsListener(destination="message.user.#")
    public void receiveUserMessage(Message message) {
        this.logger.info("receive from userQueue message queue, content: {}", (Object)message.toString());
        if (message.getType().equals("notification_transfer")) {
            Map messageMap = this.transformService.getUserTransferMessageMap(message);
            Transfer threadTransfer = message.getTransfer();
            if (null != threadTransfer) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + threadTransfer.getToUser().getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_transfer_accept") || message.getType().equals("notification_transfer_reject")) {
            Map messageMap = this.transformService.getUserTransferAcceptRejectMessageMap(message);
            Transfer threadTransfer = message.getTransfer();
            if (null != threadTransfer) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + threadTransfer.getFromUser().getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_invite")) {
            Map messageMap = this.transformService.getUserInviteMessageMap(message);
            Invite threadInvite = message.getInvite();
            if (null != threadInvite) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + threadInvite.getToUser().getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_invite_accept") || message.getType().equals("notification_invite_reject")) {
            Map messageMap = this.transformService.getUserInviteAcceptRejectMessageMap(message);
            Invite threadInvite = message.getInvite();
            if (null != threadInvite) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + threadInvite.getFromUser().getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_kickoff")) {
            Map messageMap = this.transformService.getUserKickoffMessageMap(message);
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + message.getUser().getUid()), (Object)messageMap);
        } else if (message.getType().equals("notification_thread")) {
            Map messageMap = this.transformService.getUserThreadMessageMap(message);
            User agent = message.getThread().getAgent();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + agent.getUid()), (Object)messageMap);
        } else if (message.getType().equals("notification_group_create")) {
            Map messageMap = this.transformService.getUserGroupCreateMessageMap(message);
            Group group = message.getGroup();
            Set userSet = group.getMembers();
            for (User user : userSet) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + user.getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_group_invite")) {
            Map messageMap = this.transformService.getUserGroupInviteMessageMap(message);
            Invite invite = message.getInvite();
            String uid = invite.getToUser().getUid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_apply")) {
            Map messageMap = this.transformService.getUserGroupApplyMessageMap(message);
            Notice notice = message.getNotice();
            Set admins = notice.getUsers();
            for (User admin : admins) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + admin.getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_group_apply_approve")) {
            Map messageMap = this.transformService.getUserGroupApplyApproveMessageMap(message);
            Notice notice = message.getNotice();
            String uid = notice.getUser().getUid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_apply_deny")) {
            Map messageMap = this.transformService.getUserGroupApplyDenyMessageMap(message);
            Notice notice = message.getNotice();
            String uid = notice.getUser().getUid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_transfer")) {
            Map messageMap = this.transformService.getUserGroupTransferMessageMap(message);
            Notice notice = message.getNotice();
            Set admins = notice.getUsers();
            for (User admin : admins) {
                this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + admin.getUid()), (Object)messageMap);
            }
        } else if (message.getType().equals("notification_group_transfer_accept")) {
            Map messageMap = this.transformService.getUserGroupTransferAcceptMessageMap(message);
            Notice notice = message.getNotice();
            String uid = notice.getUser().getUid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (message.getType().equals("notification_group_transfer_reject")) {
            Map messageMap = this.transformService.getUserGroupTransferRejectMessageMap(message);
            Notice notice = message.getNotice();
            String uid = notice.getUser().getUid();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + uid), (Object)messageMap);
        } else if (!(message.getType().equals("notification_group_kick") || message.getType().equals("notification_group_mute") || message.getType().equals("notification_group_withdraw") || message.getType().equals("notification_group_dismiss") || null == message.getThread() || null == message.getThread().getAgent())) {
            User agent = message.getThread().getAgent();
            this.simpMessagingTemplate.convertAndSend((Object)("/topic/user." + agent.getUid()), (Object)message);
        }
    }
}

