/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.stomp;

import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.stomp.StompReactorNettyCodec;
import org.springframework.messaging.tcp.reactor.ReactorNettyCodec;
import org.springframework.messaging.tcp.reactor.ReactorNettyTcpClient;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@EnableWebSocketMessageBroker
public class StompConfig
implements WebSocketMessageBrokerConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${spring.activemq.user}")
    private String systemLogin;
    @Value(value="${spring.activemq.password}")
    private String systemPasscode;
    @Value(value="${spring.activemq.stomp.login}")
    private String clientLogin;
    @Value(value="${spring.activemq.stomp.passcode}")
    private String clientPasscode;

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        this.logger.info("registerStompEndpoints");
        registry.addEndpoint(new String[]{"/stomp"}).setAllowedOrigins(new String[]{"*"}).withSockJS();
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        this.logger.info("configureMessageBroker");
        config.enableSimpleBroker(new String[]{"/topic", "/queue"});
        config.setApplicationDestinationPrefixes(new String[]{"/app"});
        config.setUserDestinationPrefix("/user");
    }

    private ReactorNettyTcpClient<byte[]> createTcpClient() {
        this.logger.info("createTcpClient");
        return new ReactorNettyTcpClient(client -> client.addressSupplier(() -> new InetSocketAddress("121.41.95.115", 61613)), (ReactorNettyCodec)new StompReactorNettyCodec());
    }
}

