/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.stomp;

import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.ThreadService;
import java.security.Principal;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.stereotype.Controller;

@Controller
public class StompController {
    private static final Logger logger = LoggerFactory.getLogger(StompController.class);
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    ThreadService threadService;
    @Autowired
    MessageService messageService;

    @MessageMapping(value={"/{messageSessionType}.{tid}"})
    public void message(Principal principal, @DestinationVariable(value="messageSessionType") String messageSessionType, @DestinationVariable(value="tid") String tid, Message message) {
        logger.info(messageSessionType + " message from:" + principal.getName() + " tid:" + tid + " content:" + message.toString());
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        if (messageSessionType.equals("thread")) {
            this.messageService.routeThreadMessage(tid, message, (User)userOptional.get());
        } else if (messageSessionType.equals("contact")) {
            this.messageService.routeContactMessage(tid, message, (User)userOptional.get());
        } else if (messageSessionType.equals("group")) {
            this.messageService.routeGroupMessage(tid, message, (User)userOptional.get());
        }
    }
}

