/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.stomp.listener;

import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.StatusRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.StatusService;
import io.xiaper.mq.service.redis.RedisConnectService;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionConnectedEvent;

@Component
public class StompConnectedListener
implements ApplicationListener<SessionConnectedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(StompConnectedListener.class);
    @Autowired
    UserRepository userRepository;
    @Autowired
    StatusRepository statusRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    RedisConnectService redisConnectService;
    @Autowired
    StatusService statusService;
    @Autowired
    MessageService messageService;

    public void onApplicationEvent(SessionConnectedEvent sessionConnectedEvent) {
        logger.info(sessionConnectedEvent.toString());
        MessageHeaders headers = sessionConnectedEvent.getMessage().getHeaders();
        Principal principal = SimpMessageHeaderAccessor.getUser((Map)headers);
        if (principal == null) {
            return;
        }
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        if (!userOptional.isPresent()) {
            return;
        }
        User user = (User)userOptional.get();
        String sessionId = SimpMessageHeaderAccessor.getSessionId((Map)headers);
        this.redisConnectService.updateConnectedStatus(user);
        this.messageService.notifyConnected(user);
        if (!user.isVisitor()) {
            this.statusService.notifyConnectionStatus(user, "connected");
        }
    }
}

