/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.stomp.listener;

import io.xiaper.jpa.constant.ClientConsts;
import io.xiaper.jpa.constant.UserConsts;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.Queue;
import io.xiaper.jpa.model.Role;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.QueueRepository;
import io.xiaper.jpa.repository.RoleRepository;
import io.xiaper.jpa.repository.StatusRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.jpa.util.JpaUtil;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.MessagingTemplate;
import io.xiaper.mq.service.StatusService;
import io.xiaper.mq.service.redis.RedisConnectService;
import io.xiaper.mq.service.redis.RedisStatisticService;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;

@Component
public class StompDisconnectListener
implements ApplicationListener<SessionDisconnectEvent> {
    private static final Logger logger = LoggerFactory.getLogger(StompDisconnectListener.class);
    @Autowired
    UserRepository userRepository;
    @Autowired
    StatusRepository statusRepository;
    @Autowired
    MessageRepository messageRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    RedisConnectService redisConnectService;
    @Autowired
    RedisStatisticService redisStatisticService;
    @Autowired
    StatusService statusService;
    @Autowired
    MessageService messageService;
    @Autowired
    MessagingTemplate messagingTemplate;

    public void onApplicationEvent(SessionDisconnectEvent sessionDisconnectEvent) {
        logger.info(sessionDisconnectEvent.toString());
        MessageHeaders headers = sessionDisconnectEvent.getMessage().getHeaders();
        Principal principal = SimpMessageHeaderAccessor.getUser((Map)headers);
        if (principal == null) {
            return;
        }
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        if (!userOptional.isPresent()) {
            return;
        }
        User user = (User)userOptional.get();
        String sessionId = SimpMessageHeaderAccessor.getSessionId((Map)headers);
        this.redisConnectService.updateDisconnectedStatus(user);
        this.messageService.notifyDisconnected(user);
        if (user.isVisitor()) {
            List queueList = this.queueRepository.findByVisitorAndStatus(user, "queuing");
            for (Queue queue : queueList) {
                Optional adminOptional;
                queue.leave();
                this.queueRepository.save((Object)queue);
                Message message = new Message();
                message.setMid(JpaUtil.randomId());
                message.setWid(queue.getWorkGroup().getWid());
                message.setThread(queue.getThread());
                message.setClient(ClientConsts.CLIENT_SYSTEM);
                message.setType("notification_queue_leave");
                message.setContent(user.getNickname() + "\u9000\u51fa\u6392\u961f");
                Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                message.setUser((User)userNotification.get());
                this.messageRepository.save((Object)message);
                this.messagingTemplate.convertAndSend("message.thread.#", (Object)message);
                Optional roleOptional = this.roleRepository.findByValue("ROLE_ADMIN");
                if (!roleOptional.isPresent() || !(adminOptional = this.userRepository.findBySubDomainAndRolesContains(user.getSubDomain(), (Role)roleOptional.get())).isPresent()) continue;
                this.redisStatisticService.removeCurrentQueue(((User)adminOptional.get()).getUid(), queue.getQid());
                this.redisStatisticService.increaseLeaveQueueCount(((User)adminOptional.get()).getUid());
            }
        }
        if (!user.isVisitor()) {
            this.statusService.notifyConnectionStatus(user, "disconnected");
        }
    }
}

