/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.stomp.listener;

import io.xiaper.jpa.constant.UserConsts;
import io.xiaper.jpa.model.Subscribe;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.SubscribeRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;

@Component
public class StompSubscribeListener
implements ApplicationListener<SessionSubscribeEvent> {
    private static final Logger logger = LoggerFactory.getLogger(StompSubscribeListener.class);
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    UserRepository userRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    SubscribeRepository subscribeRepository;
    @Autowired
    MessageRepository messageRepository;

    public void onApplicationEvent(SessionSubscribeEvent sessionSubscribeEvent) {
        String[] splitSlash;
        String[] splitDot;
        String threadTid;
        Optional threadOptional;
        String topicThreadPrefix;
        MessageHeaders headers = sessionSubscribeEvent.getMessage().getHeaders();
        Principal principal = SimpMessageHeaderAccessor.getUser((Map)headers);
        if (principal == null) {
            return;
        }
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        if (!userOptional.isPresent()) {
            return;
        }
        String sessionId = SimpMessageHeaderAccessor.getSessionId((Map)headers);
        String destination = SimpMessageHeaderAccessor.getDestination((Map)headers);
        if (destination.startsWith(topicThreadPrefix = "/topic/thread") && (threadOptional = this.threadRepository.findByTid(threadTid = (splitDot = (splitSlash = destination.split("/"))[splitSlash.length - 1].split("[.]"))[splitDot.length - 1])).isPresent()) {
            Optional userNotification;
            ((Thread)threadOptional.get()).setSessionId(sessionId);
            this.threadRepository.save(threadOptional.get());
            Optional subscribeOptional = this.subscribeRepository.findFirstByThreadAndUser((Thread)threadOptional.get(), (User)userOptional.get());
            if (!subscribeOptional.isPresent()) {
                Subscribe subscribe = new Subscribe();
                subscribe.setThread((Thread)threadOptional.get());
                subscribe.setUser((User)userOptional.get());
                this.subscribeRepository.save((Object)subscribe);
            }
            if ((userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION)).isPresent()) {
                // empty if block
            }
        }
    }
}

