/*
 * Decompiled with CFR 0.152.
 */
package io.xiaper.mq.stomp.listener;

import io.xiaper.jpa.constant.UserConsts;
import io.xiaper.jpa.model.Thread;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.SubscribeRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.messaging.SessionUnsubscribeEvent;

@Component
public class StompUnsubscribeListener
implements ApplicationListener<SessionUnsubscribeEvent> {
    private static final Logger logger = LoggerFactory.getLogger(StompUnsubscribeListener.class);
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    UserRepository userRepository;
    @Autowired
    ThreadRepository threadRepository;
    @Autowired
    SubscribeRepository subscribeRepository;
    @Autowired
    MessageRepository messageRepository;

    public void onApplicationEvent(SessionUnsubscribeEvent sessionUnsubscribeEvent) {
        String topicThreadPrefix;
        MessageHeaders headers = sessionUnsubscribeEvent.getMessage().getHeaders();
        Principal principal = SimpMessageHeaderAccessor.getUser((Map)headers);
        if (principal == null) {
            return;
        }
        Optional userOptional = this.userRepository.findByUsername(principal.getName());
        if (!userOptional.isPresent()) {
            return;
        }
        String sessionId = SimpMessageHeaderAccessor.getSessionId((Map)headers);
        String destination = SimpMessageHeaderAccessor.getDestination((Map)headers);
        if (destination.startsWith(topicThreadPrefix = "/topic/thread")) {
            String[] splitSlash = destination.split("/");
            String[] splitDot = splitSlash[splitSlash.length - 1].split("[.]");
            String threadTid = splitDot[splitDot.length - 1];
            logger.info("tid: {}", (Object)threadTid);
            Optional threadOptional = this.threadRepository.findByTid(threadTid);
            if (threadOptional.isPresent()) {
                this.subscribeRepository.deleteByThread((Thread)threadOptional.get());
                Optional userNotification = this.userRepository.findByUsername(UserConsts.USERNAME_NOTIFICATION);
                if (userNotification.isPresent()) {
                    // empty if block
                }
            }
        }
    }
}

