package io.xiaper.mq.stomp;

import io.xiaper.jpa.constant.TypeConsts;
import io.xiaper.jpa.model.Message;
import io.xiaper.jpa.model.User;
import io.xiaper.jpa.repository.MessageRepository;
import io.xiaper.jpa.repository.ThreadRepository;
import io.xiaper.jpa.repository.UserRepository;
import io.xiaper.mq.service.MessageService;
import io.xiaper.mq.service.ThreadService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.stereotype.Controller;

import java.security.Principal;
import java.util.Optional;

/**
 * https://docs.spring.io/spring/docs/current/spring-framework-reference/web.html#websocket-stomp
 *
 * @author xiaper.io
 */
@Controller
public class StompController {

    private final static Logger logger = LoggerFactory.getLogger(StompController.class);

    @Autowired
    ThreadRepository threadRepository;

    @Autowired
    UserRepository userRepository;

    @Autowired
    MessageRepository messageRepository;

//    @Autowired
//    RabbitTemplate rabbitTemplate;

//    @Autowired
//    JmsMessagingTemplate jmsMessagingTemplate;

    @Autowired
    ThreadService threadService;

    @Autowired
    MessageService messageService;

//    @Autowired
//    MessagingTemplate messagingTemplate;

    /**
     *
     * @param principal principal
     * @param messageSessionType type
     * @param tid tid
     * @param message msg
     */
    @MessageMapping("/{messageSessionType}.{tid}")
    public void message(Principal principal,
                       @DestinationVariable(value = "messageSessionType") String messageSessionType,
                       @DestinationVariable(value = "tid") String tid,
                       Message message) {

        logger.info(messageSessionType + " message from:" + principal.getName() + " tid:" + tid + " content:" + message.toString());

        Optional<User> userOptional = userRepository.findByUsername(principal.getName());

        if (messageSessionType.equals(TypeConsts.MESSAGE_SESSION_TYPE_THREAD)) {

            messageService.routeThreadMessage(tid, message, userOptional.get());

        } else if (messageSessionType.equals(TypeConsts.MESSAGE_SESSION_TYPE_CONTACT)) {

            messageService.routeContactMessage(tid, message, userOptional.get());

        } else if (messageSessionType.equals(TypeConsts.MESSAGE_SESSION_TYPE_GROUP)) {

            messageService.routeGroupMessage(tid, message, userOptional.get());
        }

    }


}





