package io.xiaper.mq.stomp.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.messaging.simp.broker.BrokerAvailabilityEvent;
import org.springframework.stereotype.Component;

/**
 * @author xiaper.io
 */
@Component
public class StompBrokerAvailabilityListener implements ApplicationListener<BrokerAvailabilityEvent> {

    private static final Logger logger = LoggerFactory.getLogger(StompBrokerAvailabilityListener.class);

    @Override
    public void onApplicationEvent(BrokerAvailabilityEvent brokerAvailabilityEvent) {
        //
        if (brokerAvailabilityEvent.isBrokerAvailable()) {
            logger.info("mq broker available: " + brokerAvailabilityEvent.toString());
        } else {
            logger.error("lost connection to mq broker: " + brokerAvailabilityEvent.toString());

        }
    }

}
