package io.xiaper.mq.converter;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author bytedesk.com on 2019/2/21
 */
public class ProtobufMessageConverter implements MessageConverter {

    private static Map<String, MessageLite.Builder> builderMap;

    static {
        builderMap = new HashMap<>();
//        builderMap.put(Event.class.getSimpleName(), Event.newBuilder());
    }

    @Override
    public Message toMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        String messageType = object.getClass().getSimpleName();
        if (!builderMap.containsKey(messageType)) {
            throw new MessageConversionException("not support message type:" + messageType);
        }
        messageProperties.setHeader("messageType",  messageType);
        MessageLite messageLite = (MessageLite)object;
        return new Message(messageLite.toByteArray(), messageProperties);
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        String messageType = message.getMessageProperties().getHeaders().get("messageType").toString();
        if (!builderMap.containsKey(messageType)) {
            throw new MessageConversionException("not support message type:" + messageType);
        }
        try {
            MessageLite.Builder builder = builderMap.get(messageType).clear();
            builder = builder.mergeFrom(message.getBody());
            return builder.build();
        } catch (InvalidProtocolBufferException e) {
            throw new MessageConversionException("deserialize message error", e);
        }
    }

}
